/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.gemini.engine.page.bmap;

import java.nio.ByteBuffer;
import org.apache.flink.runtime.state.gemini.engine.page.bmap.ByteBufferUtils;

public final class BinaryKey {
    private final int keyOffset;
    private final int keyLen;
    private final int keyHashCode;
    private final ByteBuffer bb;

    public BinaryKey(ByteBuffer data, int keyOffset, int keyLen, int keyHashCode) {
        this.keyOffset = keyOffset;
        this.keyLen = keyLen;
        this.bb = data;
        this.keyHashCode = keyHashCode;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BinaryKey binaryKey = (BinaryKey)o;
        return this.keyHashCode == binaryKey.keyHashCode && this.keyLen == binaryKey.keyLen && ByteBufferUtils.compareTo(this.bb, this.keyOffset, this.keyLen, binaryKey.bb, binaryKey.keyOffset, binaryKey.keyLen) == 0;
    }

    public int hashCode() {
        return this.keyHashCode;
    }

    public int getKeyOffset() {
        return this.keyOffset;
    }

    public int getKeyLen() {
        return this.keyLen;
    }

    public int getKeyHashCode() {
        return this.keyHashCode;
    }

    public ByteBuffer getBb() {
        return this.bb;
    }
}

