/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.gemini.engine.page.bmap;

import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.zip.CRC32;
import javax.annotation.Nullable;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.base.IntSerializer;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.core.memory.DataOutputViewStreamWrapper;
import org.apache.flink.runtime.state.gemini.engine.GRegionContext;
import org.apache.flink.runtime.state.gemini.engine.exceptions.GeminiRuntimeException;
import org.apache.flink.runtime.state.gemini.engine.filter.StateFilter;
import org.apache.flink.runtime.state.gemini.engine.memstore.GSValue;
import org.apache.flink.runtime.state.gemini.engine.page.DataPage;
import org.apache.flink.runtime.state.gemini.engine.page.GValueType;
import org.apache.flink.runtime.state.gemini.engine.page.bmap.BinaryKey;
import org.apache.flink.runtime.state.gemini.engine.page.bmap.BinaryValue;
import org.apache.flink.runtime.state.gemini.engine.page.bmap.BinaryValueForSplit;
import org.apache.flink.runtime.state.gemini.engine.page.bmap.BinaryValueImpl;
import org.apache.flink.runtime.state.gemini.engine.page.bmap.ByteBufferDataInputView;
import org.apache.flink.runtime.state.gemini.engine.page.bmap.ByteBufferUtils;
import org.apache.flink.runtime.state.gemini.engine.page.bmap.GAbstractHashMap;
import org.apache.flink.runtime.state.gemini.engine.page.bmap.GBinarySplitHashMap;
import org.apache.flink.runtime.state.gemini.engine.page.bmap.GBufferAddressMapping;
import org.apache.flink.runtime.state.gemini.engine.page.bmap.GByteArrayOutputStreamWithPos;
import org.apache.flink.runtime.state.gemini.engine.page.bmap.GHashHeader;
import org.apache.flink.runtime.state.gemini.engine.page.bmap.GHashHeaderImpl;
import org.apache.flink.runtime.state.gemini.engine.page.bmap.SplitHashMapValueHelper;
import org.apache.flink.runtime.state.gemini.engine.page.compress.CompressorCodec;
import org.apache.flink.runtime.state.gemini.engine.page.compress.GCompressAlgorithm;
import org.apache.flink.runtime.state.gemini.engine.rm.Allocator;
import org.apache.flink.runtime.state.gemini.engine.rm.GByteBuffer;
import org.apache.flink.runtime.state.gemini.engine.rm.ReferenceCountable;
import org.apache.flink.util.MathUtils;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GBinaryHashMap<K>
extends GAbstractHashMap<K>
implements ReferenceCountable {
    private static final Logger LOG = LoggerFactory.getLogger(GBinaryHashMap.class);
    public static final GBinaryHashMap EMPTY_G_BINARY_HASHMAP = new GBinaryHashMap(null, null, null, 0);
    protected final GByteBuffer data;
    private final TypeSerializer<K> keyTypeSerializer;
    private final GHashHeader gHashHeader;
    private final int originCheckSum;

    public GBinaryHashMap(GByteBuffer data, TypeSerializer<K> keyTypeSerializer) {
        this(data, keyTypeSerializer, data == null ? 0 : GBinaryHashMap.genOriginCheckSum(data.getByteBuffer()));
    }

    public GBinaryHashMap(GByteBuffer data, TypeSerializer<K> keyTypeSerializer, int originCheckSum) {
        this.data = GBinaryHashMap.checkCapacity(data);
        this.keyTypeSerializer = keyTypeSerializer;
        int indexLen = this.indexCount();
        this.gHashHeader = GHashHeaderImpl.getPageHelper(indexLen);
        this.originCheckSum = originCheckSum;
    }

    public GBinaryHashMap(GHashHeader pageHelper, GByteBuffer data, TypeSerializer<K> keyTypeSerializer) {
        this(pageHelper, data, keyTypeSerializer, GBinaryHashMap.genOriginCheckSum(data.getByteBuffer()));
    }

    public GBinaryHashMap(GHashHeader pageHelper, GByteBuffer data, TypeSerializer<K> keyTypeSerializer, int originCheckSum) {
        this.data = GBinaryHashMap.checkCapacity(data);
        this.keyTypeSerializer = keyTypeSerializer;
        this.gHashHeader = pageHelper;
        this.originCheckSum = originCheckSum;
    }

    public static GByteBuffer checkCapacity(GByteBuffer data) {
        return data != null && data.capacity() == 0 ? null : data;
    }

    public GHashHeader getPageHelper() {
        return this.gHashHeader;
    }

    @Override
    public boolean isEmpty() {
        return this.keyCount() == 0;
    }

    @Override
    public boolean containsKey(Object key) {
        return this.get(key) != null;
    }

    @Override
    public BinaryValue get(Object key) {
        if (key == null || this.data == null) {
            return null;
        }
        int hashCode2 = key.hashCode();
        int indexLen = this.indexCount();
        int keyCount = this.keyCount();
        int indexSlot = hashCode2 & indexLen - 1;
        long indexValue = this.getIndexSlot(indexSlot);
        int baseKeyOffset = GHashHeaderImpl.getHeaderKeyOffset(this.data.getByteBuffer());
        int baseValueOffset = GHashHeaderImpl.getHeaderValueOffset(this.data.getByteBuffer());
        AtomicReference<ByteBuffer> uncompressKeyData = new AtomicReference<ByteBuffer>();
        AtomicReference<ByteBuffer> uncompressValueData = new AtomicReference<ByteBuffer>();
        if (indexValue != this.gHashHeader.getInitialIndexValue()) {
            int count = this.gHashHeader.getCountByIndexValue(indexValue);
            int startSlot = this.gHashHeader.getSlotByIndexValue(indexValue);
            for (int j = 0; j < count; ++j) {
                K k;
                if (this.getHashCode(indexLen, startSlot + j) != hashCode2 || (k = this.getKeyBySlot(keyCount, baseKeyOffset, baseValueOffset, startSlot + j, uncompressKeyData)) != key && !key.equals(k)) continue;
                return this.getBinaryValue(keyCount, indexLen, baseValueOffset, startSlot + j, uncompressValueData);
            }
        }
        return null;
    }

    @Override
    public long getCompactionCount() {
        return this.data == null ? 0L : GHashHeaderImpl.getHeaderStatCompactionCount(this.data.getByteBuffer());
    }

    @Override
    public int bytesSize() {
        return this.data == null ? 0 : this.data.capacity();
    }

    public byte getDataType() {
        Preconditions.checkArgument((this.data != null ? 1 : 0) != 0, (Object)"BUG");
        return GHashHeaderImpl.getHeadPageType(this.data.getByteBuffer());
    }

    @Override
    public int keyCount() {
        return this.data == null ? 0 : GHashHeaderImpl.getHeaderTotalKeyCount(this.data.getByteBuffer());
    }

    @Override
    public int size() {
        return this.data == null ? 0 : GHashHeaderImpl.getHeaderTotalKeyCount(this.data.getByteBuffer());
    }

    @Override
    public int indexCount() {
        return this.data == null ? 0 : GHashHeaderImpl.getHeaderIndexCount(this.data.getByteBuffer());
    }

    public int getLogicPageId() {
        return this.data == null ? -1 : GHashHeaderImpl.getHeadPageID(this.data.getByteBuffer());
    }

    public long getVersion() {
        return this.data == null ? -1L : GHashHeaderImpl.getHeaderVersion(this.data.getByteBuffer());
    }

    public long getIndexSlot(int indexSlot) {
        return this.data == null ? -1L : this.gHashHeader.getIndexBySlot(this.data.getByteBuffer(), indexSlot);
    }

    @Override
    public int getHashCode(int indexLen, int keyCursor) {
        return this.data == null ? -1 : this.gHashHeader.getHashCode(this.data.getByteBuffer(), indexLen, keyCursor);
    }

    @VisibleForTesting
    public K getKeyBySlot(int keyCount, int baseKeyOffset, int baseValueOffset, int keySlot, AtomicReference<ByteBuffer> uncompressKeyData) {
        Preconditions.checkArgument((this.data != null ? 1 : 0) != 0, (Object)"BUG");
        int endKeyOffset = -1;
        int startKeyOffset = -1;
        try {
            int uncompressKeySize = this.getUncompressKeyPartSize();
            ByteBuffer finalBB = this.data.getByteBuffer();
            if (uncompressKeySize != -1) {
                ByteBuffer uncompressKeyBB;
                ByteBuffer byteBuffer = uncompressKeyBB = uncompressKeyData == null ? null : uncompressKeyData.get();
                if (uncompressKeyBB == null) {
                    uncompressKeyBB = GBinaryHashMap.tryUnCompress(this.getCompressAlgorithm(), uncompressKeySize, this.data.getByteBuffer(), baseKeyOffset, baseValueOffset);
                    if (uncompressKeyData != null) {
                        uncompressKeyData.set(uncompressKeyBB);
                    }
                }
                finalBB = uncompressKeyBB;
                baseKeyOffset = 0;
            }
            endKeyOffset = GHashHeaderImpl.getEndOffsetBySlot(finalBB, baseKeyOffset, keySlot);
            startKeyOffset = keySlot == 0 ? keyCount * 4 : GHashHeaderImpl.getEndOffsetBySlot(finalBB, baseKeyOffset, keySlot - 1);
            ByteBufferDataInputView byteBufferDataInputView = new ByteBufferDataInputView(finalBB, baseKeyOffset + startKeyOffset, endKeyOffset - startKeyOffset);
            return (K)this.keyTypeSerializer.deserialize((DataInputView)byteBufferDataInputView);
        }
        catch (Exception e) {
            String debuginfo = "baseKeyOffset=" + baseKeyOffset + " ,startOffset= " + startKeyOffset + " ;endOffset=" + endKeyOffset;
            debuginfo = debuginfo + " ,debugInfo=" + this.debugInfo();
            throw new GeminiRuntimeException("getKeyBySlot has Exception. " + debuginfo, e);
        }
    }

    private String debugInfo() {
        StringBuilder sb = new StringBuilder();
        int indexLen = this.indexCount();
        int keyCount = this.keyCount();
        int baseKeyOffset = GHashHeaderImpl.getHeaderKeyOffset(this.data.getByteBuffer());
        int baseValueOffset = GHashHeaderImpl.getHeaderValueOffset(this.data.getByteBuffer());
        sb.append(" dataClass=" + this.data.getClass().getSimpleName());
        sb.append(" ,byteBuffer=" + this.data.getByteBuffer().getClass().getSimpleName());
        sb.append(" ,position=" + this.data.getByteBuffer().position());
        sb.append(" ,limit=" + this.data.getByteBuffer().limit());
        sb.append(" ,capacity=" + this.data.getByteBuffer().capacity());
        sb.append(" ;indexCount=" + indexLen);
        sb.append(" ;keyCount=" + keyCount);
        sb.append(" ;baseKeyOffset=" + baseKeyOffset);
        sb.append(" ;baseValueOffset=" + baseValueOffset);
        sb.append(" ;dataLen=" + this.data.capacity());
        sb.append(" ;originChecksum=" + this.originCheckSum);
        sb.append(" ;currentChecksum=" + GBinaryHashMap.genOriginCheckSum(this.data.getByteBuffer()));
        return sb.toString();
    }

    public static <K, V> GBinaryHashMap<K> of(DataPage.DataPageType dataPageType, List<Tuple2<K, GSValue<V>>> keyValueList, TypeSerializer<K> keySerializer, TypeSerializer<V> valueSerializer, long version, int logicPageId, Allocator allocator, long compactionCount, GCompressAlgorithm gCompressAlgorithm) {
        int totalKeys = keyValueList.size();
        if (totalKeys == 0) {
            return EMPTY_G_BINARY_HASHMAP;
        }
        int indexLen = MathUtils.roundUpToPowerOfTwo((int)totalKeys);
        GHashHeaderImpl pageHelper = GHashHeaderImpl.getPageHelper(indexLen);
        GByteBuffer gByteBuffer = GBinaryHashMap.genByteBuffer(dataPageType, keyValueList, indexLen, totalKeys, pageHelper, keySerializer, valueSerializer, version, logicPageId, allocator, compactionCount, gCompressAlgorithm);
        return new GBinaryHashMap<K>(pageHelper, gByteBuffer, keySerializer, GBinaryHashMap.genOriginCheckSum(gByteBuffer.getByteBuffer()));
    }

    protected static int genOriginCheckSum(ByteBuffer bb) {
        if (bb == null) {
            return 0;
        }
        int position = bb.position();
        CRC32 crc321 = new CRC32();
        crc321.update(bb);
        long crc = crc321.getValue();
        bb.position(position);
        return (int)crc;
    }

    public static <K> GBinaryHashMap<K> ofBinaryList(int logicPageChainIndex, int pageAddressIndex, DataPage.DataPageType dataPageType, List<Tuple2<BinaryKey, BinaryValue>> binaryValueList, TypeSerializer<K> keySerializer, long version, int logicPageId, Allocator allocator, long compactionCount, GCompressAlgorithm gCompressAlgorithm, GRegionContext gRegionContext) {
        int totalKeys = binaryValueList.size();
        if (totalKeys == 0) {
            return EMPTY_G_BINARY_HASHMAP;
        }
        GBufferAddressMapping mapping = new GBufferAddressMapping(gRegionContext, logicPageChainIndex, pageAddressIndex);
        for (Tuple2<BinaryKey, BinaryValue> entry : binaryValueList) {
            BinaryValue value = (BinaryValue)entry.f1;
            if (!(value instanceof BinaryValueForSplit)) continue;
            GByteBuffer newBuffer = SplitHashMapValueHelper.replaceBinaryValueIdList((BinaryValueForSplit)value, mapping);
            entry.f1 = new BinaryValueImpl(newBuffer.getByteBuffer(), value.getGValueType(), value.getSeqID(), 0, newBuffer.capacity());
        }
        int indexLen = MathUtils.roundUpToPowerOfTwo((int)totalKeys);
        GHashHeaderImpl pageHelper = GHashHeaderImpl.getPageHelper(indexLen);
        GByteBuffer gByteBuffer = GBinaryHashMap.genByteBufferByBinary(dataPageType, binaryValueList, indexLen, totalKeys, pageHelper, version, logicPageId, allocator, compactionCount, gCompressAlgorithm);
        GBinaryHashMap<K> gBinaryHashMap = new GBinaryHashMap<K>(pageHelper, gByteBuffer, keySerializer, GBinaryHashMap.genOriginCheckSum(gByteBuffer.getByteBuffer()));
        if (!mapping.isEmpty()) {
            gBinaryHashMap = new GBinarySplitHashMap<K>(gBinaryHashMap, mapping);
        }
        return gBinaryHashMap;
    }

    public static <K> GBinaryHashMap<K> ofBinaryMap(DataPage.DataPageType dataPageType, boolean isMajor, long version, int logicPageId, TypeSerializer<K> keyTypeSerializer, Allocator allocator, Map<BinaryKey, BinaryValue> newMap, long compactionCount, @Nullable StateFilter stateFilter, @Nullable GRegionContext gRegionContext) {
        ArrayList<Tuple2<BinaryKey, BinaryValue>> dataSet = new ArrayList<Tuple2<BinaryKey, BinaryValue>>();
        for (Map.Entry<BinaryKey, BinaryValue> entry : newMap.entrySet()) {
            BinaryValue binaryValue = entry.getValue();
            if (isMajor && (binaryValue.getGValueType() == GValueType.Delete || stateFilter != null && stateFilter.filter(gRegionContext, binaryValue.getSeqID()))) continue;
            dataSet.add(Tuple2.of((Object)entry.getKey(), (Object)binaryValue));
        }
        int totalKeys = dataSet.size();
        if (totalKeys == 0) {
            return EMPTY_G_BINARY_HASHMAP;
        }
        int indexLen = MathUtils.roundUpToPowerOfTwo((int)totalKeys);
        GHashHeaderImpl pageHelper = GHashHeaderImpl.getPageHelper(indexLen);
        GByteBuffer gByteBuffer = GBinaryHashMap.genByteBufferByBinary(dataPageType, dataSet, indexLen, totalKeys, pageHelper, version, logicPageId, allocator, compactionCount, gRegionContext == null ? GCompressAlgorithm.None : gRegionContext.getGContext().getInPageGCompressAlgorithm());
        return new GBinaryHashMap<K>(pageHelper, gByteBuffer, keyTypeSerializer, GBinaryHashMap.genOriginCheckSum(gByteBuffer.getByteBuffer()));
    }

    public byte[] getDataByte(boolean checkSum) {
        byte[] bytes;
        Preconditions.checkArgument((this.data != null ? 1 : 0) != 0, (Object)"BUG");
        if (this.data.getByteBuffer().hasArray()) {
            bytes = this.data.getByteBuffer().array();
        } else {
            bytes = new byte[this.data.capacity()];
            ByteBufferUtils.copyFromBufferToArray(this.data.getByteBuffer(), bytes, 0, 0, this.data.capacity());
        }
        if (checkSum) {
            CRC32 crc32 = new CRC32();
            crc32.update(bytes);
            int crc = (int)crc32.getValue();
            if (crc != this.originCheckSum) {
                throw new GeminiRuntimeException("checkSum changed! originCheckSum=" + this.originCheckSum + " ,now=" + crc);
            }
        }
        return bytes;
    }

    public ByteBuffer getData() {
        return this.data == null || this.data.isFreed() ? null : this.data.getByteBuffer();
    }

    public GByteBuffer getGByteBuffer() {
        if (this.data == null || this.data.isFreed()) {
            return null;
        }
        return this.data;
    }

    @Override
    public Map<BinaryKey, BinaryValue> getBinaryMap() {
        int keyCount = this.keyCount();
        HashMap<BinaryKey, BinaryValue> dataMap = new HashMap<BinaryKey, BinaryValue>(keyCount);
        if (keyCount == 0) {
            return dataMap;
        }
        int indexLen = this.indexCount();
        int baseKeyOffset = GHashHeaderImpl.getHeaderKeyOffset(this.data.getByteBuffer());
        int baseValueOffset = GHashHeaderImpl.getHeaderValueOffset(this.data.getByteBuffer());
        AtomicReference<ByteBuffer> uncompressKeyData = new AtomicReference<ByteBuffer>();
        AtomicReference<ByteBuffer> uncompressValueData = new AtomicReference<ByteBuffer>();
        for (int i = 0; i < keyCount; ++i) {
            BinaryKey binaryKey = this.getBinaryKey(keyCount, indexLen, baseKeyOffset, baseValueOffset, i, uncompressKeyData);
            BinaryValue binaryValue = this.getBinaryValue(keyCount, indexLen, baseValueOffset, i, uncompressValueData);
            dataMap.put(binaryKey, binaryValue);
        }
        return dataMap;
    }

    protected BinaryKey getBinaryKey(int keyCount, int indexLen, int baseKeyOffset, int baseValueOffset, int i, AtomicReference<ByteBuffer> uncompressKeyData) {
        try {
            int uncompressKeySize = this.getUncompressKeyPartSize();
            ByteBuffer finalBB = this.data.getByteBuffer();
            if (uncompressKeySize != -1) {
                ByteBuffer uncompressKeyBB;
                ByteBuffer byteBuffer = uncompressKeyBB = uncompressKeyData == null ? null : uncompressKeyData.get();
                if (uncompressKeyBB == null) {
                    uncompressKeyBB = GBinaryHashMap.tryUnCompress(this.getCompressAlgorithm(), uncompressKeySize, this.data.getByteBuffer(), baseKeyOffset, baseValueOffset);
                    if (uncompressKeyData != null) {
                        uncompressKeyData.set(uncompressKeyBB);
                    }
                }
                finalBB = uncompressKeyBB;
                baseKeyOffset = 0;
            }
            int endKeyOffset = GHashHeaderImpl.getEndOffsetBySlot(finalBB, baseKeyOffset, i);
            int startKeyOffset = i == 0 ? keyCount * 4 : GHashHeaderImpl.getEndOffsetBySlot(finalBB, baseKeyOffset, i - 1);
            int hashCode2 = this.getHashCode(indexLen, i);
            return new BinaryKey(finalBB, baseKeyOffset + startKeyOffset, endKeyOffset - startKeyOffset, hashCode2);
        }
        catch (Exception e) {
            String debuginfo = "keyCount=" + keyCount + " ,indexLen=" + indexLen + " ,slot=" + i + " ,startOffset= " + baseKeyOffset + " ;endOffset=" + baseValueOffset;
            debuginfo = debuginfo + " ,debugInfo=" + this.debugInfo();
            LOG.error(debuginfo, (Throwable)e);
            throw new GeminiRuntimeException("getKeyBySlot has Exception. " + debuginfo, e);
        }
    }

    BinaryValue getBinaryValue(int keyCount, int indexLen, int baseValueOffset, int slotNum, AtomicReference<ByteBuffer> uncompressValueData) {
        try {
            BinaryValueImpl binaryValue;
            int valueIndicate;
            GValueType gValueType;
            long seqID = this.gHashHeader.getSeqIDBytSlot(this.data.getByteBuffer(), indexLen, keyCount, slotNum);
            int uncompressValuePartSize = this.getUncompressValuePartSize();
            ByteBuffer finalBB = this.data.getByteBuffer();
            if (uncompressValuePartSize != -1) {
                ByteBuffer uncompressValueBB;
                ByteBuffer byteBuffer = uncompressValueBB = uncompressValueData == null ? null : uncompressValueData.get();
                if (uncompressValueBB == null) {
                    uncompressValueBB = GBinaryHashMap.tryUnCompress(this.getCompressAlgorithm(), uncompressValuePartSize, this.data.getByteBuffer(), baseValueOffset, this.data.capacity());
                    if (uncompressValueData != null) {
                        uncompressValueData.set(uncompressValueBB);
                    }
                }
                finalBB = uncompressValueBB;
                baseValueOffset = 0;
            }
            if ((gValueType = GValueType.valueOf((byte)((valueIndicate = GHashHeaderImpl.getEndOffsetBySlot(finalBB, baseValueOffset, slotNum)) >>> 28))) == GValueType.Delete) {
                binaryValue = new BinaryValueImpl(null, GValueType.Delete, seqID, -1, -1);
            } else {
                int endValueOffset = valueIndicate & 0xFFFFFFF;
                int startValueOffset = slotNum == 0 ? keyCount * 4 : GHashHeaderImpl.getEndOffsetBySlot(finalBB, baseValueOffset, slotNum - 1) & 0xFFFFFFF;
                binaryValue = new BinaryValueImpl(finalBB, gValueType, seqID, baseValueOffset + startValueOffset, endValueOffset - startValueOffset);
            }
            return binaryValue;
        }
        catch (Exception e) {
            String debuginfo = "keyCount=" + keyCount + " ,indexLen=" + indexLen + " ,slotNum=" + slotNum + " ,baseValueOffset=" + baseValueOffset;
            debuginfo = debuginfo + " ,debugInfo=" + this.debugInfo();
            LOG.error(debuginfo, (Throwable)e);
            throw new GeminiRuntimeException("getKeyBySlot has Exception. " + debuginfo, e);
        }
    }

    @Override
    public TypeSerializer<K> getKeyTypeSerializer() {
        return this.keyTypeSerializer;
    }

    @VisibleForTesting
    public <V> Map<K, GSValue<V>> toPOJOMap(TypeSerializer<V> valueTypeSerializer) {
        HashMap result = new HashMap();
        return this.toPOJOMap(result, valueTypeSerializer);
    }

    @VisibleForTesting
    public <V> Map<K, GSValue<V>> toPOJOMap(Map<K, GSValue<V>> result, TypeSerializer<V> valueTypeSerializer) {
        try {
            int keyCount = this.keyCount();
            if (keyCount == 0) {
                return result;
            }
            int indexLen = this.indexCount();
            int baseKeyOffset = GHashHeaderImpl.getHeaderKeyOffset(this.data.getByteBuffer());
            int baseValueOffset = GHashHeaderImpl.getHeaderValueOffset(this.data.getByteBuffer());
            AtomicReference<ByteBuffer> uncompressData = new AtomicReference<ByteBuffer>();
            AtomicReference<ByteBuffer> uncompressValueData = new AtomicReference<ByteBuffer>();
            for (int i = 0; i < keyCount; ++i) {
                K k = this.getKeyBySlot(keyCount, baseKeyOffset, baseValueOffset, i, uncompressData);
                BinaryValue binaryValue = this.getBinaryValue(keyCount, indexLen, baseValueOffset, i, uncompressValueData);
                if (binaryValue.getGValueType() == GValueType.Delete) {
                    result.put(k, new GSValue<Object>(null, binaryValue.getGValueType(), binaryValue.getSeqID()));
                    continue;
                }
                ByteBufferDataInputView byteBufferDataInputView = new ByteBufferDataInputView(binaryValue.getBb(), binaryValue.getValueOffset(), binaryValue.getValueLen());
                Object value = valueTypeSerializer.deserialize((DataInputView)byteBufferDataInputView);
                result.put(k, new GSValue<Object>(value, binaryValue.getGValueType(), binaryValue.getSeqID()));
            }
            return result;
        }
        catch (Exception e) {
            throw new GeminiRuntimeException(e);
        }
    }

    public Set<K> toPOJOSet() {
        HashSet result = new HashSet();
        return this.toPOJOSet(result);
    }

    public Set<K> toPOJOSet(Set<K> result) {
        try {
            int keyCount = this.keyCount();
            if (keyCount == 0) {
                return result;
            }
            int baseKeyOffset = GHashHeaderImpl.getHeaderKeyOffset(this.data.getByteBuffer());
            int baseValueOffset = GHashHeaderImpl.getHeaderValueOffset(this.data.getByteBuffer());
            AtomicReference<ByteBuffer> uncompressData = new AtomicReference<ByteBuffer>();
            for (int i = 0; i < keyCount; ++i) {
                K k = this.getKeyBySlot(keyCount, baseKeyOffset, baseValueOffset, i, uncompressData);
                result.add(k);
            }
            return result;
        }
        catch (Exception e) {
            throw new GeminiRuntimeException(e);
        }
    }

    protected static <K, V> GByteBuffer genByteBuffer(DataPage.DataPageType dataPageType, List<Tuple2<K, GSValue<V>>> keyValueList, int indexLen, int totalKeys, GHashHeader gHeader, TypeSerializer<K> keySerializer, TypeSerializer<V> valueSerializer, long version, int logicPageId, Allocator allocator, long compactionCount, GCompressAlgorithm gCompressAlgorithm) {
        ReferenceCountable gByteBuffer = null;
        try {
            Collections.sort(keyValueList, Comparator.comparingInt(entry -> entry.f0.hashCode() & indexLen - 1));
            byte[] headerAndIndex = new byte[gHeader.getHeaderAndIndexLen(indexLen, totalKeys)];
            ByteBuffer headerAndIndexBB = ByteBuffer.wrap(headerAndIndex);
            gHeader.initIndex(headerAndIndexBB, indexLen);
            GByteArrayOutputStreamWithPos outputStreamForKey = new GByteArrayOutputStreamWithPos(1024);
            DataOutputViewStreamWrapper outputViewForKey = new DataOutputViewStreamWrapper((OutputStream)outputStreamForKey);
            int lastKeyPosition = totalKeys * 4;
            GByteArrayOutputStreamWithPos outputStreamForValue = new GByteArrayOutputStreamWithPos(1024);
            DataOutputViewStreamWrapper outputViewForValue = new DataOutputViewStreamWrapper((OutputStream)outputStreamForValue);
            int lastValuePosition = totalKeys * 4;
            Iterator<Tuple2<K, GSValue<V>>> iterator = keyValueList.iterator();
            int keyCursor = 0;
            while (iterator.hasNext()) {
                Tuple2<K, GSValue<V>> entry2 = iterator.next();
                int hashCode2 = entry2.f0.hashCode();
                int indexSlot = hashCode2 & indexLen - 1;
                long oldIndexValue = gHeader.getIndexBySlot(headerAndIndexBB, indexSlot);
                long newIndexValue = gHeader.getNewIndexValue(oldIndexValue, keyCursor);
                gHeader.writeIndexBySlot(headerAndIndexBB, indexSlot, newIndexValue);
                gHeader.writeHashCode(headerAndIndexBB, indexLen, keyCursor, hashCode2);
                outputStreamForKey.setPosition(lastKeyPosition);
                keySerializer.serialize(entry2.f0, (DataOutputView)outputViewForKey);
                lastKeyPosition = outputStreamForKey.getPosition();
                outputStreamForKey.setPosition(keyCursor * 4);
                IntSerializer.INSTANCE.serialize(Integer.valueOf(lastKeyPosition), (DataOutputView)outputViewForKey);
                GSValue gsValue = (GSValue)entry2.f1;
                if (gsValue.getValueType() != GValueType.Delete) {
                    outputStreamForValue.setPosition(lastValuePosition);
                    valueSerializer.serialize(gsValue.getValue(), (DataOutputView)outputViewForValue);
                    lastValuePosition = outputStreamForValue.getPosition();
                }
                outputStreamForValue.setPosition(keyCursor * 4);
                int valueIndicator = gsValue.getValueType().getCode() << 28 | lastValuePosition & 0xFFFFFFF;
                IntSerializer.INSTANCE.serialize(Integer.valueOf(valueIndicator), (DataOutputView)outputViewForValue);
                gHeader.writeSeqIDBytSlot(headerAndIndexBB, indexLen, totalKeys, gsValue.getSeqID(), keyCursor);
                ++keyCursor;
            }
            outputStreamForKey.setPosition(lastKeyPosition);
            outputStreamForValue.setPosition(lastValuePosition);
            ByteBuffer keyBytes = ByteBuffer.wrap(outputStreamForKey.getBuf(), 0, lastKeyPosition);
            ByteBuffer valueBytes = ByteBuffer.wrap(outputStreamForValue.getBuf(), 0, lastValuePosition);
            ByteBuffer keyCompressed = GBinaryHashMap.tryCompress(gCompressAlgorithm, keyBytes);
            ByteBuffer valueCompressed = GBinaryHashMap.tryCompress(gCompressAlgorithm, valueBytes);
            if (keyCompressed != null) {
                GHashHeaderImpl.writeHeaderKeyUncompressSize(headerAndIndexBB, lastKeyPosition);
                keyBytes = keyCompressed;
                lastKeyPosition = keyBytes.limit();
            } else {
                GHashHeaderImpl.writeHeaderKeyUncompressSize(headerAndIndexBB, -1);
            }
            if (valueCompressed != null) {
                GHashHeaderImpl.writeHeaderValueUncompressSize(headerAndIndexBB, lastValuePosition);
                valueBytes = valueCompressed;
                lastValuePosition = valueBytes.limit();
            } else {
                GHashHeaderImpl.writeHeaderValueUncompressSize(headerAndIndexBB, -1);
            }
            GHashHeaderImpl.writeHeadPageType(headerAndIndexBB, dataPageType.getCode());
            GHashHeaderImpl.writeHeadPageID(headerAndIndexBB, logicPageId);
            GHashHeaderImpl.writeHeaderTotalKeyCount(headerAndIndexBB, totalKeys);
            GHashHeaderImpl.writeHeaderIndexCount(headerAndIndexBB, indexLen);
            GHashHeaderImpl.writeHeaderKeyOffset(headerAndIndexBB, headerAndIndex.length);
            GHashHeaderImpl.writeHeaderValueOffset(headerAndIndexBB, headerAndIndex.length + lastKeyPosition);
            GHashHeaderImpl.writeHeaderVersion(headerAndIndexBB, version);
            GHashHeaderImpl.writeHeaderCompressCode(headerAndIndexBB, gCompressAlgorithm.getCode());
            GHashHeaderImpl.writeHeaderStatCompactionCount(headerAndIndexBB, compactionCount);
            int newBufferLen = headerAndIndex.length + lastKeyPosition + lastValuePosition;
            gByteBuffer = allocator.allocate(newBufferLen);
            ByteBufferUtils.copyFromArrayToBuffer(gByteBuffer.getByteBuffer(), 0, headerAndIndex, 0, headerAndIndex.length);
            ByteBufferUtils.copyFromBufferToBuffer(keyBytes, gByteBuffer.getByteBuffer(), 0, headerAndIndex.length, lastKeyPosition);
            ByteBufferUtils.copyFromBufferToBuffer(valueBytes, gByteBuffer.getByteBuffer(), 0, headerAndIndex.length + lastKeyPosition, lastValuePosition);
            return gByteBuffer;
        }
        catch (Exception e) {
            if (gByteBuffer != null) {
                gByteBuffer.release();
            }
            throw new GeminiRuntimeException("GBinaryHashMap get exception: " + e.getMessage(), e);
        }
    }

    protected static GByteBuffer genByteBufferByBinary(DataPage.DataPageType dataPageType, List<Tuple2<BinaryKey, BinaryValue>> keyValueList, int indexLen, int totalKeys, GHashHeader gHeader, long version, int logicPageId, Allocator allocator, long compactionCount, GCompressAlgorithm gCompressAlgorithm) {
        ReferenceCountable byteBuffer = null;
        try {
            Collections.sort(keyValueList, Comparator.comparingInt(entry -> ((BinaryKey)entry.f0).getKeyHashCode() & indexLen - 1));
            byte[] headerAndIndex = new byte[gHeader.getHeaderAndIndexLen(indexLen, totalKeys)];
            ByteBuffer headerAndIndexBB = ByteBuffer.wrap(headerAndIndex);
            gHeader.initIndex(headerAndIndexBB, indexLen);
            GByteArrayOutputStreamWithPos keyByteStream = new GByteArrayOutputStreamWithPos(1024);
            int lastKeyPosition = totalKeys * 4;
            GByteArrayOutputStreamWithPos valueByteStream = new GByteArrayOutputStreamWithPos(1024);
            int lastValuePosition = totalKeys * 4;
            Iterator<Tuple2<BinaryKey, BinaryValue>> iterator = keyValueList.iterator();
            int keyCursor = 0;
            while (iterator.hasNext()) {
                Tuple2<BinaryKey, BinaryValue> entry2 = iterator.next();
                int hashCode2 = ((BinaryKey)entry2.f0).getKeyHashCode();
                int indexSlot = hashCode2 & indexLen - 1;
                long oldIndexValue = gHeader.getIndexBySlot(headerAndIndexBB, indexSlot);
                long newIndexValue = gHeader.getNewIndexValue(oldIndexValue, keyCursor);
                gHeader.writeIndexBySlot(headerAndIndexBB, indexSlot, newIndexValue);
                gHeader.writeHashCode(headerAndIndexBB, indexLen, keyCursor, hashCode2);
                keyByteStream.setPosition(lastKeyPosition);
                keyByteStream.write(((BinaryKey)entry2.f0).getBb(), ((BinaryKey)entry2.f0).getKeyOffset(), ((BinaryKey)entry2.f0).getKeyLen());
                lastKeyPosition = keyByteStream.getPosition();
                keyByteStream.setPosition(keyCursor * 4);
                keyByteStream.writeInt(lastKeyPosition);
                if (((BinaryValue)entry2.f1).getGValueType() != GValueType.Delete) {
                    valueByteStream.setPosition(lastValuePosition);
                    valueByteStream.write(((BinaryValue)entry2.f1).getBb(), ((BinaryValue)entry2.f1).getValueOffset(), ((BinaryValue)entry2.f1).getValueLen());
                    lastValuePosition = valueByteStream.getPosition();
                }
                valueByteStream.setPosition(keyCursor * 4);
                int valueIndicator = ((BinaryValue)entry2.f1).getGValueType().getCode() << 28 | lastValuePosition & 0xFFFFFFF;
                valueByteStream.writeInt(valueIndicator);
                gHeader.writeSeqIDBytSlot(headerAndIndexBB, indexLen, totalKeys, ((BinaryValue)entry2.f1).getSeqID(), keyCursor);
                ++keyCursor;
            }
            keyByteStream.setPosition(lastKeyPosition);
            valueByteStream.setPosition(lastValuePosition);
            ByteBuffer keyBytes = ByteBuffer.wrap(keyByteStream.getBuf(), 0, lastKeyPosition);
            ByteBuffer valueBytes = ByteBuffer.wrap(valueByteStream.getBuf(), 0, lastValuePosition);
            ByteBuffer keyCompressed = GBinaryHashMap.tryCompress(gCompressAlgorithm, keyBytes);
            ByteBuffer valueCompressed = GBinaryHashMap.tryCompress(gCompressAlgorithm, valueBytes);
            if (keyCompressed != null) {
                GHashHeaderImpl.writeHeaderKeyUncompressSize(headerAndIndexBB, lastKeyPosition);
                keyBytes = keyCompressed;
                lastKeyPosition = keyBytes.limit();
            } else {
                GHashHeaderImpl.writeHeaderKeyUncompressSize(headerAndIndexBB, -1);
            }
            if (valueCompressed != null) {
                GHashHeaderImpl.writeHeaderValueUncompressSize(headerAndIndexBB, lastValuePosition);
                valueBytes = valueCompressed;
                lastValuePosition = valueBytes.limit();
            } else {
                GHashHeaderImpl.writeHeaderValueUncompressSize(headerAndIndexBB, -1);
            }
            GHashHeaderImpl.writeHeadPageType(headerAndIndexBB, dataPageType.getCode());
            GHashHeaderImpl.writeHeadPageID(headerAndIndexBB, logicPageId);
            GHashHeaderImpl.writeHeaderTotalKeyCount(headerAndIndexBB, totalKeys);
            GHashHeaderImpl.writeHeaderIndexCount(headerAndIndexBB, indexLen);
            GHashHeaderImpl.writeHeaderKeyOffset(headerAndIndexBB, headerAndIndex.length);
            GHashHeaderImpl.writeHeaderValueOffset(headerAndIndexBB, headerAndIndex.length + lastKeyPosition);
            GHashHeaderImpl.writeHeaderVersion(headerAndIndexBB, version);
            GHashHeaderImpl.writeHeaderCompressCode(headerAndIndexBB, gCompressAlgorithm.getCode());
            GHashHeaderImpl.writeHeaderStatCompactionCount(headerAndIndexBB, compactionCount);
            int newBufferLen = headerAndIndex.length + lastKeyPosition + lastValuePosition;
            byteBuffer = allocator.allocate(newBufferLen);
            ByteBufferUtils.copyFromArrayToBuffer(byteBuffer.getByteBuffer(), 0, headerAndIndex, 0, headerAndIndex.length);
            ByteBufferUtils.copyFromBufferToBuffer(keyBytes, byteBuffer.getByteBuffer(), 0, headerAndIndex.length, lastKeyPosition);
            ByteBufferUtils.copyFromBufferToBuffer(valueBytes, byteBuffer.getByteBuffer(), 0, headerAndIndex.length + lastKeyPosition, lastValuePosition);
            return byteBuffer;
        }
        catch (Exception e) {
            if (byteBuffer != null) {
                byteBuffer.release();
            }
            throw new GeminiRuntimeException("GBinaryHashMap get exception: " + e.getMessage(), e);
        }
    }

    static ByteBuffer tryCompress(GCompressAlgorithm algorithm, ByteBuffer bytes) {
        try {
            CompressorCodec compressorCodec = algorithm.getCompressorCodec();
            if (compressorCodec != null && bytes.limit() > 1024) {
                ByteBuffer result = ByteBuffer.allocate(compressorCodec.getMaxCompressedSize(bytes.limit()));
                int compressedLen = compressorCodec.compress(bytes, result);
                if (result.position() == compressedLen) {
                    return (ByteBuffer)result.flip();
                }
                LOG.error("compress fail.");
            }
        }
        catch (Exception e) {
            LOG.error("compress has exception. bytes info=" + bytes.position() + "/" + bytes.limit() + "/" + bytes.capacity());
        }
        return null;
    }

    private static ByteBuffer tryUnCompress(GCompressAlgorithm algorithm, int uncompressSize, ByteBuffer bytes, int baseKeyOffset, int baseValueOffset) {
        try {
            ByteBuffer compressKeyBB = bytes.duplicate();
            compressKeyBB.limit(baseValueOffset);
            compressKeyBB.position(baseKeyOffset);
            ByteBuffer src = compressKeyBB.slice();
            ByteBuffer result = ByteBuffer.allocate(uncompressSize);
            CompressorCodec compressorCodec = algorithm.getCompressorCodec();
            int unComp = compressorCodec.decompress(src, result);
            if (unComp != uncompressSize) {
                throw new GeminiRuntimeException("uncompress size not match: expected:" + uncompressSize + " ;real=" + unComp);
            }
            return result;
        }
        catch (Exception e) {
            String msg = "uncompress has Exception: " + uncompressSize + " ;endOffset=" + baseValueOffset + " ;startOffset=" + baseKeyOffset + " ;bytes.info=" + bytes.position() + "/" + bytes.limit() + "/" + bytes.capacity();
            LOG.error(msg, (Throwable)e);
            throw new GeminiRuntimeException(msg, e);
        }
    }

    public GCompressAlgorithm getCompressAlgorithm() {
        byte code = GHashHeaderImpl.getHeaderCompressCode(this.data.getByteBuffer());
        return GCompressAlgorithm.valueOf(code);
    }

    public int getUncompressKeyPartSize() {
        return GHashHeaderImpl.getHeaderKeyUncompressSize(this.data.getByteBuffer());
    }

    public int getUncompressValuePartSize() {
        return GHashHeaderImpl.getHeaderValueUncompressSize(this.data.getByteBuffer());
    }

    @Override
    public void retain() {
        if (this.data != null) {
            this.data.retain();
        }
    }

    @Override
    public void release() {
        if (this.data != null) {
            this.data.release();
        }
    }

    @Override
    public int refCnt() {
        if (this.data == null) {
            return 0;
        }
        return this.data.refCnt();
    }

    public int getOriginChecksum() {
        return this.originCheckSum;
    }
}

