/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.gemini.engine.page.bmap;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.runtime.state.gemini.engine.GRegionContext;
import org.apache.flink.runtime.state.gemini.engine.exceptions.GeminiRuntimeException;
import org.apache.flink.runtime.state.gemini.engine.filter.StateFilter;
import org.apache.flink.runtime.state.gemini.engine.memstore.GSValue;
import org.apache.flink.runtime.state.gemini.engine.page.DataPage;
import org.apache.flink.runtime.state.gemini.engine.page.GValueType;
import org.apache.flink.runtime.state.gemini.engine.page.bmap.BinaryKey;
import org.apache.flink.runtime.state.gemini.engine.page.bmap.BinaryValue;
import org.apache.flink.runtime.state.gemini.engine.page.bmap.GAbstractSortedMap;
import org.apache.flink.runtime.state.gemini.engine.page.bmap.GBinaryHashMap;
import org.apache.flink.runtime.state.gemini.engine.page.bmap.GComparator;
import org.apache.flink.runtime.state.gemini.engine.page.bmap.GHashHeaderImpl;
import org.apache.flink.runtime.state.gemini.engine.page.bmap.GSortedHeaderImpl;
import org.apache.flink.runtime.state.gemini.engine.page.compress.GCompressAlgorithm;
import org.apache.flink.runtime.state.gemini.engine.rm.Allocator;
import org.apache.flink.runtime.state.gemini.engine.rm.GByteBuffer;
import org.apache.flink.runtime.state.gemini.engine.rm.GUnPooledByteBuffer;
import org.apache.flink.runtime.state.gemini.engine.rm.ReferenceCountable;
import org.apache.flink.util.MathUtils;

public class GBinarySortedMap<MK>
extends GAbstractSortedMap<MK>
implements ReferenceCountable {
    public static final GBinarySortedMap EMPTY_G_BINARY_SORTEDMAP = new GBinarySortedMap(null, null, null, null);
    private final GBinaryHashMap<MK> gBinaryHashMap;
    private final ByteBuffer data;
    private final GSortedHeaderImpl gSortedHeader;
    private final GComparator<MK> gComparator;
    private final TypeSerializer<MK> keyTypeSerializer;

    public GBinarySortedMap(ByteBuffer data, TypeSerializer<MK> keyTypeSerializer, GComparator<MK> gComparator) {
        GSortedHeaderImpl gSortedHeaderImpl;
        int indexLen = data == null ? 0 : GHashHeaderImpl.getHeaderIndexCount(data);
        this.gSortedHeader = gSortedHeaderImpl = GSortedHeaderImpl.getPageHelper(indexLen);
        this.data = data != null && data.capacity() == 0 ? null : data;
        this.keyTypeSerializer = keyTypeSerializer;
        this.gComparator = gComparator;
        this.gBinaryHashMap = new GBinaryHashMap<MK>(gSortedHeaderImpl, new GUnPooledByteBuffer(data), keyTypeSerializer);
    }

    public GBinarySortedMap(GSortedHeaderImpl gSortedHeader, ByteBuffer data, TypeSerializer<MK> keyTypeSerializer, GComparator<MK> gComparator) {
        this.data = data != null && data.capacity() == 0 ? null : data;
        this.gSortedHeader = gSortedHeader;
        this.keyTypeSerializer = keyTypeSerializer;
        this.gComparator = gComparator;
        this.gBinaryHashMap = new GBinaryHashMap<MK>(gSortedHeader, new GUnPooledByteBuffer(data), keyTypeSerializer);
    }

    @Override
    public BinaryValue get(Object key) {
        return this.gBinaryHashMap.get(key);
    }

    @Override
    public int size() {
        return this.gBinaryHashMap.size();
    }

    @Override
    public int bytesSize() {
        return this.gBinaryHashMap.bytesSize();
    }

    @Override
    public boolean isEmpty() {
        return this.gBinaryHashMap.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.get(key) != null;
    }

    @Override
    public long getCompactionCount() {
        return this.gBinaryHashMap.getCompactionCount();
    }

    @Override
    public int keyCount() {
        return this.gBinaryHashMap.keyCount();
    }

    public byte[] getDataByte(boolean checksumEnable) {
        return this.gBinaryHashMap.getDataByte(checksumEnable);
    }

    public int getLogicPageId() {
        return this.gBinaryHashMap.getLogicPageId();
    }

    @Override
    public Map<BinaryKey, BinaryValue> getBinaryMap() {
        return this.gBinaryHashMap.getBinaryMap();
    }

    @Override
    public SortedMap<BinaryKey, BinaryValue> getSortedBinaryMap() {
        int keyCount = this.keyCount();
        TreeMap<BinaryKey, BinaryValue> dataMap = new TreeMap<BinaryKey, BinaryValue>(this.gComparator.getJDKBinaryCompactor());
        if (keyCount == 0) {
            return dataMap;
        }
        int indexLen = this.gBinaryHashMap.indexCount();
        int sortedIndexBaseOffset = this.gSortedHeader.getSortedIndexBaseOffset(indexLen, keyCount);
        int baseKeyOffset = GHashHeaderImpl.getHeaderKeyOffset(this.data);
        int baseValueOffset = GHashHeaderImpl.getHeaderValueOffset(this.data);
        AtomicReference<ByteBuffer> uncompressKeyData = new AtomicReference<ByteBuffer>();
        AtomicReference<ByteBuffer> uncompressValueData = new AtomicReference<ByteBuffer>();
        for (int k = 0; k < keyCount; ++k) {
            int slotNum = this.gSortedHeader.getSortedIndexBySlot(this.data, sortedIndexBaseOffset, k);
            BinaryKey binaryKey = this.gBinaryHashMap.getBinaryKey(keyCount, indexLen, baseKeyOffset, baseValueOffset, slotNum, uncompressKeyData);
            BinaryValue binaryValue = this.gBinaryHashMap.getBinaryValue(keyCount, indexLen, baseValueOffset, slotNum, uncompressValueData);
            dataMap.put(binaryKey, binaryValue);
        }
        return dataMap;
    }

    @Override
    public TypeSerializer<MK> getKeyTypeSerializer() {
        return this.keyTypeSerializer;
    }

    @Override
    public Comparator<? super MK> comparator() {
        return this.gComparator.getJDKCompactor();
    }

    @Override
    public SortedMap<MK, BinaryValue> subMap(MK fromKey, MK toKey) {
        int keyCount = this.keyCount();
        TreeMap<MK, BinaryValue> dataMap = new TreeMap<MK, BinaryValue>(this.gComparator.getJDKCompactor());
        if (keyCount == 0) {
            return dataMap;
        }
        if (fromKey != null && toKey != null && this.gComparator.compare(fromKey, toKey) > 0) {
            throw new IllegalArgumentException("fromKey > toKey");
        }
        int startIndexSlot = this.findSortedIndexSlotHigher(fromKey, keyCount, true);
        int endIndexSlot = this.findSortedIndexSlotLower(toKey, keyCount, false);
        if (endIndexSlot < startIndexSlot || startIndexSlot >= keyCount) {
            return dataMap;
        }
        if (endIndexSlot >= keyCount) {
            throw new GeminiRuntimeException("Internal Bug");
        }
        int indexLen = this.gBinaryHashMap.indexCount();
        int sortedIndexBaseOffset = this.gSortedHeader.getSortedIndexBaseOffset(indexLen, keyCount);
        int baseKeyOffset = GHashHeaderImpl.getHeaderKeyOffset(this.data);
        int baseValueOffset = GHashHeaderImpl.getHeaderValueOffset(this.data);
        AtomicReference<ByteBuffer> uncompressData = new AtomicReference<ByteBuffer>();
        AtomicReference<ByteBuffer> uncompressValueData = new AtomicReference<ByteBuffer>();
        for (int k = startIndexSlot; k <= endIndexSlot; ++k) {
            int slotNum = this.gSortedHeader.getSortedIndexBySlot(this.data, sortedIndexBaseOffset, k);
            MK key = this.gBinaryHashMap.getKeyBySlot(keyCount, baseKeyOffset, baseValueOffset, slotNum, uncompressData);
            BinaryValue binaryValue = this.gBinaryHashMap.getBinaryValue(keyCount, indexLen, baseValueOffset, slotNum, uncompressValueData);
            dataMap.put(key, binaryValue);
        }
        return dataMap;
    }

    private int findSortedIndexSlotLower(MK toKey, int keyCount, boolean inclusive) {
        int low = 0;
        int high = keyCount - 1;
        if (toKey == null) {
            return high;
        }
        int indexLen = this.gBinaryHashMap.indexCount();
        int sortedIndexBaseOffset = this.gSortedHeader.getSortedIndexBaseOffset(indexLen, keyCount);
        int baseKeyOffset = GHashHeaderImpl.getHeaderKeyOffset(this.data);
        int baseValueOffset = GHashHeaderImpl.getHeaderValueOffset(this.data);
        AtomicReference<ByteBuffer> uncompressData = new AtomicReference<ByteBuffer>();
        while (low <= high) {
            int mid = low + high >>> 1;
            int keySlotNum = this.gSortedHeader.getSortedIndexBySlot(this.data, sortedIndexBaseOffset, mid);
            MK midVal = this.gBinaryHashMap.getKeyBySlot(keyCount, baseKeyOffset, baseValueOffset, keySlotNum, uncompressData);
            if (this.gComparator.compare(midVal, toKey) < 0) {
                low = mid + 1;
                continue;
            }
            if (this.gComparator.compare(midVal, toKey) > 0) {
                high = mid - 1;
                continue;
            }
            return inclusive ? mid : mid - 1;
        }
        return low - 1;
    }

    private int findSortedIndexSlotHigher(MK fromKey, int keyCount, boolean inclusive) {
        if (fromKey == null) {
            return 0;
        }
        int low = 0;
        int high = keyCount - 1;
        int indexLen = this.gBinaryHashMap.indexCount();
        int sortedIndexBaseOffset = this.gSortedHeader.getSortedIndexBaseOffset(indexLen, keyCount);
        int baseKeyOffset = GHashHeaderImpl.getHeaderKeyOffset(this.data);
        int baseValueOffset = GHashHeaderImpl.getHeaderValueOffset(this.data);
        AtomicReference<ByteBuffer> uncompressData = new AtomicReference<ByteBuffer>();
        while (low <= high) {
            int mid = low + high >>> 1;
            int keySlotNum = this.gSortedHeader.getSortedIndexBySlot(this.data, sortedIndexBaseOffset, mid);
            MK midVal = this.gBinaryHashMap.getKeyBySlot(keyCount, baseKeyOffset, baseValueOffset, keySlotNum, uncompressData);
            if (this.gComparator.compare(midVal, fromKey) < 0) {
                low = mid + 1;
                continue;
            }
            if (this.gComparator.compare(midVal, fromKey) > 0) {
                high = mid - 1;
                continue;
            }
            return inclusive ? mid : mid + 1;
        }
        return low;
    }

    @Override
    public SortedMap<MK, BinaryValue> headMap(MK toKey) {
        return this.subMap((MK)null, toKey);
    }

    @Override
    public SortedMap<MK, BinaryValue> tailMap(MK fromKey) {
        return this.subMap(fromKey, (MK)null);
    }

    @Override
    public MK firstKey() {
        int keyCount = this.keyCount();
        if (keyCount == 0) {
            return null;
        }
        return this.getMkBySortedIndex(keyCount, 0);
    }

    @Override
    public MK lastKey() {
        int keyCount = this.keyCount();
        if (keyCount == 0) {
            return null;
        }
        return this.getMkBySortedIndex(keyCount, keyCount - 1);
    }

    private MK getMkBySortedIndex(int keyCount, int sortedIndexSlot) {
        int indexLen = this.gBinaryHashMap.indexCount();
        int sortedIndexBaseOffset = this.gSortedHeader.getSortedIndexBaseOffset(indexLen, keyCount);
        int baseKeyOffset = GHashHeaderImpl.getHeaderKeyOffset(this.data);
        int baseValueOffset = GHashHeaderImpl.getHeaderValueOffset(this.data);
        int keySlotNum = this.gSortedHeader.getSortedIndexBySlot(this.data, sortedIndexBaseOffset, sortedIndexSlot);
        return this.gBinaryHashMap.getKeyBySlot(keyCount, baseKeyOffset, baseValueOffset, keySlotNum, null);
    }

    public long getVersion() {
        return this.gBinaryHashMap.getVersion();
    }

    public ByteBuffer getData() {
        return this.gBinaryHashMap.getData();
    }

    public static <MK, MV> GBinarySortedMap<MK> of(DataPage.DataPageType dataPageType, List<Tuple2<MK, GSValue<MV>>> keyValueList, TypeSerializer<MK> keySerializer, TypeSerializer<MV> valueSerializer, GComparator<MK> gComparator, long version, int logicPageId, Allocator allocator, long compactionCount) {
        int totalKeys = keyValueList.size();
        if (totalKeys == 0) {
            return EMPTY_G_BINARY_SORTEDMAP;
        }
        int indexLen = MathUtils.roundUpToPowerOfTwo((int)totalKeys);
        GSortedHeaderImpl gheader = GSortedHeaderImpl.getPageHelper(indexLen);
        GByteBuffer gByteBuffer = GBinaryHashMap.genByteBuffer(dataPageType, keyValueList, indexLen, totalKeys, gheader, keySerializer, valueSerializer, version, logicPageId, allocator, compactionCount, GCompressAlgorithm.None);
        ArrayList<Tuple2> slotAndKeyList = new ArrayList<Tuple2>();
        int i = 0;
        for (Tuple2 item : keyValueList) {
            slotAndKeyList.add(Tuple2.of((Object)item.f0, (Object)i));
            ++i;
        }
        Collections.sort(slotAndKeyList, (o1, o2) -> gComparator.compare(o1.f0, o2.f0));
        int index = 0;
        int baseOffset = gheader.getSortedIndexBaseOffset(indexLen, totalKeys);
        for (Tuple2 slot : slotAndKeyList) {
            gheader.writeSortedIndexBySlot(gByteBuffer.getByteBuffer(), baseOffset, index, ((Integer)slot.f1).intValue());
            ++index;
        }
        return new GBinarySortedMap<MK>(gheader, gByteBuffer.getByteBuffer(), keySerializer, gComparator);
    }

    public static <MK> GBinarySortedMap<MK> ofBinaryList(DataPage.DataPageType dataPageType, boolean isMajor, long version, int logicPageId, TypeSerializer<MK> keyTypeSerializer, GComparator<MK> gComparator, Allocator allocator, Map<BinaryKey, BinaryValue> newMap, long compactionCount, @Nullable StateFilter stateFilter, @Nullable GRegionContext gRegionContext) {
        ArrayList<Tuple2<BinaryKey, BinaryValue>> dataSet = new ArrayList<Tuple2<BinaryKey, BinaryValue>>();
        for (Map.Entry<BinaryKey, BinaryValue> entry : newMap.entrySet()) {
            BinaryValue binaryValue = entry.getValue();
            if (isMajor && (binaryValue.getGValueType() == GValueType.Delete || stateFilter != null && stateFilter.filter(gRegionContext, binaryValue.getSeqID()))) continue;
            dataSet.add(Tuple2.of((Object)entry.getKey(), (Object)entry.getValue()));
        }
        int totalKeys = dataSet.size();
        if (totalKeys == 0) {
            return EMPTY_G_BINARY_SORTEDMAP;
        }
        int indexLen = MathUtils.roundUpToPowerOfTwo((int)totalKeys);
        GSortedHeaderImpl gheader = GSortedHeaderImpl.getPageHelper(indexLen);
        GByteBuffer byteBuffer = GBinaryHashMap.genByteBufferByBinary(dataPageType, dataSet, indexLen, totalKeys, gheader, version, logicPageId, allocator, compactionCount, GCompressAlgorithm.None);
        ArrayList<Tuple2> slotAndKeyList = new ArrayList<Tuple2>();
        int i = 0;
        for (Tuple2 tuple2 : dataSet) {
            slotAndKeyList.add(Tuple2.of((Object)tuple2.f0, (Object)i));
            ++i;
        }
        Collections.sort(slotAndKeyList, (o1, o2) -> gComparator.compare((BinaryKey)o1.f0, (BinaryKey)o2.f0));
        int index = 0;
        int n = gheader.getSortedIndexBaseOffset(indexLen, totalKeys);
        for (Tuple2 slot : slotAndKeyList) {
            gheader.writeSortedIndexBySlot(byteBuffer.getByteBuffer(), n, index, ((Integer)slot.f1).intValue());
            ++index;
        }
        return new GBinarySortedMap<MK>(gheader, byteBuffer.getByteBuffer(), keyTypeSerializer, gComparator);
    }

    @Override
    public void retain() {
        if (this.gBinaryHashMap != null) {
            this.gBinaryHashMap.retain();
        }
    }

    @Override
    public void release() {
        if (this.gBinaryHashMap != null) {
            this.gBinaryHashMap.release();
        }
    }

    @Override
    public int refCnt() {
        if (this.gBinaryHashMap == null) {
            return 0;
        }
        return this.gBinaryHashMap.refCnt();
    }

    @VisibleForTesting
    public GBinaryHashMap<MK> getGBinaryHashMap() {
        return this.gBinaryHashMap;
    }
}

