/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.gemini.engine.page.bmap;

import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.runtime.state.gemini.engine.exceptions.GeminiRuntimeException;
import org.apache.flink.runtime.state.gemini.engine.memstore.GSValue;
import org.apache.flink.runtime.state.gemini.engine.page.DataPage;
import org.apache.flink.runtime.state.gemini.engine.page.GValueType;
import org.apache.flink.runtime.state.gemini.engine.page.bmap.AbstractGRoutingValue;
import org.apache.flink.runtime.state.gemini.engine.page.bmap.BinaryValue;
import org.apache.flink.runtime.state.gemini.engine.page.bmap.BinaryValueForSplit;
import org.apache.flink.runtime.state.gemini.engine.page.bmap.ByteBufferDataInputView;
import org.apache.flink.runtime.state.gemini.engine.page.bmap.GBinaryHashMap;
import org.apache.flink.runtime.state.gemini.engine.page.bmap.GBufferAddressMapping;
import org.apache.flink.runtime.state.gemini.engine.page.bmap.GHashHeader;
import org.apache.flink.runtime.state.gemini.engine.page.bmap.GHashHeaderImpl;
import org.apache.flink.runtime.state.gemini.engine.page.bmap.GHashRoutingValue;
import org.apache.flink.runtime.state.gemini.engine.page.bmap.GSortedRoutingValue;
import org.apache.flink.runtime.state.gemini.engine.rm.GByteBuffer;

public class GBinarySplitHashMap<K>
extends GBinaryHashMap<K> {
    private GBufferAddressMapping mapping;

    public GBinarySplitHashMap(GBinaryHashMap<K> gBinaryHashMap, GBufferAddressMapping mapping) {
        super(gBinaryHashMap.getPageHelper(), gBinaryHashMap.data, gBinaryHashMap.getKeyTypeSerializer(), gBinaryHashMap.getOriginChecksum());
        this.mapping = mapping;
    }

    public GBinarySplitHashMap(GByteBuffer data, TypeSerializer<K> keyTypeSerializer) {
        super(data, keyTypeSerializer);
    }

    public GBinarySplitHashMap(GByteBuffer data, TypeSerializer<K> keyTypeSerializer, int originCheckSum) {
        super(data, keyTypeSerializer, originCheckSum);
    }

    public GBinarySplitHashMap(GHashHeader pageHelper, GByteBuffer data, TypeSerializer<K> keyTypeSerializer) {
        this(pageHelper, data, keyTypeSerializer, GBinarySplitHashMap.genOriginCheckSum(data.getByteBuffer()));
    }

    public GBinarySplitHashMap(GHashHeader pageHelper, GByteBuffer data, TypeSerializer<K> keyTypeSerializer, int originCheckSum) {
        super(pageHelper, data, keyTypeSerializer, originCheckSum);
    }

    public void setMapping(GBufferAddressMapping mapping) {
        this.mapping = mapping;
    }

    public GBufferAddressMapping getBufferAddressMapping() {
        return this.mapping;
    }

    @Override
    BinaryValue getBinaryValue(int keyCount, int indexLen, int baseValueOffset, int slotNum, AtomicReference<ByteBuffer> uncompressValueData) {
        BinaryValue binaryValue = super.getBinaryValue(keyCount, indexLen, baseValueOffset, slotNum, uncompressValueData);
        if (this.isSplitBinaryValue(binaryValue)) {
            return new BinaryValueForSplit(binaryValue, this.mapping);
        }
        return binaryValue;
    }

    private boolean isSplitBinaryValue(BinaryValue binaryValue) {
        return binaryValue.getBb() != null && (AbstractGRoutingValue.getHeaderGRoutingType(binaryValue) == DataPage.DataPageType.KSplitHashRouting.getCode() || AbstractGRoutingValue.getHeaderGRoutingType(binaryValue) == DataPage.DataPageType.KSplitSortedRouting.getCode());
    }

    @Override
    public <V> Map<K, GSValue<V>> toPOJOMap(Map<K, GSValue<V>> result, TypeSerializer<V> valueTypeSerializer) {
        try {
            int keyCount = this.keyCount();
            if (keyCount == 0) {
                return result;
            }
            int indexLen = this.indexCount();
            int baseKeyOffset = GHashHeaderImpl.getHeaderKeyOffset(this.data.getByteBuffer());
            int baseValueOffset = GHashHeaderImpl.getHeaderValueOffset(this.data.getByteBuffer());
            AtomicReference<ByteBuffer> uncompressData = new AtomicReference<ByteBuffer>();
            AtomicReference<ByteBuffer> uncompressValueData = new AtomicReference<ByteBuffer>();
            for (int i = 0; i < keyCount; ++i) {
                Object k = this.getKeyBySlot(keyCount, baseKeyOffset, baseValueOffset, i, uncompressData);
                BinaryValue binaryValue = this.getBinaryValue(keyCount, indexLen, baseValueOffset, i, uncompressValueData);
                if (binaryValue.getGValueType() == GValueType.Delete) {
                    result.put(k, new GSValue<Object>(null, binaryValue.getGValueType(), binaryValue.getSeqID()));
                    continue;
                }
                if (GHashRoutingValue.isGHashRoutingValue(binaryValue) || GSortedRoutingValue.isGSortedRoutingValue(binaryValue)) {
                    List<GByteBuffer> bufferList = AbstractGRoutingValue.getAllSubMapByteBuffer(binaryValue);
                    HashMap mergeMap = new HashMap();
                    for (GByteBuffer subMapBB : bufferList) {
                        ByteBufferDataInputView byteBufferDataInputView = new ByteBufferDataInputView(subMapBB.getByteBuffer(), 0, subMapBB.capacity());
                        Object value = valueTypeSerializer.deserialize((DataInputView)byteBufferDataInputView);
                        if (!(value instanceof Map)) {
                            throw new GeminiRuntimeException("BUG, GBinarySplitHashMap just for KMap.");
                        }
                        mergeMap.putAll((Map)value);
                    }
                    result.put(k, new GSValue(mergeMap, binaryValue.getGValueType(), binaryValue.getSeqID()));
                    continue;
                }
                ByteBufferDataInputView byteBufferDataInputView = new ByteBufferDataInputView(binaryValue.getBb(), binaryValue.getValueOffset(), binaryValue.getValueLen());
                Object value = valueTypeSerializer.deserialize((DataInputView)byteBufferDataInputView);
                result.put(k, new GSValue<Object>(value, binaryValue.getGValueType(), binaryValue.getSeqID()));
            }
            return result;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new GeminiRuntimeException(e);
        }
    }
}

