/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.gemini.engine.page.bmap;

import javax.annotation.Nullable;
import org.apache.flink.runtime.state.gemini.engine.GRegionContext;
import org.apache.flink.runtime.state.gemini.engine.exceptions.GeminiRuntimeException;
import org.apache.flink.runtime.state.gemini.engine.page.DataPage;
import org.apache.flink.runtime.state.gemini.engine.page.PageAddress;
import org.apache.flink.runtime.state.gemini.engine.page.PageAddressSingleImpl;
import org.apache.flink.runtime.state.gemini.engine.page.PageContext;
import org.apache.flink.runtime.state.gemini.engine.rm.GByteBuffer;
import org.apache.flink.runtime.state.gemini.engine.rm.GSharedUnreferencedByteBuffer;
import org.apache.flink.util.Preconditions;

public class GBufferAddressMapping {
    GRegionContext gRegionContext;
    private PageAddress[] mapping;
    private int logicPageChainIndex;
    private int logicPageHashCode;
    private int nextId;
    private static final int EMPTY_SUB_PAGE_ADDRESS_ID = -1;
    private static final int PAGE_ADDRESS_ARRAY_DEFAULT_LENGTH = 16;

    public GBufferAddressMapping(GRegionContext gRegionContext, int logicPageChainIndex, int logicPageHashCode) {
        this.gRegionContext = gRegionContext;
        this.mapping = new PageAddress[16];
        this.logicPageChainIndex = logicPageChainIndex;
        this.logicPageHashCode = logicPageHashCode;
        this.nextId = 0;
    }

    public GBufferAddressMapping(PageAddress[] subPages, GRegionContext gRegionContext, int logicPageChainIndex, int logicPageHashCode) {
        this.gRegionContext = gRegionContext;
        this.mapping = subPages;
        this.nextId = subPages.length;
        this.logicPageChainIndex = logicPageChainIndex;
        this.logicPageHashCode = logicPageHashCode;
    }

    public void setLogicPageChainIndex(int newLogicPageChainIndex) {
        this.logicPageChainIndex = newLogicPageChainIndex;
    }

    public void setLogicPageHashCode(int newLogicPageHashCode) {
        this.logicPageHashCode = newLogicPageHashCode;
    }

    public int putGByteBufferAddress(DataPage dataPage) {
        if (this.isEmptySubPage(dataPage)) {
            return -1;
        }
        if (this.nextId == this.mapping.length) {
            PageAddress[] newMapping = new PageAddress[this.mapping.length * 2];
            System.arraycopy(this.mapping, 0, newMapping, 0, this.mapping.length);
            this.mapping = newMapping;
        }
        int id = this.nextId++;
        this.mapping[id] = new PageAddressSingleImpl(dataPage);
        return id;
    }

    public int putGByteBufferAddress(PageAddress pageAddress) {
        if (pageAddress == null) {
            return -1;
        }
        Preconditions.checkArgument((boolean)(pageAddress instanceof PageAddressSingleImpl));
        if (this.nextId == this.mapping.length) {
            PageAddress[] newMapping = new PageAddress[this.mapping.length * 2];
            System.arraycopy(this.mapping, 0, newMapping, 0, this.mapping.length);
            this.mapping = newMapping;
        }
        int id = this.nextId++;
        this.mapping[id] = pageAddress;
        return id;
    }

    private boolean isEmptySubPage(DataPage subPage) {
        return subPage.getGBinaryHashMap() == null || subPage.getGBinaryHashMap().getGByteBuffer() == null || subPage.getGBinaryHashMap().getGByteBuffer().capacity() == 0;
    }

    @Nullable
    public <MK> GByteBuffer getGByteBuffer(int id, MK mapKey) {
        PageAddress pageAddress = this.getGByteBufferAddress(id);
        return this.getGByteBuffer(pageAddress, mapKey);
    }

    @Nullable
    public PageAddress getGByteBufferAddress(int id) {
        if (id == -1) {
            return null;
        }
        if (id >= this.nextId || id >= this.mapping.length) {
            throw new IndexOutOfBoundsException("index=" + id + ", nextId=" + this.nextId + ", mappingLen=" + this.mapping.length);
        }
        return this.mapping[id];
    }

    @Nullable
    public <MK> GByteBuffer getGByteBuffer(PageAddress pageAddress, MK mapKey) {
        if (pageAddress == null) {
            return null;
        }
        Preconditions.checkArgument((boolean)(pageAddress instanceof PageAddressSingleImpl));
        DataPage dataPage = pageAddress.getDataPageNoReference();
        if (pageAddress.hasDataPage() && dataPage != null) {
            this.gRegionContext.getGContext().getSupervisor().getCacheManager().getCacheStats().addSubPageCacheHitCount();
            dataPage.addRequestCount(this.gRegionContext.getGContext().getSupervisor().getCacheManager().getCurrentTickTime(), 1);
            return new GSharedUnreferencedByteBuffer(dataPage.getGBinaryHashMap().getGByteBuffer());
        }
        PageContext pageContext = PageContext.INVALID_PAGE_CONTEXT;
        if (this.logicPageChainIndex >= 0) {
            pageContext = PageContext.of(this.gRegionContext.getRegionId(), this.logicPageChainIndex, this.logicPageHashCode, PageContext.CacheStatus.IN_LRU);
        }
        if (mapKey != null && !this.gRegionContext.getGContext().getSupervisor().getBloomFilterManager().mightContain(pageAddress, mapKey.hashCode())) {
            this.gRegionContext.getGContext().getSupervisor().getCacheManager().getCacheStats().addBloomFilterHitCount();
            return null;
        }
        GByteBuffer buffer = this.gRegionContext.getGContext().getSupervisor().getFetchPolicy().fetchSubPage(pageAddress, pageContext, this.gRegionContext, true);
        buffer.release();
        return new GSharedUnreferencedByteBuffer(buffer);
    }

    public int[] mergeMapping(GBufferAddressMapping subMapping, int[] oldIdList) {
        int[] newIdList = new int[oldIdList.length];
        PageAddress[] address = subMapping.getPageAddressArray();
        for (int i = 0; i < oldIdList.length; ++i) {
            if (oldIdList[i] == -1) {
                newIdList[i] = -1;
                continue;
            }
            if (this.nextId == this.mapping.length) {
                PageAddress[] newMapping = new PageAddress[this.mapping.length * 2];
                System.arraycopy(this.mapping, 0, newMapping, 0, this.mapping.length);
                this.mapping = newMapping;
            }
            newIdList[i] = this.nextId;
            this.mapping[this.nextId++] = address[oldIdList[i]];
        }
        return newIdList;
    }

    public GByteBuffer pollGByteBuffer() {
        if (this.isEmpty()) {
            throw new GeminiRuntimeException("Exception inGBufferAddressMapping: attempt to poll GByteBuffer from a empty mapping");
        }
        --this.nextId;
        PageAddress bufferAddress = this.mapping[this.nextId];
        this.mapping[this.nextId] = null;
        return new GSharedUnreferencedByteBuffer(bufferAddress.getGByteBufferNoReference());
    }

    public int size() {
        return this.nextId;
    }

    public boolean isEmpty() {
        return this.nextId == 0;
    }

    public PageAddress[] getSubPageAddress() {
        PageAddress[] subPageAddress = new PageAddress[this.nextId];
        System.arraycopy(this.mapping, 0, subPageAddress, 0, this.nextId);
        return subPageAddress;
    }

    private PageAddress[] getPageAddressArray() {
        return this.mapping;
    }
}

