/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.gemini.engine.page.bmap;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Arrays;
import org.apache.flink.annotation.Internal;
import org.apache.flink.runtime.state.gemini.engine.page.bmap.ByteBufferUtils;
import org.apache.flink.util.Preconditions;

@Internal
public class GByteArrayOutputStreamWithPos
extends OutputStream {
    protected byte[] buffer;
    protected int count;

    public GByteArrayOutputStreamWithPos() {
        this(64);
    }

    public GByteArrayOutputStreamWithPos(int size) {
        Preconditions.checkArgument((size >= 0 ? 1 : 0) != 0);
        this.buffer = new byte[size];
    }

    public GByteArrayOutputStreamWithPos(byte[] bytes) {
        Preconditions.checkArgument((bytes.length >= 0 ? 1 : 0) != 0);
        this.buffer = bytes;
    }

    private void ensureCapacity(int requiredCapacity) {
        if (requiredCapacity - this.buffer.length > 0) {
            this.increaseCapacity(requiredCapacity);
        }
    }

    private void increaseCapacity(int requiredCapacity) {
        int oldCapacity = this.buffer.length;
        int newCapacity = oldCapacity << 1;
        if (newCapacity - requiredCapacity < 0) {
            newCapacity = requiredCapacity;
        }
        if (newCapacity < 0) {
            if (requiredCapacity < 0) {
                throw new OutOfMemoryError();
            }
            newCapacity = Integer.MAX_VALUE;
        }
        this.buffer = Arrays.copyOf(this.buffer, newCapacity);
    }

    @Override
    public void write(int b) {
        this.ensureCapacity(this.count + 1);
        this.buffer[this.count] = (byte)b;
        ++this.count;
    }

    @Override
    public void write(byte[] b, int off, int len) {
        if (off < 0 || len < 0 || off > b.length || off + len - b.length > 0) {
            throw new IndexOutOfBoundsException();
        }
        this.ensureCapacity(this.count + len);
        System.arraycopy(b, off, this.buffer, this.count, len);
        this.count += len;
    }

    public void reset() {
        this.count = 0;
    }

    public int size() {
        return this.count;
    }

    public int getPosition() {
        return this.count;
    }

    public void setPosition(int position) {
        Preconditions.checkArgument((position >= 0 ? 1 : 0) != 0, (Object)"Position out of bounds.");
        this.ensureCapacity(position + 1);
        this.count = position;
    }

    @Override
    public void close() throws IOException {
    }

    public byte[] getBuf() {
        return this.buffer;
    }

    public void write(ByteBuffer bb, int off, int len) throws IOException {
        this.ensureCapacity(this.count + len);
        ByteBufferUtils.copyFromBufferToArray(bb, this.buffer, off, this.count, len);
        this.count += len;
    }

    public void writeInt(int lastKeyPosition) {
        this.ensureCapacity(this.count + 4);
        this.buffer[this.count] = (byte)(lastKeyPosition >>> 24 & 0xFF);
        ++this.count;
        this.buffer[this.count] = (byte)(lastKeyPosition >>> 16 & 0xFF);
        ++this.count;
        this.buffer[this.count] = (byte)(lastKeyPosition >>> 8 & 0xFF);
        ++this.count;
        this.buffer[this.count] = (byte)(lastKeyPosition >>> 0 & 0xFF);
        ++this.count;
    }
}

