/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.gemini.engine.page.bmap;

import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Comparator;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.core.memory.DataOutputViewStreamWrapper;
import org.apache.flink.runtime.state.gemini.engine.page.bmap.BinaryKey;
import org.apache.flink.runtime.state.gemini.engine.page.bmap.ByteBufferUtils;
import org.apache.flink.runtime.state.gemini.engine.page.bmap.GByteArrayOutputStreamWithPos;
import org.apache.flink.runtime.state.gemini.engine.page.bmap.GComparator;

public class GComparatorBytesImpl<K>
implements GComparator<K> {
    private static final int DEFAULT_REUSED_LEN = 100;
    private final Comparator<K> jdkComparator;
    private final TypeSerializer<K> typeSerializer;
    private final ThreadLocal<byte[]> reusedBytes;

    public GComparatorBytesImpl(Comparator<K> jdkComparator, TypeSerializer<K> typeSerializer) {
        this(jdkComparator, typeSerializer, 100);
    }

    public GComparatorBytesImpl(Comparator<K> jdkComparator, TypeSerializer<K> typeSerializer, int reusedLen) {
        this.jdkComparator = jdkComparator;
        this.typeSerializer = typeSerializer;
        this.reusedBytes = ThreadLocal.withInitial(() -> new byte[reusedLen]);
    }

    @Override
    public int compare(BinaryKey left, BinaryKey right) {
        return ByteBufferUtils.compareTo(left.getBb(), left.getKeyOffset(), left.getKeyLen(), right.getBb(), right.getKeyOffset(), right.getKeyLen());
    }

    @Override
    public int compare(K left, K right) {
        return this.jdkComparator.compare(left, right);
    }

    @Override
    public int compare(K left, BinaryKey right) {
        try {
            byte[] reusedBB = this.reusedBytes.get();
            GByteArrayOutputStreamWithPos outputStreamForValue = new GByteArrayOutputStreamWithPos(reusedBB);
            DataOutputViewStreamWrapper outputViewForValue = new DataOutputViewStreamWrapper((OutputStream)outputStreamForValue);
            int offset1 = 0;
            this.typeSerializer.serialize(left, (DataOutputView)outputViewForValue);
            int len1 = outputStreamForValue.getPosition();
            ByteBuffer bb = ByteBuffer.wrap(outputStreamForValue.getBuf());
            if (len1 > reusedBB.length) {
                this.reusedBytes.set(outputStreamForValue.getBuf());
            }
            return ByteBufferUtils.compareTo(bb, offset1, len1, right.getBb(), right.getKeyOffset(), right.getKeyLen());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Comparator<K> getJDKCompactor() {
        return this.jdkComparator;
    }

    @Override
    public Comparator<BinaryKey> getJDKBinaryCompactor() {
        return this::compare;
    }

    @VisibleForTesting
    ThreadLocal<byte[]> getReusedBytes() {
        return this.reusedBytes;
    }
}

