/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.gemini.engine.page.bmap;

import java.util.Comparator;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.runtime.state.gemini.engine.page.bmap.BinaryKey;
import org.apache.flink.runtime.state.gemini.engine.page.bmap.ByteBufferDataInputView;
import org.apache.flink.runtime.state.gemini.engine.page.bmap.GComparator;

public class GComparatorUserImpl<K>
implements GComparator<K> {
    private final Comparator<K> jdkComparator;
    private final TypeSerializer<K> typeSerializer;

    public GComparatorUserImpl(Comparator<K> jdkComparator, TypeSerializer<K> typeSerializer) {
        this.jdkComparator = jdkComparator;
        this.typeSerializer = typeSerializer;
    }

    @Override
    public int compare(BinaryKey left, BinaryKey right) {
        try {
            ByteBufferDataInputView leftDataInputView = new ByteBufferDataInputView(left.getBb(), left.getKeyOffset(), left.getKeyLen());
            Object leftK = this.typeSerializer.deserialize((DataInputView)leftDataInputView);
            ByteBufferDataInputView rightDataInputView = new ByteBufferDataInputView(right.getBb(), right.getKeyOffset(), right.getKeyLen());
            Object rigtK = this.typeSerializer.deserialize((DataInputView)rightDataInputView);
            return this.jdkComparator.compare(leftK, rigtK);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public int compare(K left, K right) {
        return this.jdkComparator.compare(left, right);
    }

    @Override
    public int compare(K left, BinaryKey right) {
        try {
            ByteBufferDataInputView rightDataInputView = new ByteBufferDataInputView(right.getBb(), right.getKeyOffset(), right.getKeyLen());
            Object rigtK = this.typeSerializer.deserialize((DataInputView)rightDataInputView);
            return this.jdkComparator.compare(left, rigtK);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Comparator<K> getJDKCompactor() {
        return this.jdkComparator;
    }

    @Override
    public Comparator<BinaryKey> getJDKBinaryCompactor() {
        return this::compare;
    }
}

