/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.gemini.engine.page.bmap;

import java.nio.ByteBuffer;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.runtime.state.gemini.engine.page.bmap.ByteBufferUtils;
import org.apache.flink.runtime.state.gemini.engine.page.bmap.GHashHeader;

public enum GHashHeaderImpl implements GHashHeader
{
    LongIndexPage(8){
        public final int fourBytesBits = 32;
        public final long fourBytesMask = 0xFFFFFFFFL;
        public final long headerIndexInitialValue = -1L;

        @Override
        public void initIndex(int indexUnitLen, ByteBuffer headerAndIndex, int indexLen) {
            for (int i = 0; i < indexLen; ++i) {
                ByteBufferUtils.putLong(headerAndIndex, 64 + i * indexUnitLen, -1L);
            }
        }

        @Override
        public long getIndexBySlot(int indexUnitLen, ByteBuffer headerAndIndex, int indexSlot) {
            return ByteBufferUtils.toLong(headerAndIndex, 64 + indexSlot * indexUnitLen);
        }

        @Override
        public void writeIndexBySlot(int indexUnitLen, ByteBuffer headerAndIndexBB, int indexSlot, long newIndexValue) {
            ByteBufferUtils.putLong(headerAndIndexBB, 64 + indexSlot * indexUnitLen, newIndexValue);
        }

        @Override
        public int getCountByIndexValue(long indexValue) {
            return (int)(indexValue >>> 32 & 0xFFFFFFFFL);
        }

        @Override
        public int getSlotByIndexValue(long indexValue) {
            return (int)(indexValue & 0xFFFFFFFFL);
        }

        @Override
        public long getInitialIndexValue() {
            return -1L;
        }

        @Override
        public long getNewIndexValue(long oldIndexValue, int slot) {
            if (oldIndexValue == -1L) {
                return 0x100000000L | (long)slot & 0xFFFFFFFFL;
            }
            return (oldIndexValue >>> 32 & 0xFFFFFFFFL) + 1L << 32 | oldIndexValue & 0xFFFFFFFFL;
        }
    }
    ,
    IntegerIndexPage(4){
        public final int twoBytesBits = 16;
        public final int towBytesMask = 65535;
        public final int headerIndexInitialValue = -1;

        @Override
        public void initIndex(int indexUnitLen, ByteBuffer headerAndIndex, int indexLen) {
            for (int i = 0; i < indexLen; ++i) {
                ByteBufferUtils.putInt(headerAndIndex, 64 + i * indexUnitLen, -1);
            }
        }

        @Override
        public long getIndexBySlot(int indexUnitLen, ByteBuffer headerAndIndex, int indexSlot) {
            return ByteBufferUtils.toInt(headerAndIndex, 64 + indexSlot * indexUnitLen);
        }

        @Override
        public void writeIndexBySlot(int indexUnitLen, ByteBuffer headerAndIndexBB, int indexSlot, long newIndexValue) {
            ByteBufferUtils.putInt(headerAndIndexBB, 64 + indexSlot * indexUnitLen, (int)newIndexValue);
        }

        @Override
        public int getCountByIndexValue(long indexValue) {
            return (int)(indexValue >>> 16 & 0xFFFFL);
        }

        @Override
        public int getSlotByIndexValue(long indexValue) {
            return (int)(indexValue & 0xFFFFL);
        }

        @Override
        public long getInitialIndexValue() {
            return -1L;
        }

        @Override
        public long getNewIndexValue(long oldIndexValue, int slot) {
            if (oldIndexValue == -1L) {
                return 0x10000L | (long)(slot & 0xFFFF);
            }
            return (oldIndexValue >>> 16 & 0xFFFFL) + 1L << 16 | oldIndexValue & 0xFFFFL;
        }
    };

    private final int indexUnitLen;
    public static final int HEADER_LENGTH = 64;
    public static final int VALUE_TYPE_INDICATOR_BITS = 28;
    public static final int VALUE_TYPE_INDICATOR_MARK = 0xFFFFFFF;
    private static final int HEADER_PAGE_TYPE_OFFSET = 0;
    private static final int HEADER_PAGE_ID_START_OFFSET = 1;
    private static final int HEADER_TOTAL_KEY_START_OFFSET = 5;
    private static final int HEADER_INDEX_COUNT_START_OFFSET = 9;
    private static final int HEADER_KEY_OFFSET_OFFSET = 13;
    private static final int HEADER_VALUE_OFFSET_OFFSET = 17;
    private static final int HEADER_COMPRESS_CODEC_OFFSET = 21;
    private static final int HEADER_UNCOMPRESS_KEY_P_SIZE_OFFSET = 22;
    private static final int HEADER_UNCOMPRESS_VALUE_P_SIZE_OFFSET = 26;
    private static final int HEADER_VERSION_OFFSET = 30;
    private static final int HEADER_STAT_COMPACTION_COUNT_OFFSET = 38;

    private GHashHeaderImpl(int indexUnitLen) {
        this.indexUnitLen = indexUnitLen;
    }

    public static GHashHeaderImpl getPageHelper(int indexLen) {
        if (indexLen <= 65536) {
            return IntegerIndexPage;
        }
        return LongIndexPage;
    }

    public abstract void initIndex(int var1, ByteBuffer var2, int var3);

    public abstract long getIndexBySlot(int var1, ByteBuffer var2, int var3);

    public abstract void writeIndexBySlot(int var1, ByteBuffer var2, int var3, long var4);

    @Override
    public abstract int getCountByIndexValue(long var1);

    @Override
    public abstract int getSlotByIndexValue(long var1);

    @Override
    public abstract long getInitialIndexValue();

    @Override
    public abstract long getNewIndexValue(long var1, int var3);

    @Override
    public void initIndex(ByteBuffer headerAndIndex, int indexLen) {
        this.initIndex(this.indexUnitLen, headerAndIndex, indexLen);
    }

    @Override
    public long getIndexBySlot(ByteBuffer headerAndIndex, int indexSlot) {
        return this.getIndexBySlot(this.indexUnitLen, headerAndIndex, indexSlot);
    }

    @Override
    public void writeIndexBySlot(ByteBuffer headerAndIndexBB, int indexSlot, long newIndexValue) {
        this.writeIndexBySlot(this.indexUnitLen, headerAndIndexBB, indexSlot, newIndexValue);
    }

    @Override
    public void writeHashCode(ByteBuffer headerAndIndexBB, int indexLen, int keyCursor, int hashCode2) {
        ByteBufferUtils.putInt(headerAndIndexBB, 64 + indexLen * this.indexUnitLen + keyCursor * 4, hashCode2);
    }

    @Override
    public void writeSeqIDBytSlot(ByteBuffer headerAndIndexBB, int indexLen, int totalKeys, long seqID, int keyCursor) {
        ByteBufferUtils.putLong(headerAndIndexBB, 64 + indexLen * this.indexUnitLen + totalKeys * 4 + keyCursor * 8, seqID);
    }

    public static void writeHeadPageType(ByteBuffer headerAndIndexBB, byte pageType) {
        ByteBufferUtils.putByte(headerAndIndexBB, 0, pageType);
    }

    public static void writeHeadPageID(ByteBuffer headerAndIndexBB, int logicPageId) {
        ByteBufferUtils.putInt(headerAndIndexBB, 1, logicPageId);
    }

    public static void writeHeaderTotalKeyCount(ByteBuffer headerAndIndexBB, int totalKeys) {
        ByteBufferUtils.putInt(headerAndIndexBB, 5, totalKeys);
    }

    public static void writeHeaderIndexCount(ByteBuffer headerAndIndexBB, int indexLen) {
        ByteBufferUtils.putInt(headerAndIndexBB, 9, indexLen);
    }

    public static void writeHeaderKeyOffset(ByteBuffer headerAndIndexBB, int offset) {
        ByteBufferUtils.putInt(headerAndIndexBB, 13, offset);
    }

    public static void writeHeaderValueOffset(ByteBuffer headerAndIndexBB, int offset) {
        ByteBufferUtils.putInt(headerAndIndexBB, 17, offset);
    }

    public static void writeHeaderVersion(ByteBuffer headerAndIndexBB, long version) {
        ByteBufferUtils.putLong(headerAndIndexBB, 30, version);
    }

    public static void writeHeaderStatCompactionCount(ByteBuffer headerAndIndexBB, long compactionCount) {
        ByteBufferUtils.putLong(headerAndIndexBB, 38, compactionCount);
    }

    public static void writeHeaderCompressCode(ByteBuffer headerAndIndexBB, byte compressCode) {
        ByteBufferUtils.putByte(headerAndIndexBB, 21, compressCode);
    }

    public static void writeHeaderKeyUncompressSize(ByteBuffer headerAndIndexBB, int uncompressSize) {
        ByteBufferUtils.putInt(headerAndIndexBB, 22, uncompressSize);
    }

    public static void writeHeaderValueUncompressSize(ByteBuffer headerAndIndexBB, int uncompressSize) {
        ByteBufferUtils.putInt(headerAndIndexBB, 26, uncompressSize);
    }

    public static byte getHeadPageType(ByteBuffer headerAndIndexBB) {
        return ByteBufferUtils.toByte(headerAndIndexBB, 0);
    }

    public static int getHeadPageID(ByteBuffer headerAndIndexBB) {
        return ByteBufferUtils.toInt(headerAndIndexBB, 1);
    }

    public static int getHeaderTotalKeyCount(ByteBuffer headerAndIndexBB) {
        return ByteBufferUtils.toInt(headerAndIndexBB, 5);
    }

    public static int getHeaderIndexCount(ByteBuffer headerAndIndexBB) {
        return ByteBufferUtils.toInt(headerAndIndexBB, 9);
    }

    public static int getHeaderKeyOffset(ByteBuffer headerAndIndexBB) {
        return ByteBufferUtils.toInt(headerAndIndexBB, 13);
    }

    public static int getHeaderValueOffset(ByteBuffer headerAndIndexBB) {
        return ByteBufferUtils.toInt(headerAndIndexBB, 17);
    }

    public static byte getHeaderCompressCode(ByteBuffer headerAndIndexBB) {
        return ByteBufferUtils.toByte(headerAndIndexBB, 21);
    }

    public static int getHeaderKeyUncompressSize(ByteBuffer headerAndIndexBB) {
        return ByteBufferUtils.toInt(headerAndIndexBB, 22);
    }

    public static int getHeaderValueUncompressSize(ByteBuffer headerAndIndexBB) {
        return ByteBufferUtils.toInt(headerAndIndexBB, 26);
    }

    public static long getHeaderVersion(ByteBuffer headerAndIndexBB) {
        return ByteBufferUtils.toLong(headerAndIndexBB, 30);
    }

    public static long getHeaderStatCompactionCount(ByteBuffer headerAndIndexBB) {
        return ByteBufferUtils.toLong(headerAndIndexBB, 38);
    }

    @Override
    public int getHashCode(ByteBuffer headerAndIndexBB, int indexLen, int keyCursor) {
        return ByteBufferUtils.toInt(headerAndIndexBB, 64 + indexLen * this.indexUnitLen + keyCursor * 4);
    }

    public static int getEndOffsetBySlot(ByteBuffer data, int baseOffset, int keySlot) {
        return ByteBufferUtils.toInt(data, baseOffset + keySlot * 4);
    }

    @Override
    public long getSeqIDBytSlot(ByteBuffer headerAndIndexBB, int indexLen, int totalKeys, int keyCursor) {
        return ByteBufferUtils.toLong(headerAndIndexBB, 64 + indexLen * this.indexUnitLen + totalKeys * 4 + keyCursor * 8);
    }

    @Override
    public int getHeaderAndIndexLen(int indexLen, int totalKeys) {
        return 64 + indexLen * this.indexUnitLen + totalKeys * 4 + totalKeys * 8;
    }

    @VisibleForTesting
    public int getHeaderPageTypeOffset() {
        return 0;
    }
}

