/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.gemini.engine.page.bmap;

import java.util.ArrayList;
import java.util.List;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.runtime.state.gemini.engine.page.DataPage;
import org.apache.flink.runtime.state.gemini.engine.page.PageAddress;
import org.apache.flink.runtime.state.gemini.engine.page.bmap.AbstractGRoutingValue;
import org.apache.flink.runtime.state.gemini.engine.page.bmap.BinaryValue;
import org.apache.flink.runtime.state.gemini.engine.page.bmap.BinaryValueForSplit;
import org.apache.flink.runtime.state.gemini.engine.page.bmap.ByteBufferUtils;
import org.apache.flink.runtime.state.gemini.engine.page.bmap.GBinaryHashMap;
import org.apache.flink.runtime.state.gemini.engine.rm.GByteBuffer;
import org.apache.flink.util.Preconditions;

public class GHashRoutingValue
extends AbstractGRoutingValue {
    public static boolean isGHashRoutingValue(BinaryValue binaryValue) {
        return binaryValue instanceof BinaryValueForSplit && GHashRoutingValue.getHeaderGRoutingType(binaryValue) == DataPage.DataPageType.KSplitHashRouting.getCode();
    }

    public static <MK> GBinaryHashMap<MK> getSubGBinaryHashMap(BinaryValue binaryValue, MK mapKey, TypeSerializer<MK> mkTypeSerializer) {
        int subMapCount = GHashRoutingValue.getSubMapCount(binaryValue);
        int indexSlot = mapKey.hashCode() & subMapCount - 1;
        return GHashRoutingValue.getSubGBinaryHashMapWithKey(mapKey, indexSlot, binaryValue, mkTypeSerializer);
    }

    public static <MK> List<GBinaryHashMap<MK>> getAllSubGBinaryHashMap(BinaryValue binaryValue, TypeSerializer<MK> mkTypeSerializer) {
        Preconditions.checkState((boolean)(binaryValue instanceof BinaryValueForSplit));
        int subMapCount = GHashRoutingValue.getSubMapCount(binaryValue);
        ArrayList<GBinaryHashMap<MK>> subMapList = new ArrayList<GBinaryHashMap<MK>>(subMapCount);
        for (int i = 0; i < subMapCount; ++i) {
            int subMapId = ByteBufferUtils.toInt(binaryValue.getBb(), binaryValue.getValueOffset() + GHashRoutingValue.getGRoutingBaseValueOffset(binaryValue) + i * 4);
            GByteBuffer bb = binaryValue.getPageMapping().getGByteBuffer(subMapId, null);
            if (bb == null) continue;
            subMapList.add(new GBinaryHashMap<MK>(bb, mkTypeSerializer));
        }
        return subMapList;
    }

    public static <MK> GBinaryHashMap<MK> getSubGBinaryHashMapWithKey(MK mapKey, int hashIndex, BinaryValue binaryValue, TypeSerializer<MK> mkTypeSerializer) {
        Preconditions.checkState((boolean)(binaryValue instanceof BinaryValueForSplit));
        int subMapId = ByteBufferUtils.toInt(binaryValue.getBb(), binaryValue.getValueOffset() + GHashRoutingValue.getGRoutingBaseValueOffset(binaryValue) + hashIndex * 4);
        GByteBuffer bb = binaryValue.getPageMapping().getGByteBuffer(subMapId, mapKey);
        return new GBinaryHashMap<MK>(bb, mkTypeSerializer);
    }

    public static PageAddress getSubMapPageAddress(int hashIndex, BinaryValue binaryValue) {
        Preconditions.checkState((boolean)(binaryValue instanceof BinaryValueForSplit));
        int subMapId = ByteBufferUtils.toInt(binaryValue.getBb(), binaryValue.getValueOffset() + GHashRoutingValue.getGRoutingBaseValueOffset(binaryValue) + hashIndex * 4);
        return binaryValue.getPageMapping().getGByteBufferAddress(subMapId);
    }
}

