/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.gemini.engine.page.bmap;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.runtime.state.gemini.engine.exceptions.GeminiRuntimeException;
import org.apache.flink.runtime.state.gemini.engine.page.DataPage;
import org.apache.flink.runtime.state.gemini.engine.page.PageAddress;
import org.apache.flink.runtime.state.gemini.engine.page.bmap.AbstractGRoutingValue;
import org.apache.flink.runtime.state.gemini.engine.page.bmap.BinaryKey;
import org.apache.flink.runtime.state.gemini.engine.page.bmap.BinaryValue;
import org.apache.flink.runtime.state.gemini.engine.page.bmap.BinaryValueForSplit;
import org.apache.flink.runtime.state.gemini.engine.page.bmap.ByteBufferDataInputView;
import org.apache.flink.runtime.state.gemini.engine.page.bmap.ByteBufferUtils;
import org.apache.flink.runtime.state.gemini.engine.page.bmap.GBinarySortedMap;
import org.apache.flink.runtime.state.gemini.engine.page.bmap.GComparator;
import org.apache.flink.runtime.state.gemini.engine.rm.GByteBuffer;
import org.apache.flink.util.Preconditions;

public class GSortedRoutingValue
extends AbstractGRoutingValue {
    public static boolean isGSortedRoutingValue(BinaryValue binaryValue) {
        return binaryValue instanceof BinaryValueForSplit && GSortedRoutingValue.getHeaderGRoutingType(binaryValue) == DataPage.DataPageType.KSplitSortedRouting.getCode();
    }

    public static <MK> GBinarySortedMap<MK> getSubGBinarySortedMapWithKey(MK mapKey, int keySlot, BinaryValue binaryValue, TypeSerializer<MK> mkTypeSerializer, GComparator<MK> gComparator) {
        Preconditions.checkState((boolean)(binaryValue instanceof BinaryValueForSplit));
        int subMapId = ByteBufferUtils.toInt(binaryValue.getBb(), binaryValue.getValueOffset() + GSortedRoutingValue.getGRoutingBaseValueOffset(binaryValue) + keySlot * 4);
        GByteBuffer bb = binaryValue.getPageMapping().getGByteBuffer(subMapId, mapKey);
        if (bb == null || bb.capacity() == 0) {
            return GBinarySortedMap.EMPTY_G_BINARY_SORTEDMAP;
        }
        return new GBinarySortedMap<MK>(bb.getByteBuffer(), mkTypeSerializer, gComparator);
    }

    public static PageAddress getSubMapPageAddress(int keySlot, BinaryValue binaryValue) {
        Preconditions.checkState((boolean)(binaryValue instanceof BinaryValueForSplit));
        int subMapId = ByteBufferUtils.toInt(binaryValue.getBb(), binaryValue.getValueOffset() + GSortedRoutingValue.getGRoutingBaseValueOffset(binaryValue) + keySlot * 4);
        return binaryValue.getPageMapping().getGByteBufferAddress(subMapId);
    }

    public static <MK> GBinarySortedMap<MK> getSubGBinarySortedMap(MK mapKey, BinaryValue binaryValue, TypeSerializer<MK> mkTypeSerializer, GComparator<MK> gComparator) {
        Preconditions.checkState((boolean)(binaryValue instanceof BinaryValueForSplit));
        List<BinaryKey> keyList = GSortedRoutingValue.getKeyIndexArray(binaryValue);
        int mapKeySlot = GSortedRoutingValue.findKeySlot(keyList, gComparator, mapKey);
        return GSortedRoutingValue.getSubGBinarySortedMapWithKey(mapKey, mapKeySlot, binaryValue, mkTypeSerializer, gComparator);
    }

    private static <MK> int findKeySlot(List<BinaryKey> keyList, GComparator<MK> gComparator, MK mapKey) {
        int low = 0;
        int high = keyList.size() - 1;
        while (low < high) {
            int mid = low + high >> 1;
            if (gComparator.compare(mapKey, keyList.get(mid)) == 0) {
                return mid;
            }
            if (gComparator.compare(mapKey, keyList.get(mid)) > 0) {
                low = mid + 1;
                continue;
            }
            high = mid;
        }
        return high;
    }

    private static int getKeyPositionBySlot(int slot, BinaryValue binaryValue) {
        return ByteBufferUtils.toInt(binaryValue.getBb(), binaryValue.getValueOffset() + 16 + slot * 4);
    }

    public static List<BinaryKey> getKeyIndexArray(BinaryValue binaryValue) {
        int subMapCount = GSortedRoutingValue.getSubMapCount(binaryValue);
        ArrayList<BinaryKey> keyIndex = new ArrayList<BinaryKey>(subMapCount);
        int lastKeyPosition = binaryValue.getValueOffset() + 16 + subMapCount * 4;
        for (int i = 0; i < subMapCount; ++i) {
            int curKeyPosition = binaryValue.getValueOffset() + 16 + GSortedRoutingValue.getKeyPositionBySlot(i, binaryValue);
            keyIndex.add(new BinaryKey(binaryValue.getBb(), lastKeyPosition, curKeyPosition - lastKeyPosition, 0));
            lastKeyPosition = curKeyPosition;
        }
        return keyIndex;
    }

    public static BinaryKey getKeyIndexBySlot(BinaryValue binaryValue, int slot) {
        int lastKeyPosition;
        if (slot == 0) {
            int subMapCount = GSortedRoutingValue.getSubMapCount(binaryValue);
            lastKeyPosition = binaryValue.getValueOffset() + 16 + subMapCount * 4;
        } else {
            lastKeyPosition = binaryValue.getValueOffset() + 16 + GSortedRoutingValue.getKeyPositionBySlot(slot - 1, binaryValue);
        }
        int curKeyPosition = binaryValue.getValueOffset() + 16 + GSortedRoutingValue.getKeyPositionBySlot(slot, binaryValue);
        return new BinaryKey(binaryValue.getBb(), lastKeyPosition, curKeyPosition - lastKeyPosition, 0);
    }

    public static <MK> MK getKeyIndexBySlot(BinaryValue binaryValue, int slot, TypeSerializer<MK> keyTypeSerializer) {
        try {
            BinaryKey binaryKey = GSortedRoutingValue.getKeyIndexBySlot(binaryValue, slot);
            ByteBufferDataInputView byteBufferDataInputView = new ByteBufferDataInputView(binaryKey.getBb(), binaryKey.getKeyOffset(), binaryKey.getKeyLen());
            return (MK)keyTypeSerializer.deserialize((DataInputView)byteBufferDataInputView);
        }
        catch (IOException e) {
            throw new GeminiRuntimeException("Exception when deserialize BinaryKey", e);
        }
    }

    public static <MK> List<GBinarySortedMap<MK>> getAllSubGBinarySortedMap(BinaryValue binaryValue, TypeSerializer<MK> mkTypeSerializer, GComparator<MK> gComparator) {
        Preconditions.checkState((boolean)(binaryValue instanceof BinaryValueForSplit));
        int subMapCount = GSortedRoutingValue.getSubMapCount(binaryValue);
        ArrayList<GBinarySortedMap<MK>> subMapList = new ArrayList<GBinarySortedMap<MK>>(subMapCount);
        for (int i = 0; i < subMapCount; ++i) {
            int subMapId = ByteBufferUtils.toInt(binaryValue.getBb(), binaryValue.getValueOffset() + GSortedRoutingValue.getGRoutingBaseValueOffset(binaryValue) + i * 4);
            GByteBuffer bb = binaryValue.getPageMapping().getGByteBuffer(subMapId, null);
            if (bb == null || bb.capacity() == 0) {
                subMapList.add(GBinarySortedMap.EMPTY_G_BINARY_SORTEDMAP);
                continue;
            }
            subMapList.add(new GBinarySortedMap<MK>(bb.getByteBuffer(), mkTypeSerializer, gComparator));
        }
        return subMapList;
    }

    public static <MK> GBinarySortedMap<MK> getFirstOrLastSubGBinarySortedMap(BinaryValue binaryValue, TypeSerializer<MK> mkTypeSerializer, GComparator<MK> gComparator, boolean first) {
        Preconditions.checkState((boolean)(binaryValue instanceof BinaryValueForSplit));
        int subMapCount = GSortedRoutingValue.getSubMapCount(binaryValue);
        int keySlot = first ? 0 : subMapCount - 1;
        int subMapId = ByteBufferUtils.toInt(binaryValue.getBb(), binaryValue.getValueOffset() + GSortedRoutingValue.getGRoutingBaseValueOffset(binaryValue) + keySlot * 4);
        GByteBuffer bb = binaryValue.getPageMapping().getGByteBuffer(subMapId, null);
        return new GBinarySortedMap<MK>(bb.getByteBuffer(), mkTypeSerializer, gComparator);
    }
}

