/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.gemini.engine.page.bmap;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.runtime.state.gemini.engine.memstore.GSValue;
import org.apache.flink.runtime.state.gemini.engine.page.DataPage;
import org.apache.flink.runtime.state.gemini.engine.page.DataPageSortedSubPageImpl;
import org.apache.flink.runtime.state.gemini.engine.page.bmap.BinaryKey;
import org.apache.flink.runtime.state.gemini.engine.page.bmap.BinaryValue;
import org.apache.flink.runtime.state.gemini.engine.page.bmap.GBinarySortedMap;
import org.apache.flink.runtime.state.gemini.engine.page.bmap.GBufferAddressMapping;
import org.apache.flink.runtime.state.gemini.engine.page.bmap.GComparator;
import org.apache.flink.runtime.state.gemini.engine.page.bmap.GSortedHeaderImpl;
import org.apache.flink.runtime.state.gemini.engine.page.bmap.SplitHashMapValueHelper;
import org.apache.flink.runtime.state.gemini.engine.rm.Allocator;
import org.apache.flink.runtime.state.gemini.engine.rm.GByteBuffer;

public class SplitSortedMapValueHelper {
    public static <MK, MV> GBinarySortedMap<MK> trySplit(DataPage.DataPageType dataPageType, List<Tuple2<MK, GSValue<MV>>> keyValueList, TypeSerializer<MK> keySerializer, TypeSerializer<MV> valueSerializer, GComparator<MK> gComparator, long version, int logicPageId, Allocator allocator, long compactionCount, GBufferAddressMapping mapping, int mapSplitSubMapSize, int mapSplitMinKeyNum) {
        int totalKeys = keyValueList.size();
        if (totalKeys == 0) {
            return GBinarySortedMap.EMPTY_G_BINARY_SORTEDMAP;
        }
        List<List<Tuple2<MK, GSValue<MV>>>> subMapList = SplitSortedMapValueHelper.splitGSValueMap(keyValueList, gComparator, keySerializer, valueSerializer, mapSplitSubMapSize, mapSplitMinKeyNum);
        if (subMapList.size() == 1) {
            return GBinarySortedMap.of(dataPageType, keyValueList, keySerializer, valueSerializer, gComparator, version, logicPageId, allocator, compactionCount);
        }
        ArrayList<Integer> subMapIdList = new ArrayList<Integer>(subMapList.size());
        ArrayList<Object> keyIndexList = new ArrayList<Object>(subMapList.size());
        int subMapMaxSize = 0;
        for (int i = 0; i < subMapList.size(); ++i) {
            List<Tuple2<MK, GSValue<MV>>> subMap = subMapList.get(i);
            GBinarySortedMap<MK> subGBinarySortedMap = GBinarySortedMap.of(dataPageType, subMap, keySerializer, valueSerializer, gComparator, version, logicPageId, allocator, compactionCount);
            if (subGBinarySortedMap == GBinarySortedMap.EMPTY_G_BINARY_SORTEDMAP) continue;
            int subMapId = mapping.putGByteBufferAddress(new DataPageSortedSubPageImpl(subGBinarySortedMap));
            subMapIdList.add(subMapId);
            keyIndexList.add(subMap.get((int)(subMap.size() - 1)).f0);
            Math.max(subGBinarySortedMap.bytesSize(), subMapMaxSize);
        }
        int splitMapIndexLen = 0;
        GSortedHeaderImpl pageHelper = GSortedHeaderImpl.getPageHelper(splitMapIndexLen);
        GByteBuffer gByteBuffer = SplitHashMapValueHelper.genRoutingBufferForSplitMap(DataPage.DataPageType.KSplitSortedRouting, subMapIdList, keyIndexList, subMapMaxSize, keySerializer, logicPageId, allocator);
        return new GBinarySortedMap<MK>(pageHelper, gByteBuffer.getByteBuffer(), keySerializer, gComparator);
    }

    private static <MK, MV> List<List<Tuple2<MK, GSValue<MV>>>> splitGSValueMap(List<Tuple2<MK, GSValue<MV>>> keyValueList, GComparator<MK> gComparator, TypeSerializer<MK> keySerializer, TypeSerializer<MV> valueSerializer, int mapSplitSubMapSize, int mapSplitMinKeyNum) {
        if (keyValueList.size() <= mapSplitMinKeyNum) {
            return Collections.singletonList(keyValueList);
        }
        int subMapNum = SplitHashMapValueHelper.getSplitNumBySampling(keyValueList, keySerializer, valueSerializer, mapSplitMinKeyNum, mapSplitSubMapSize);
        if (subMapNum == 1) {
            return Collections.singletonList(keyValueList);
        }
        return SplitSortedMapValueHelper.divideKeyValueList(keyValueList, gComparator, subMapNum);
    }

    private static <MK, MV> List<List<Tuple2<MK, GSValue<MV>>>> divideKeyValueList(List<Tuple2<MK, GSValue<MV>>> keyValueList, GComparator<MK> gComparator, int subMapNum) {
        Collections.sort(keyValueList, (o1, o2) -> gComparator.compare(o1.f0, o2.f0));
        ArrayList<List<Tuple2<MK, GSValue<MV>>>> subMapList = new ArrayList<List<Tuple2<MK, GSValue<MV>>>>(subMapNum);
        int subMapKeyNum = keyValueList.size() / subMapNum + (keyValueList.size() % subMapNum == 0 ? 0 : 1);
        int endIndex = 0;
        for (int i = 0; i < subMapNum; ++i) {
            ArrayList<Tuple2<MK, GSValue<MV>>> subMap = new ArrayList<Tuple2<MK, GSValue<MV>>>();
            for (int count = 0; endIndex < keyValueList.size() && (count < subMapKeyNum || endIndex > 0 && gComparator.compare(keyValueList.get((int)endIndex).f0, keyValueList.get((int)(endIndex - 1)).f0) == 0); ++count) {
                subMap.add(keyValueList.get(endIndex++));
            }
            subMapList.add(subMap);
        }
        return subMapList;
    }

    public static List<SortedMap<BinaryKey, BinaryValue>> divideSortedMap(SortedMap<BinaryKey, BinaryValue> sortedMap, int mapSplitSubMapSize) {
        ArrayList<SortedMap<BinaryKey, BinaryValue>> result = new ArrayList<SortedMap<BinaryKey, BinaryValue>>();
        result.add(new TreeMap(sortedMap.comparator()));
        int sizeSum = 0;
        BinaryKey lastKey = sortedMap.firstKey();
        for (Map.Entry<BinaryKey, BinaryValue> entry : sortedMap.entrySet()) {
            if (sizeSum >= mapSplitSubMapSize && sortedMap.comparator().compare(entry.getKey(), lastKey) != 0) {
                sizeSum = 0;
                result.add(new TreeMap(sortedMap.comparator()));
            }
            ((SortedMap)result.get(result.size() - 1)).put(entry.getKey(), entry.getValue());
            sizeSum += entry.getValue().getValueLen();
            lastKey = entry.getKey();
        }
        return result;
    }
}

