/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.gemini.engine.page.compress;

import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.state.gemini.engine.page.compress.CompressorCodec;
import org.apache.flink.runtime.state.gemini.engine.page.compress.LZ4CompressorCodec;
import org.apache.flink.runtime.state.gemini.engine.page.compress.SnappyCompressorCodec;

public enum GCompressAlgorithm {
    None(1){

        @Override
        public CompressorCodec getCompressorCodec() {
            return null;
        }

        @Override
        public boolean enableCompress() {
            return false;
        }

        @Override
        public void setConfiguration(Configuration configuration) {
        }
    }
    ,
    Lz4(2){
        private Configuration configuration;
        private ThreadLocal<CompressorCodec> compressorCodecThreadLocal;

        @Override
        public CompressorCodec getCompressorCodec() {
            return this.compressorCodecThreadLocal.get();
        }

        @Override
        public boolean enableCompress() {
            return true;
        }

        @Override
        public void setConfiguration(Configuration configuration) {
            this.configuration = configuration;
            this.compressorCodecThreadLocal = ThreadLocal.withInitial(() -> new LZ4CompressorCodec(this.configuration));
        }
    }
    ,
    Snappy(3){
        private ThreadLocal<CompressorCodec> compressorCodecThreadLocal = ThreadLocal.withInitial(() -> new SnappyCompressorCodec());

        @Override
        public CompressorCodec getCompressorCodec() {
            return this.compressorCodecThreadLocal.get();
        }

        @Override
        public boolean enableCompress() {
            return true;
        }

        @Override
        public void setConfiguration(Configuration configuration) {
        }
    };

    private final byte code;

    private GCompressAlgorithm(byte c) {
        this.code = c;
    }

    public byte getCode() {
        return this.code;
    }

    public static GCompressAlgorithm valueOf(byte gvalueType) {
        switch (gvalueType) {
            case 1: {
                return None;
            }
            case 2: {
                return Lz4;
            }
            case 3: {
                return Snappy;
            }
        }
        return None;
    }

    public abstract CompressorCodec getCompressorCodec();

    public abstract boolean enableCompress();

    public abstract void setConfiguration(Configuration var1);

    public static GCompressAlgorithm getCompressAlgorithm(String algorithm, Configuration configuration) {
        GCompressAlgorithm compressAlgorithm = GCompressAlgorithm.valueOf(algorithm);
        if (compressAlgorithm == Snappy) {
            throw new UnsupportedOperationException("Snappy is not supported currently");
        }
        compressAlgorithm.setConfiguration(configuration);
        return compressAlgorithm;
    }
}

