/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.gemini.engine.page.compress;

import java.nio.ByteBuffer;
import org.apache.flink.runtime.state.gemini.engine.page.DataPage;
import org.apache.flink.runtime.state.gemini.engine.page.bmap.ByteBufferUtils;
import org.apache.flink.runtime.state.gemini.engine.page.compress.GCompressAlgorithm;
import org.apache.flink.util.Preconditions;

public class GCompressHeaderHelper {
    private static final long serialVersionUID = 1L;
    public static final int LENGTH = 16;
    public static final short CURRENT_VERSION = 1;
    public static final short MAGIC_NUMBER = 4726;
    private static final int COMPRESSED_DATAPAGE_TYPE_INDEX = 0;
    private static final int VERSION_START_INDEX = 1;
    private static final int MAGIC_NUMBER_START_INDEX = 3;
    private static final int ALGORITHM_CODE_START_INDEX = 5;
    private static final int DISK_LENGTH_START_INDEX = 6;
    private static final byte COMPRESSED_DATAPAGE_TYPE = DataPage.DataPageType.COMPRESS_HEADER.getCode();

    public static void writeCompressedDataPageType(ByteBuffer byteBuffe) {
        ByteBufferUtils.putByte(byteBuffe, 0, COMPRESSED_DATAPAGE_TYPE);
    }

    public static void writeCompressVersion(ByteBuffer byteBuffer, short version) {
        ByteBufferUtils.putShort(byteBuffer, 1, version);
    }

    public static void writeMagicNumber(ByteBuffer byteBuffer, short magic) {
        ByteBufferUtils.putShort(byteBuffer, 3, magic);
    }

    public static void writeAlgorithmCode(ByteBuffer byteBuffer, byte code) {
        ByteBufferUtils.putByte(byteBuffer, 5, code);
    }

    public static void writeDiskLength(ByteBuffer byteBuffer, int diskLength) {
        ByteBufferUtils.putInt(byteBuffer, 6, diskLength);
    }

    public static void checkMagicNumber(byte[] input) {
        ByteBuffer bb = ByteBuffer.wrap(input);
        GCompressHeaderHelper.checkMagicNumber(bb);
    }

    public static void checkMagicNumber(ByteBuffer buffer) {
        short magic = buffer.getShort(3);
        Preconditions.checkState((magic == 4726 ? 1 : 0) != 0, (Object)"Wrong magic number");
    }

    public static GCompressAlgorithm readCompressAlgorithm(byte[] input) {
        return GCompressHeaderHelper.readCompressAlgorithm(ByteBuffer.wrap(input));
    }

    public static GCompressAlgorithm readCompressAlgorithm(ByteBuffer buffer) {
        byte code = buffer.get(5);
        return GCompressAlgorithm.valueOf(code);
    }

    public static int readDiskLength(byte[] input) {
        return GCompressHeaderHelper.readDiskLength(ByteBuffer.wrap(input));
    }

    public static int readDiskLength(ByteBuffer buffer) {
        return buffer.getInt(6);
    }

    public static short readCompressVersion(byte[] input) {
        return GCompressHeaderHelper.readCompressVersion(ByteBuffer.wrap(input));
    }

    public static short readCompressVersion(ByteBuffer buffer) {
        return buffer.getShort(1);
    }

    public static boolean isPageCompressed(byte[] input) {
        return GCompressHeaderHelper.isPageCompressed(ByteBuffer.wrap(input));
    }

    public static boolean isPageCompressed(ByteBuffer byteBuffer) {
        return COMPRESSED_DATAPAGE_TYPE == byteBuffer.get(0);
    }
}

