/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.gemini.engine.rm;

import org.apache.flink.runtime.state.gemini.engine.exceptions.GeminiRuntimeException;
import org.apache.flink.runtime.state.gemini.engine.rm.AbstractReferenceCountable;
import org.apache.flink.runtime.state.gemini.engine.rm.Allocator;
import org.apache.flink.runtime.state.gemini.engine.rm.FinalizableCleaner;
import org.apache.flink.runtime.state.gemini.engine.rm.GByteBuffer;

public abstract class AbstractGByteBufferReference
extends AbstractReferenceCountable
implements GByteBuffer {
    private volatile long seqID;
    protected final Allocator allocator;

    public AbstractGByteBufferReference(Allocator allocator) {
        this.allocator = allocator;
    }

    @Override
    public void release() throws GeminiRuntimeException {
        int count = this.decrementAndGetRefCnt();
        if (count == 0) {
            if (this.allocator != null) {
                this.allocator.release(this);
            } else {
                this.doFree();
            }
        }
    }

    @Override
    public void close() {
        this.release();
    }

    @Override
    public boolean canSyncFree() {
        return false;
    }

    @Override
    public void setSeqID(long seqID) {
        this.seqID = seqID;
    }

    @Override
    public long getSeqID() {
        return this.seqID;
    }

    @Override
    public void setWaitSeqId() {
    }

    public static class EmptyCleaner
    implements FinalizableCleaner {
        @Override
        public void clean() {
        }

        @Override
        public boolean cleaned() {
            return true;
        }

        @Override
        public void cleanedByLeakDetector() {
        }
    }
}

