/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.gemini.engine.rm;

import org.apache.flink.runtime.state.gemini.engine.page.bmap.UnsafeHelp;
import org.apache.flink.runtime.state.gemini.engine.rm.ReferenceCountable;
import sun.misc.Unsafe;

public abstract class AbstractReferenceCountable
implements ReferenceCountable {
    private static final Unsafe unsafe;
    private static final long valueOffset;
    private volatile int referenceCount = 0;

    @Override
    public void retain() {
        unsafe.getAndAddInt(this, valueOffset, 1);
    }

    @Override
    public void release() {
        unsafe.getAndAddInt(this, valueOffset, -1);
    }

    @Override
    public int refCnt() {
        return this.referenceCount;
    }

    protected int decrementAndGetRefCnt() {
        return unsafe.getAndAddInt(this, valueOffset, -1) - 1;
    }

    static {
        try {
            unsafe = UnsafeHelp.getUnsafe();
            valueOffset = unsafe.objectFieldOffset(AbstractReferenceCountable.class.getDeclaredField("referenceCount"));
        }
        catch (Exception ex) {
            throw new Error(ex);
        }
    }
}

