/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.gemini.engine.rm;

import java.nio.ByteBuffer;
import org.apache.flink.runtime.state.gemini.engine.exceptions.GeminiRuntimeException;
import org.apache.flink.runtime.state.gemini.engine.rm.AbstractGByteBufferReference;
import org.apache.flink.runtime.state.gemini.engine.rm.Allocator;
import org.apache.flink.runtime.state.gemini.engine.rm.Chunk;
import org.apache.flink.runtime.state.gemini.engine.rm.FinalizableCleaner;

public class GPooledByteBuffer
extends AbstractGByteBufferReference {
    private final ByteBuffer byteBuffer;
    private volatile Chunk chunk;
    private final int offset;
    private final int len;
    private GPooledByteBufferFreeWrapper freeWrapper = null;

    public GPooledByteBuffer(Chunk chunk, int offset, int len, Allocator allocator) {
        super(allocator);
        this.chunk = chunk;
        ByteBuffer duplicateByteBuffer = chunk.getMemory().duplicate();
        duplicateByteBuffer.limit(offset + len);
        duplicateByteBuffer.position(offset);
        this.byteBuffer = duplicateByteBuffer.slice();
        this.offset = offset;
        this.len = len;
        this.retain();
    }

    @Override
    public int capacity() {
        return this.byteBuffer.capacity();
    }

    @Override
    public ByteBuffer getByteBuffer() {
        return this.byteBuffer;
    }

    @Override
    public void doFree() throws GeminiRuntimeException {
        this.getCleaner().clean();
    }

    @Override
    public boolean isFreed() {
        return this.getCleaner().cleaned();
    }

    @Override
    public FinalizableCleaner getCleaner() {
        if (this.freeWrapper == null) {
            this.freeWrapper = new GPooledByteBufferFreeWrapper(this.chunk, this.offset, this.len, this.allocator);
        }
        return this.freeWrapper;
    }

    @Override
    public boolean isPooled() {
        return true;
    }

    static class GPooledByteBufferFreeWrapper
    implements FinalizableCleaner {
        private volatile Chunk chunk;
        private Allocator allocator;
        private final int offset;
        private final int len;
        private volatile boolean freed;

        public GPooledByteBufferFreeWrapper(Chunk chunk, int offset, int len, Allocator allocator) {
            this.chunk = chunk;
            this.offset = offset;
            this.len = len;
            this.allocator = allocator;
            this.freed = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void clean() {
            if (this.chunk == null) {
                return;
            }
            this.freed = true;
            GPooledByteBufferFreeWrapper gPooledByteBufferFreeWrapper = this;
            synchronized (gPooledByteBufferFreeWrapper) {
                if (this.chunk != null) {
                    this.chunk.free(this.offset, this.len);
                    this.chunk = null;
                    this.allocator.statSize(-this.len);
                }
            }
        }

        @Override
        public boolean cleaned() {
            return this.freed;
        }

        @Override
        public void cleanedByLeakDetector() {
        }
    }
}

