/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.gemini.engine.rm;

import java.nio.ByteBuffer;
import java.util.LinkedList;
import org.apache.flink.runtime.state.gemini.engine.exceptions.GeminiRuntimeException;
import org.apache.flink.runtime.state.gemini.engine.page.bmap.UnsafeHelp;
import org.apache.flink.runtime.state.gemini.engine.rm.AbstractGByteBufferReference;
import org.apache.flink.runtime.state.gemini.engine.rm.Allocator;
import org.apache.flink.runtime.state.gemini.engine.rm.FinalizableCleaner;
import org.apache.flink.shaded.guava18.com.google.common.collect.Lists;
import org.apache.flink.shaded.netty4.io.netty.buffer.ByteBuf;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sun.misc.Unsafe;

public class GPooledNettyByteBuffer
extends AbstractGByteBufferReference {
    private static final Logger LOG = LoggerFactory.getLogger(GPooledNettyByteBuffer.class);
    private static final int STACK_LIMIT = 15;
    private static final short ALLOCATED_THREAD_MASK = -4;
    private static final short SYNC_FREE_MASK = 1;
    private static final short RETAINED_BY_OTHER_THREAD_MASK = 2;
    private GPooledNettyByteBufferContext context;
    private short flag;

    public GPooledNettyByteBuffer(ByteBuf byteBuf, int len, Allocator allocator) {
        super(allocator);
        this.context = LOG.isDebugEnabled() ? new GPooledNettyByteBufferContextExtended(byteBuf, len, allocator) : new GPooledNettyByteBufferContext(byteBuf, len, allocator);
        this.setAllocatedThread();
        this.retain();
    }

    @Override
    public int capacity() {
        return this.context.len;
    }

    @Override
    public ByteBuffer getByteBuffer() {
        return this.context.byteBuffer;
    }

    @Override
    public void retain() {
        if (!this.sameThreadWithAllocated()) {
            this.setRetainedByOtherThread();
        }
        if (LOG.isDebugEnabled()) {
            this.context.recordRetainStack(Thread.currentThread().getStackTrace());
        }
        super.retain();
    }

    @Override
    public void release() {
        if (!this.sameThreadWithAllocated()) {
            this.setRetainedByOtherThread();
        }
        if (LOG.isDebugEnabled()) {
            this.context.recordReleaseStack(Thread.currentThread().getStackTrace());
        }
        super.release();
    }

    @Override
    public void doFree() throws GeminiRuntimeException {
        this.context.clean();
    }

    @Override
    public boolean isFreed() {
        return this.context.cleaned();
    }

    @Override
    public GPooledNettyByteBufferContext getCleaner() {
        return this.context;
    }

    short threadShortID(Thread thread) {
        return (short)(thread.getId() << 2);
    }

    private void setAllocatedThread() {
        short id = this.threadShortID(Thread.currentThread());
        short fg = this.flag;
        this.flag = (short)(fg & 3 | id);
    }

    boolean sameThreadWithAllocated() {
        return this.threadShortID(Thread.currentThread()) == this.getAllocatedThread();
    }

    private short getAllocatedThread() {
        return (short)(this.flag & 0xFFFFFFFC);
    }

    void setSyncFree() {
        short fg = this.flag;
        this.flag = (short)(fg | 1);
    }

    @Override
    public boolean canSyncFree() {
        return (this.flag & 1) != 0;
    }

    private void setRetainedByOtherThread() {
        short fg = this.flag;
        this.flag = (short)(fg | 2);
    }

    boolean getRetainedByOtherThread() {
        return (this.flag & 2) != 0;
    }

    @Override
    public boolean isPooled() {
        return true;
    }

    @Override
    public void setWaitSeqId() {
        this.setRetainedByOtherThread();
    }

    static class GPooledNettyByteBufferContextExtended
    extends GPooledNettyByteBufferContext {
        private LinkedList<StackTraceElement[]> retainStack = Lists.newLinkedList();
        private LinkedList<StackTraceElement[]> releaseStack = Lists.newLinkedList();

        GPooledNettyByteBufferContextExtended(ByteBuf byteBuf, int len, Allocator allocator) {
            super(byteBuf, len, allocator);
        }

        @Override
        void recordRetainStack(StackTraceElement[] stack) {
            if (this.retainStack.size() >= 15) {
                this.retainStack.removeFirst();
            }
            this.retainStack.addLast(stack);
        }

        @Override
        void recordReleaseStack(StackTraceElement[] stack) {
            if (this.releaseStack.size() >= 15) {
                this.releaseStack.removeFirst();
            }
            this.releaseStack.addLast(stack);
        }

        @Override
        public void cleanedByLeakDetector() {
            StackTraceElement s;
            int j;
            LOG.debug("Printing retain stack trace:");
            int i = 0;
            for (StackTraceElement[] stack : this.retainStack) {
                LOG.debug("Printing retain stack trace {}:", (Object)i);
                for (j = 1; j < stack.length; ++j) {
                    s = stack[j];
                    LOG.debug("\tat " + s.getClassName() + "." + s.getMethodName() + "(" + s.getFileName() + ":" + s.getLineNumber() + ")");
                }
                ++i;
            }
            LOG.debug("Printing release stack trace:");
            i = 0;
            for (StackTraceElement[] stack : this.releaseStack) {
                LOG.debug("Printing release stack trace {}:", (Object)i);
                for (j = 1; j < stack.length; ++j) {
                    s = stack[j];
                    LOG.debug("\tat " + s.getClassName() + "." + s.getMethodName() + "(" + s.getFileName() + ":" + s.getLineNumber() + ")");
                }
                ++i;
            }
            LOG.debug("---------------------------------");
        }
    }

    static class GPooledNettyByteBufferContext
    implements FinalizableCleaner {
        private static final Unsafe unsafe;
        private static final long freedOffset;
        private volatile ByteBuf byteBuf;
        private ByteBuffer byteBuffer;
        private Allocator allocator;
        private final int len;
        private volatile boolean freed;

        GPooledNettyByteBufferContext(ByteBuf byteBuf, int len, Allocator allocator) {
            this.byteBuf = byteBuf;
            this.byteBuffer = byteBuf.nioBuffer(0, len);
            this.len = len;
            this.allocator = allocator;
            this.freed = false;
        }

        @Override
        public void clean() {
            boolean updated = unsafe.compareAndSwapInt(this, freedOffset, 0, 1);
            if (!updated) {
                return;
            }
            if (this.byteBuf != null) {
                if (!this.byteBuf.release()) {
                    LOG.error("FATAL BUG!!! LEAK! pls contact to dev. byteBuf ref =" + this.byteBuf.refCnt());
                }
                this.byteBuf = null;
                this.allocator.statSize(-this.len);
            }
        }

        @Override
        public boolean cleaned() {
            return this.freed;
        }

        void recordRetainStack(StackTraceElement[] stack) {
        }

        void recordReleaseStack(StackTraceElement[] stack) {
        }

        @Override
        public void cleanedByLeakDetector() {
        }

        static {
            try {
                unsafe = UnsafeHelp.getUnsafe();
                freedOffset = unsafe.objectFieldOffset(GPooledNettyByteBufferContext.class.getDeclaredField("freed"));
            }
            catch (Exception ex) {
                throw new Error(ex);
            }
        }
    }
}

