/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.gemini.engine.rm;

import java.nio.ByteBuffer;
import org.apache.flink.runtime.state.gemini.engine.exceptions.GeminiRuntimeException;
import org.apache.flink.runtime.state.gemini.engine.rm.AbstractGByteBufferReference;
import org.apache.flink.runtime.state.gemini.engine.rm.FinalizableCleaner;
import org.apache.flink.runtime.state.gemini.engine.rm.GByteBuffer;

public class GSharedUnreferencedByteBuffer
implements GByteBuffer {
    private final GByteBuffer buddy;
    private final int len;

    public GSharedUnreferencedByteBuffer(GByteBuffer gByteBuffer) {
        this.buddy = gByteBuffer;
        this.len = gByteBuffer.capacity();
    }

    @Override
    public int capacity() {
        return this.len;
    }

    @Override
    public ByteBuffer getByteBuffer() {
        if (this.isFreed()) {
            throw new GeminiRuntimeException("GSharedUnreferencedByteBuffer is released.");
        }
        return this.buddy.getByteBuffer();
    }

    @Override
    public void retain() {
    }

    @Override
    public void release() {
    }

    @Override
    public int refCnt() {
        return 0;
    }

    @Override
    public void doFree() throws GeminiRuntimeException {
    }

    @Override
    public boolean isFreed() {
        return this.buddy == null || this.buddy.isFreed();
    }

    @Override
    public FinalizableCleaner getCleaner() {
        return new AbstractGByteBufferReference.EmptyCleaner();
    }

    @Override
    public boolean isPooled() {
        return false;
    }

    @Override
    public void setSeqID(long seqID) {
    }

    @Override
    public long getSeqID() {
        return 0L;
    }

    @Override
    public void close() {
    }

    @Override
    public boolean canSyncFree() {
        return true;
    }

    @Override
    public void setWaitSeqId() {
    }
}

