/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.gemini.engine.rm;

import java.lang.ref.Reference;
import java.util.Map;
import org.apache.flink.runtime.state.gemini.engine.exceptions.GeminiRuntimeException;
import org.apache.flink.runtime.state.gemini.engine.rm.Finalizable;
import org.apache.flink.runtime.state.gemini.engine.rm.FinalizableCleaner;
import org.apache.flink.runtime.state.gemini.engine.rm.LeakDetector;
import org.apache.flink.shaded.guava18.com.google.common.base.FinalizableReferenceQueue;
import org.apache.flink.shaded.guava18.com.google.common.base.FinalizableWeakReference;
import org.apache.flink.shaded.guava18.com.google.common.collect.Maps;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LeakDetectorImpl
implements LeakDetector {
    private static final Logger LOG = LoggerFactory.getLogger(LeakDetectorImpl.class);
    private LeakDetector.LeakReportLevel reportLevel = LeakDetector.LeakReportLevel.DEBUG;
    private volatile boolean leakDetected = false;
    private final FinalizableReferenceQueue frq = new FinalizableReferenceQueue();
    private final Map<Reference<?>, FinalizableCleaner> references = Maps.newConcurrentMap();

    @Override
    public void register(Finalizable finalizable) {
        FinalizableWeakReference<Finalizable> reference = new FinalizableWeakReference<Finalizable>(finalizable, this.frq){

            public void finalizeReferent() {
                FinalizableCleaner cleaner = (FinalizableCleaner)LeakDetectorImpl.this.references.remove((Object)this);
                if (!cleaner.cleaned()) {
                    LeakDetectorImpl.this.leakDetected = true;
                    LeakDetectorImpl.this.reportLeak(cleaner);
                    LeakDetectorImpl.this.free(cleaner);
                }
            }
        };
        FinalizableCleaner freer = finalizable.getCleaner();
        this.references.put((Reference<?>)reference, freer);
    }

    public void setReportLevel(LeakDetector.LeakReportLevel level) {
        this.reportLevel = level;
    }

    void free(FinalizableCleaner cleaner) {
        cleaner.clean();
        cleaner.cleanedByLeakDetector();
    }

    @Override
    public void close() {
        this.frq.close();
        for (FinalizableCleaner cleaner : this.references.values()) {
            if (cleaner.cleaned()) continue;
            this.leakDetected = true;
            this.reportLeak(cleaner);
            this.free(cleaner);
        }
        if (this.leakDetected && this.reportLevel == LeakDetector.LeakReportLevel.ERROR) {
            throw new GeminiRuntimeException("There is at least one leak detected.");
        }
    }

    @Override
    public boolean leakDetected() {
        return this.leakDetected;
    }

    private void reportLeak(FinalizableCleaner cleaner) {
        if (this.reportLevel == LeakDetector.LeakReportLevel.ERROR) {
            LOG.error("There is a leak and {} help to release {}", (Object)this, (Object)cleaner);
        } else if (this.reportLevel == LeakDetector.LeakReportLevel.DEBUG) {
            LOG.debug("There is a leak and {} help to release {}", (Object)this, (Object)cleaner);
        }
    }
}

