/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.gemini.engine.rm;

import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Nonnull;
import org.apache.flink.runtime.state.gemini.engine.dbms.GContext;
import org.apache.flink.runtime.state.gemini.engine.exceptions.GeminiException;
import org.apache.flink.runtime.state.gemini.engine.rm.Allocator;
import org.apache.flink.runtime.state.gemini.engine.rm.GByteBuffer;
import org.apache.flink.runtime.state.gemini.engine.rm.GPooledNettyByteBuffer;
import org.apache.flink.runtime.state.gemini.engine.rm.GarbageReleaseManager;
import org.apache.flink.runtime.state.gemini.engine.rm.LeakDetector;
import org.apache.flink.shaded.guava18.com.google.common.base.MoreObjects;
import org.apache.flink.shaded.netty4.io.netty.buffer.ByteBuf;
import org.apache.flink.shaded.netty4.io.netty.buffer.PooledByteBufAllocator;
import org.apache.flink.util.Preconditions;

public class PoolAllocatorNettyImpl
implements Allocator {
    private final PooledByteBufAllocator pooledByteBufAllocator;
    private final AtomicLong currentSize = new AtomicLong(0L);
    private final GarbageReleaseManager<GByteBuffer> garbageReleaseManager;
    private final LeakDetector leakDetector;

    public PoolAllocatorNettyImpl(GContext gContext, @Nonnull GarbageReleaseManager<GByteBuffer> garbageReleaseManager, LeakDetector leakDetector) {
        int pageSize = 8192;
        int maxOrder = 11;
        int normalCacheSize = 16;
        int nDirectArena = Math.min(gContext.getGConfiguration().getAllocatorDirectArena(), (int)(gContext.getMemoryInfo().getTotalOffheapSize() / (long)(pageSize << maxOrder) / 3L / 2L));
        this.pooledByteBufAllocator = new PooledByteBufAllocator(true, 0, nDirectArena, pageSize, maxOrder, 0, 0, normalCacheSize);
        this.garbageReleaseManager = garbageReleaseManager;
        this.leakDetector = leakDetector;
    }

    @Override
    public GByteBuffer allocate(int len) throws GeminiException {
        ByteBuf byteBuf = this.pooledByteBufAllocator.buffer(len);
        this.currentSize.addAndGet(len);
        GPooledNettyByteBuffer allocated = new GPooledNettyByteBuffer(byteBuf, len, this);
        if (this.leakDetector != null) {
            this.leakDetector.register(allocated);
        }
        return allocated;
    }

    @Override
    public void close() {
    }

    @Override
    public void release(GByteBuffer gByteBuffer) {
        Preconditions.checkArgument((boolean)(gByteBuffer instanceof GPooledNettyByteBuffer));
        GPooledNettyByteBuffer pooledBuffer = (GPooledNettyByteBuffer)gByteBuffer;
        if (!pooledBuffer.getRetainedByOtherThread() && pooledBuffer.sameThreadWithAllocated()) {
            ((GPooledNettyByteBuffer)gByteBuffer).setSyncFree();
        }
        this.garbageReleaseManager.enqueue(gByteBuffer);
    }

    @Override
    public void statSize(int len) {
        this.currentSize.addAndGet(len);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("pooledByteBufAllocator", (Object)this.pooledByteBufAllocator).add("currentSize", (Object)this.currentSize).toString();
    }
}

