/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.gemini.engine.snapshot;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.core.fs.Path;
import org.apache.flink.runtime.state.SnapshotDirectory;
import org.apache.flink.runtime.state.gemini.engine.dbms.GContext;
import org.apache.flink.runtime.state.gemini.engine.filecache.PageBatchFlusher;
import org.apache.flink.runtime.state.gemini.engine.fs.FileManager;
import org.apache.flink.runtime.state.gemini.engine.snapshot.BackendSnapshotMeta;
import org.apache.flink.runtime.state.gemini.engine.snapshot.DBSnapshotMeta;
import org.apache.flink.runtime.state.gemini.engine.snapshot.DBSnapshotResult;
import org.apache.flink.runtime.state.gemini.engine.snapshot.NoSnapshotCompaction;
import org.apache.flink.runtime.state.gemini.engine.snapshot.RegionSnapshot;
import org.apache.flink.runtime.state.gemini.engine.snapshot.SnapshotCompaction;
import org.apache.flink.runtime.state.gemini.engine.snapshot.SnapshotCompactionImpl;
import org.apache.flink.runtime.state.gemini.engine.snapshot.SnapshotCompletableFuture;
import org.apache.flink.runtime.state.gemini.engine.snapshot.SnapshotFileSyncStage;
import org.apache.flink.runtime.state.gemini.engine.snapshot.SnapshotManager;
import org.apache.flink.runtime.state.gemini.engine.snapshot.SnapshotManagerImpl;
import org.apache.flink.runtime.state.gemini.engine.snapshot.SnapshotMetaFile;
import org.apache.flink.runtime.state.gemini.engine.snapshot.SnapshotOperation;
import org.apache.flink.runtime.state.gemini.engine.snapshot.SnapshotStat;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DFSSnapshotOperation
extends SnapshotOperation {
    private static final Logger LOG = LoggerFactory.getLogger(DFSSnapshotOperation.class);
    private final FileManager dfsFileManager;
    private SnapshotManager.PendingSnapshot pendingSnapshot;

    public DFSSnapshotOperation(GContext gContext, SnapshotManager snapshotManager, FileManager dfsFileManager) {
        super(gContext, snapshotManager);
        this.dfsFileManager = (FileManager)Preconditions.checkNotNull((Object)dfsFileManager);
    }

    @Override
    public SnapshotManager.PendingSnapshot createPendingSnapshot(BackendSnapshotMeta backendSnapshotMeta, long accessNumber) {
        long checkpointId = backendSnapshotMeta.getCheckpointId();
        SnapshotCompletableFuture snapshotCompletableFuture = new SnapshotCompletableFuture(this.snapshotManager.getSnapshotExecutor());
        Path dfsSnapshotBasePath = this.dfsFileManager.getBasePath();
        Path dfsMetaPath = ((SnapshotManagerImpl)this.snapshotManager).getDFSSnapshotMetaPath(dfsSnapshotBasePath, checkpointId);
        PageBatchFlusher dfsPageBatchFlusher = new PageBatchFlusher(this.gContext.getGConfiguration().getSnapshotFlushBatchNumPage(), this.gContext.getGConfiguration().getSnapshotFlushBatchDataSize(), this.isForceFlushPage(), this.gContext.getSupervisor().getFileCache(), this.gContext.getSupervisor().getSnapshotExecutorGroup());
        SnapshotManager.PendingSnapshot pendingSnapshot = new SnapshotManager.PendingSnapshot(checkpointId, backendSnapshotMeta.getTimestamp(), snapshotCompletableFuture, dfsSnapshotBasePath, dfsMetaPath, null, null, accessNumber, this, dfsPageBatchFlusher);
        SnapshotCompaction snapshotCompaction = this.gContext.getGConfiguration().isSnapshotCompactionEnabled() ? new SnapshotCompactionImpl(this.gContext, pendingSnapshot) : new NoSnapshotCompaction();
        snapshotCompletableFuture.addSnapshotStage(snapshotCompaction);
        SnapshotFileSyncStage fileSyncStage = new SnapshotFileSyncStage(snapshotCompletableFuture, this.gContext.getSupervisor().getFileCache());
        snapshotCompletableFuture.addSnapshotStage(fileSyncStage);
        snapshotCompletableFuture.setPendingSnapshot(pendingSnapshot);
        pendingSnapshot.setSnapshotCompaction(snapshotCompaction);
        this.pendingSnapshot = pendingSnapshot;
        return pendingSnapshot;
    }

    @Override
    public SnapshotManager.PendingSnapshot getPendingSnapshot() {
        return this.pendingSnapshot;
    }

    @Override
    public DBSnapshotResult getSnapshotResult() throws Exception {
        SnapshotMetaFile.Writer writer = null;
        try {
            writer = SnapshotMetaFile.getWriter(this.pendingSnapshot.getSnapshotMetaPath());
            RegionSnapshot regionSnapshot = new RegionSnapshot(this.dfsFileManager, writer, false);
            HashMap<Integer, Map<Integer, Tuple2<Integer, Long>>> fileMapping = new HashMap<Integer, Map<Integer, Tuple2<Integer, Long>>>();
            long[] regionOffsets = this.writeRegionMetaAndPageIndex(this.pendingSnapshot.getGRegionSnapshotMeta(), Collections.singletonList(regionSnapshot), Collections.singletonList(fileMapping)).iterator().next();
            this.pendingSnapshot.setFileMapping(fileMapping);
            Tuple2<Long, Long> fileMappingOffsets = this.writeDfsAndLocalFileMapping(this.pendingSnapshot, writer, null, this.dfsFileManager);
            long snapshotMetaSize = writer.getPos();
            SnapshotStat snapshotStat = this.pendingSnapshot.getSnapshotStat();
            snapshotStat.addAndGetTotalFiles(fileMapping.size());
            snapshotStat.setMetaFileSize(snapshotMetaSize);
            DBSnapshotMeta dbSnapshotMeta = new DBSnapshotMeta(this.pendingSnapshot.getCheckpointId(), this.gContext.getStartRegionId(), this.gContext.getEndRegionId(), regionOffsets, (Long)fileMappingOffsets.f0, (Long)fileMappingOffsets.f1, snapshotMetaSize, snapshotStat.addAndGetTotalSize(0L), snapshotStat.addAndGetIncrementalSize(0L), writer.getFilePath().toUri().toString(), this.snapshotManager.getNameSpace());
            writer.close();
            return new DBSnapshotResult(SnapshotDirectory.permanent(this.pendingSnapshot.getSnapshotBasePath()), dbSnapshotMeta);
        }
        catch (Exception e) {
            LOG.error("Failed to snapshot meta for checkpoint " + this.pendingSnapshot.getCheckpointId(), (Throwable)e);
            this.closeAndDeleteWriterQuietly(writer);
            throw e;
        }
    }
}

