/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.gemini.engine.snapshot;

import java.io.File;
import java.nio.file.Files;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.core.fs.Path;
import org.apache.flink.core.fs.local.LocalFileSystem;
import org.apache.flink.runtime.state.SnapshotDirectory;
import org.apache.flink.runtime.state.gemini.engine.dbms.GContext;
import org.apache.flink.runtime.state.gemini.engine.exceptions.GeminiRuntimeException;
import org.apache.flink.runtime.state.gemini.engine.filecache.PageBatchFlusher;
import org.apache.flink.runtime.state.gemini.engine.fs.FileManager;
import org.apache.flink.runtime.state.gemini.engine.snapshot.BackendSnapshotMeta;
import org.apache.flink.runtime.state.gemini.engine.snapshot.DBSnapshotMeta;
import org.apache.flink.runtime.state.gemini.engine.snapshot.DBSnapshotResult;
import org.apache.flink.runtime.state.gemini.engine.snapshot.NoSnapshotCompaction;
import org.apache.flink.runtime.state.gemini.engine.snapshot.RegionSnapshot;
import org.apache.flink.runtime.state.gemini.engine.snapshot.SnapshotCompaction;
import org.apache.flink.runtime.state.gemini.engine.snapshot.SnapshotCompactionImpl;
import org.apache.flink.runtime.state.gemini.engine.snapshot.SnapshotCompletableFuture;
import org.apache.flink.runtime.state.gemini.engine.snapshot.SnapshotFileSyncStage;
import org.apache.flink.runtime.state.gemini.engine.snapshot.SnapshotManager;
import org.apache.flink.runtime.state.gemini.engine.snapshot.SnapshotManagerImpl;
import org.apache.flink.runtime.state.gemini.engine.snapshot.SnapshotMetaFile;
import org.apache.flink.runtime.state.gemini.engine.snapshot.SnapshotOperation;
import org.apache.flink.runtime.state.gemini.engine.snapshot.SnapshotStat;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalAndDFSSnapshotOperation
extends SnapshotOperation {
    private static final Logger LOG = LoggerFactory.getLogger(LocalAndDFSSnapshotOperation.class);
    private final FileManager dfsFileManager;
    private final FileManager localFileManager;
    private SnapshotManager.PendingSnapshot pendingSnapshot;

    public LocalAndDFSSnapshotOperation(GContext gContext, SnapshotManager snapshotManager, FileManager dfsFileManager, FileManager localFileManager) {
        super(gContext, snapshotManager);
        this.dfsFileManager = (FileManager)Preconditions.checkNotNull((Object)dfsFileManager);
        this.localFileManager = (FileManager)Preconditions.checkNotNull((Object)localFileManager);
    }

    @Override
    public SnapshotManager.PendingSnapshot createPendingSnapshot(BackendSnapshotMeta backendSnapshotMeta, long accessNumber) {
        long checkpointId = backendSnapshotMeta.getCheckpointId();
        SnapshotCompletableFuture snapshotCompletableFuture = new SnapshotCompletableFuture(this.snapshotManager.getSnapshotExecutor());
        Path dfsSnapshotBasePath = this.dfsFileManager.getBasePath();
        Path dfsMetaPath = ((SnapshotManagerImpl)this.snapshotManager).getDFSSnapshotMetaPath(dfsSnapshotBasePath, checkpointId);
        Preconditions.checkNotNull((Object)backendSnapshotMeta.getLocalSnapshotDir(), (String)"The local snapshot dir should not be null for backendSnapshotMeta.");
        Path localSnapshotBasePath = backendSnapshotMeta.getLocalSnapshotDir().getDirectory();
        Path localMetaPath = ((SnapshotManagerImpl)this.snapshotManager).getLocalSnapshotMetaPath(localSnapshotBasePath, checkpointId);
        PageBatchFlusher dfsPageBatchFlusher = new PageBatchFlusher(this.gContext.getGConfiguration().getSnapshotFlushBatchNumPage(), this.gContext.getGConfiguration().getSnapshotFlushBatchDataSize(), this.isForceFlushPage(), this.gContext.getSupervisor().getFileCache(), this.gContext.getSupervisor().getSnapshotExecutorGroup());
        SnapshotManager.PendingSnapshot pendingSnapshot = new SnapshotManager.PendingSnapshot(checkpointId, backendSnapshotMeta.getTimestamp(), snapshotCompletableFuture, dfsSnapshotBasePath, dfsMetaPath, localSnapshotBasePath, localMetaPath, accessNumber, this, dfsPageBatchFlusher);
        SnapshotCompaction snapshotCompaction = this.gContext.getGConfiguration().isSnapshotCompactionEnabled() ? new SnapshotCompactionImpl(this.gContext, pendingSnapshot) : new NoSnapshotCompaction();
        snapshotCompletableFuture.addSnapshotStage(snapshotCompaction);
        SnapshotFileSyncStage fileSyncStage = new SnapshotFileSyncStage(snapshotCompletableFuture, this.gContext.getSupervisor().getFileCache());
        snapshotCompletableFuture.addSnapshotStage(fileSyncStage);
        snapshotCompletableFuture.setPendingSnapshot(pendingSnapshot);
        pendingSnapshot.setSnapshotCompaction(snapshotCompaction);
        this.pendingSnapshot = pendingSnapshot;
        return pendingSnapshot;
    }

    @Override
    public SnapshotManager.PendingSnapshot getPendingSnapshot() {
        return this.pendingSnapshot;
    }

    @Override
    public DBSnapshotResult getSnapshotResult() throws Exception {
        SnapshotMetaFile.Writer localWriter = null;
        SnapshotMetaFile.Writer dfsWriter = null;
        try {
            localWriter = SnapshotMetaFile.getWriter(this.pendingSnapshot.getLocalSnapshotMetaPath());
            RegionSnapshot localRegionSnapshot = new RegionSnapshot(this.localFileManager, localWriter, true);
            dfsWriter = SnapshotMetaFile.getWriter(this.pendingSnapshot.getSnapshotMetaPath());
            RegionSnapshot dfsRegionSnapshot = new RegionSnapshot(this.dfsFileManager, dfsWriter, false);
            HashMap<Integer, Map<Integer, Tuple2<Integer, Long>>> dfsFileMapping = new HashMap<Integer, Map<Integer, Tuple2<Integer, Long>>>();
            HashMap<Integer, Map<Integer, Tuple2<Integer, Long>>> localFileMapping = new HashMap<Integer, Map<Integer, Tuple2<Integer, Long>>>();
            List<long[]> regionOffsetsCollection = this.writeRegionMetaAndPageIndex(this.pendingSnapshot.getGRegionSnapshotMeta(), Arrays.asList(localRegionSnapshot, dfsRegionSnapshot), Arrays.asList(localFileMapping, dfsFileMapping));
            Preconditions.checkState((regionOffsetsCollection.size() == 2 ? 1 : 0) != 0, (Object)"Expected regionOffsets of size as 2, one if for local region, the other is for dfs region");
            long[] localRegionOffsets = regionOffsetsCollection.get(0);
            long[] dfsRegionOffsets = regionOffsetsCollection.get(1);
            this.pendingSnapshot.setLocalFileMapping(localFileMapping);
            this.pendingSnapshot.setFileMapping(dfsFileMapping);
            Tuple2<Long, Long> localWriterFileMappingOffsets = this.writeDfsAndLocalFileMapping(this.pendingSnapshot, localWriter, this.localFileManager, this.dfsFileManager);
            Tuple2<Long, Long> dfsWriterFileMappingOffsets = this.writeDfsAndLocalFileMapping(this.pendingSnapshot, dfsWriter, null, this.dfsFileManager);
            long localSnapshotMetaSize = localWriter.getPos();
            long dfsSnapshotMetaSize = dfsWriter.getPos();
            SnapshotStat snapshotStat = this.pendingSnapshot.getSnapshotStat();
            snapshotStat.addAndGetTotalLoalFiles(localFileMapping.size());
            snapshotStat.setLocalMetaFileSize(localSnapshotMetaSize);
            snapshotStat.addAndGetTotalFiles(dfsFileMapping.size());
            snapshotStat.setMetaFileSize(dfsSnapshotMetaSize);
            this.createHardLinkForLocalFiles(this.pendingSnapshot.getLocalSnapshotBasePath(), localFileMapping.keySet());
            DBSnapshotMeta localDBSnapshotMeta = new DBSnapshotMeta(this.pendingSnapshot.getCheckpointId(), this.gContext.getStartRegionId(), this.gContext.getEndRegionId(), localRegionOffsets, (Long)localWriterFileMappingOffsets.f0, (Long)localWriterFileMappingOffsets.f1, localSnapshotMetaSize, snapshotStat.addAndGetTotalLocalSize(0L), snapshotStat.addAndGetLocalIncrementalSize(0L), localWriter.getFilePath().toUri().toString(), this.snapshotManager.getNameSpace());
            DBSnapshotMeta dfsDBSnapshotMeta = new DBSnapshotMeta(this.pendingSnapshot.getCheckpointId(), this.gContext.getStartRegionId(), this.gContext.getEndRegionId(), dfsRegionOffsets, (Long)dfsWriterFileMappingOffsets.f0, (Long)dfsWriterFileMappingOffsets.f1, dfsSnapshotMetaSize, snapshotStat.addAndGetTotalSize(0L), snapshotStat.addAndGetIncrementalSize(0L), dfsWriter.getFilePath().toUri().toString(), this.snapshotManager.getNameSpace());
            localWriter.close();
            dfsWriter.close();
            return new DBSnapshotResult(SnapshotDirectory.permanent(this.pendingSnapshot.getLocalSnapshotBasePath()), localDBSnapshotMeta, SnapshotDirectory.permanent(this.pendingSnapshot.getSnapshotBasePath()), dfsDBSnapshotMeta);
        }
        catch (Exception e) {
            LOG.error("Failed to snapshot meta for checkpoint " + this.pendingSnapshot.getCheckpointId(), (Throwable)e);
            this.closeAndDeleteWriterQuietly(localWriter);
            this.closeAndDeleteWriterQuietly(dfsWriter);
            throw e;
        }
    }

    @VisibleForTesting
    void createHardLinkForLocalFiles(Path snapshotBasePath, Set<Integer> fileIds) throws Exception {
        FileSystem fileSystem = snapshotBasePath.getFileSystem();
        if (!(fileSystem instanceof LocalFileSystem)) {
            LOG.error("expected LocalFilSystem, actual {}", (Object)fileSystem);
            throw new GeminiRuntimeException("hard link only works for local file system, actual " + fileSystem);
        }
        File snapshotBaseDir = new File(snapshotBasePath.toUri());
        for (int fileId : fileIds) {
            File file = new File(this.localFileManager.getFilePath(fileId));
            try {
                Files.createLink(new File(snapshotBaseDir, file.getName()).toPath(), file.toPath());
            }
            catch (Exception e) {
                LOG.error("Fail to create hard link from {} to {}.", new Object[]{file.getAbsolutePath(), snapshotBasePath.toUri().toString(), e});
                throw e;
            }
        }
    }
}

