/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.gemini.engine.snapshot;

import java.util.HashMap;
import java.util.Map;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.runtime.state.gemini.engine.fs.FileManager;
import org.apache.flink.runtime.state.gemini.engine.snapshot.SnapshotMetaFile;
import org.apache.flink.util.Preconditions;

public class RegionSnapshot {
    private final FileManager fileManager;
    private final SnapshotMetaFile.Writer writer;
    private int region;
    private final Map<Integer, Tuple2<Integer, Long>> regionFileMeta;
    private final boolean isLocalSnapshot;

    public RegionSnapshot(FileManager fileManager, SnapshotMetaFile.Writer writer, boolean isLocalSnapshot) {
        this.fileManager = (FileManager)Preconditions.checkNotNull((Object)fileManager);
        this.writer = (SnapshotMetaFile.Writer)Preconditions.checkNotNull((Object)writer);
        this.regionFileMeta = new HashMap<Integer, Tuple2<Integer, Long>>();
        this.isLocalSnapshot = isLocalSnapshot;
    }

    public boolean isLocalSnapshot() {
        return this.isLocalSnapshot;
    }

    public int getRegion() {
        return this.region;
    }

    public SnapshotMetaFile.Writer getWriter() {
        return this.writer;
    }

    public Map<Integer, Tuple2<Integer, Long>> getRegionFileMeta() {
        return this.regionFileMeta;
    }

    public void updateFileMeta(long address, int reference, long size) {
        Tuple2 meta;
        int fileId = this.fileManager.getSimpleFileID(address);
        Tuple2 tuple2 = meta = this.regionFileMeta.computeIfAbsent(fileId, no -> Tuple2.of((Object)0, (Object)0L));
        tuple2.f0 = (Integer)tuple2.f0 + reference;
        tuple2 = meta;
        tuple2.f1 = (Long)tuple2.f1 + size;
    }

    public void reset(int newRegion) {
        this.region = newRegion;
        if (this.regionFileMeta != null) {
            this.regionFileMeta.clear();
        }
    }
}

