/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.gemini.engine.snapshot;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.runtime.state.gemini.engine.snapshot.SnapshotManager;
import org.apache.flink.runtime.state.gemini.engine.snapshot.SnapshotStage;
import org.apache.flink.util.Preconditions;

public class SnapshotCompletableFuture
extends CompletableFuture<Boolean> {
    private final AtomicInteger runningTasks;
    private final AtomicBoolean endSnapshot;
    private SnapshotManager.PendingSnapshot pendingSnapshot;
    private List<SnapshotStage> snapshotStages;
    private AtomicInteger nextStageIndex;
    private ExecutorService snapshotExecutor;

    public SnapshotCompletableFuture(ExecutorService snapshotExecutor) {
        this.snapshotExecutor = snapshotExecutor;
        this.runningTasks = new AtomicInteger(0);
        this.endSnapshot = new AtomicBoolean(false);
        this.snapshotStages = new ArrayList<SnapshotStage>();
        this.nextStageIndex = new AtomicInteger(0);
    }

    public void incRunningTask() {
        this.runningTasks.incrementAndGet();
    }

    public void decRunningTask() {
        int left = this.runningTasks.decrementAndGet();
        Preconditions.checkState((left >= 0 ? 1 : 0) != 0, (Object)"Number of left running tasks can't be negative.");
        if (left == 0) {
            if (this.isCancelled() || this.isCompletedExceptionally()) {
                return;
            }
            if (this.nextStageIndex.get() >= this.snapshotStages.size()) {
                this.complete(true);
                return;
            }
            this.incRunningTask();
            int index = this.nextStageIndex.getAndAdd(1);
            this.runStage(this.snapshotStages.get(index));
            this.decRunningTask();
        }
    }

    public void setPendingSnapshot(SnapshotManager.PendingSnapshot pendingSnapshot) {
        this.pendingSnapshot = pendingSnapshot;
    }

    public SnapshotManager.PendingSnapshot getPendingSnapshot() {
        return this.pendingSnapshot;
    }

    public boolean isEndSnapshot() {
        return this.endSnapshot.get();
    }

    public void setEndSnapshot() {
        this.endSnapshot.set(true);
    }

    public void addSnapshotStage(SnapshotStage snapshotStage) {
        this.snapshotStages.add(snapshotStage);
    }

    public SnapshotStage getSnapshotStage(int index) {
        return index >= 0 && index < this.snapshotStages.size() ? this.snapshotStages.get(index) : null;
    }

    @VisibleForTesting
    List<SnapshotStage> getSnapshotStageList() {
        return this.snapshotStages;
    }

    @VisibleForTesting
    int getNextStateIndex() {
        return this.nextStageIndex.get();
    }

    @VisibleForTesting
    int getRunningTasks() {
        return this.runningTasks.get();
    }

    private void runStage(SnapshotStage snapshotStage) {
        if (snapshotStage.isAsync()) {
            this.runAsyncStage(snapshotStage);
        } else {
            this.runSyncStage(snapshotStage);
        }
    }

    private void runSyncStage(SnapshotStage snapshotStage) {
        this.incRunningTask();
        try {
            snapshotStage.run();
        }
        catch (Exception e) {
            this.setEndSnapshot();
            this.completeExceptionally(e);
        }
        finally {
            this.decRunningTask();
        }
    }

    private void runAsyncStage(SnapshotStage snapshotStage) {
        this.incRunningTask();
        this.snapshotExecutor.submit(() -> {
            try {
                snapshotStage.run();
            }
            catch (Exception e) {
                this.setEndSnapshot();
                this.completeExceptionally(e);
            }
            finally {
                this.decRunningTask();
            }
        });
    }
}

