/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.gemini.engine.snapshot;

import org.apache.flink.runtime.state.gemini.engine.filecache.FileCache;
import org.apache.flink.runtime.state.gemini.engine.snapshot.SnapshotCompletableFuture;
import org.apache.flink.runtime.state.gemini.engine.snapshot.SnapshotStage;

public class SnapshotFileSyncStage
implements SnapshotStage {
    private final SnapshotCompletableFuture completableFuture;
    private final FileCache fileCache;

    public SnapshotFileSyncStage(SnapshotCompletableFuture completableFuture, FileCache fileCache) {
        this.completableFuture = completableFuture;
        this.fileCache = fileCache;
    }

    @Override
    public void run() {
        this.completableFuture.incRunningTask();
        try {
            this.fileCache.sync();
        }
        catch (Exception e) {
            this.completableFuture.completeExceptionally(e);
        }
        finally {
            this.completableFuture.decRunningTask();
        }
    }

    @Override
    public boolean isAsync() {
        return false;
    }

    public String toString() {
        return "SnapshotFileSyncState";
    }
}

