/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.gemini.engine.snapshot;

import java.io.Closeable;
import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import javax.annotation.Nullable;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.core.fs.Path;
import org.apache.flink.runtime.state.gemini.engine.GRegionContext;
import org.apache.flink.runtime.state.gemini.engine.GRegionID;
import org.apache.flink.runtime.state.gemini.engine.filecache.PageBatchFlusher;
import org.apache.flink.runtime.state.gemini.engine.page.PageIndex;
import org.apache.flink.runtime.state.gemini.engine.snapshot.BackendSnapshotMeta;
import org.apache.flink.runtime.state.gemini.engine.snapshot.NoSnapshotCompaction;
import org.apache.flink.runtime.state.gemini.engine.snapshot.SnapshotCompaction;
import org.apache.flink.runtime.state.gemini.engine.snapshot.SnapshotCompletableFuture;
import org.apache.flink.runtime.state.gemini.engine.snapshot.SnapshotOperation;
import org.apache.flink.runtime.state.gemini.engine.snapshot.SnapshotStat;

public interface SnapshotManager
extends Closeable {
    public boolean isNeedToBreakLineage();

    public void setNeedToBreakLineage(boolean var1);

    public void startSnapshot(BackendSnapshotMeta var1) throws IOException;

    public void endSnapshot(long var1, Throwable var3);

    public PendingSnapshot getPendingSnapshot(long var1);

    public String getNameSpace();

    public long getMinRunningSnapshotAccessNumber();

    public ExecutorService getSnapshotExecutor();

    public void notifySnapshotComplete(long var1);

    public void notifySnapshotAbort(long var1);

    public void notifySnapshotSubsume(long var1);

    public Map<Long, RestoredSnapshot> restore(long var1, Map<Integer, String> var3, String var4);

    public static class RestoredSnapshot {
        private final long checkpointID;
        private final String metaFilePath;
        private final Map<Integer, String> fileMapping;

        public RestoredSnapshot(long checkpointID, String metaFilePath, Map<Integer, String> fileMapping) {
            this.checkpointID = checkpointID;
            this.metaFilePath = metaFilePath;
            this.fileMapping = fileMapping;
        }

        public long getCheckpointID() {
            return this.checkpointID;
        }

        public String getMetaFilePath() {
            return this.metaFilePath;
        }

        public Map<Integer, String> getFileMapping() {
            return this.fileMapping;
        }
    }

    public static class CompletedSnapshot {
        private final long checkpointID;
        private final String metaFilePath;
        private final Set<Integer> dataFileIDs;

        public CompletedSnapshot(long checkpointID, String metaFilePath, Set<Integer> dataFileIDs) {
            this.checkpointID = checkpointID;
            this.metaFilePath = metaFilePath;
            this.dataFileIDs = dataFileIDs;
        }

        public long getCheckpointID() {
            return this.checkpointID;
        }

        public String getMetaFilePath() {
            return this.metaFilePath;
        }

        public Set<Integer> getDataFileIDs() {
            return this.dataFileIDs;
        }

        public int hashCode() {
            return Objects.hash(this.checkpointID, this.metaFilePath, this.dataFileIDs);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CompletedSnapshot that = (CompletedSnapshot)o;
            return this.checkpointID == that.checkpointID && this.metaFilePath.equals(that.metaFilePath) && this.dataFileIDs.equals(that.dataFileIDs);
        }
    }

    public static class GRegionSnapshotMeta {
        private GRegionContext gRegionContext;
        private PageIndex pageIndex;
        private long lastSeqID;
        private long removeAllSeqID;

        GRegionSnapshotMeta(GRegionContext gRegionContext, PageIndex pageIndex, long lastSeqID, long removeAllSeqID) {
            this.gRegionContext = gRegionContext;
            this.pageIndex = pageIndex;
            this.lastSeqID = lastSeqID;
            this.removeAllSeqID = removeAllSeqID;
        }

        public GRegionContext getGRegionContext() {
            return this.gRegionContext;
        }

        public PageIndex getPageIndex() {
            return this.pageIndex;
        }

        public long getLastSeqID() {
            return this.lastSeqID;
        }

        public long getRemoveAllSeqID() {
            return this.removeAllSeqID;
        }
    }

    public static class PendingSnapshot {
        long checkpointId;
        long timestamp;
        SnapshotCompletableFuture resultFuture;
        private final Map<String, Map<GRegionID, GRegionSnapshotMeta>> regionSnapshotMetas;
        Path snapshotBasePath;
        Path snapshotMetaPath;
        @Nullable
        Path localSnapshotBasePath;
        @Nullable
        Path localSnapshotMetaPath;
        Map<Integer, Map<Integer, Tuple2<Integer, Long>>> fileMapping;
        @Nullable
        Map<Integer, Map<Integer, Tuple2<Integer, Long>>> localFileMapping;
        long accessNumber;
        SnapshotOperation snapshotOperation;
        SnapshotCompaction snapshotCompaction;
        private final SnapshotStat snapshotStat;
        private boolean isCanceled;
        private PageBatchFlusher dfsPageBatchFlusher;

        public PendingSnapshot(long checkpointId, long timestamp, SnapshotCompletableFuture resultFuture, Path snapshotBasePath, Path snapshotMetaPath, Path localSnapshotBasePath, Path localSnapshotMetaPath, long accessNumber, SnapshotOperation snapshotOperation, PageBatchFlusher dfsPageBatchFlusher) {
            this.checkpointId = checkpointId;
            this.timestamp = timestamp;
            this.resultFuture = resultFuture;
            this.snapshotBasePath = snapshotBasePath;
            this.snapshotMetaPath = snapshotMetaPath;
            this.localSnapshotBasePath = localSnapshotBasePath;
            this.localSnapshotMetaPath = localSnapshotMetaPath;
            this.accessNumber = accessNumber;
            this.snapshotOperation = snapshotOperation;
            this.regionSnapshotMetas = new ConcurrentHashMap<String, Map<GRegionID, GRegionSnapshotMeta>>();
            this.snapshotStat = new SnapshotStat();
            this.isCanceled = false;
            this.snapshotCompaction = NoSnapshotCompaction.INSTANCE;
            this.dfsPageBatchFlusher = dfsPageBatchFlusher;
        }

        public long getCheckpointId() {
            return this.checkpointId;
        }

        public long getTimestamp() {
            return this.timestamp;
        }

        public SnapshotCompletableFuture getResultFuture() {
            return this.resultFuture;
        }

        public Path getSnapshotBasePath() {
            return this.snapshotBasePath;
        }

        public Path getSnapshotMetaPath() {
            return this.snapshotMetaPath;
        }

        public Path getLocalSnapshotBasePath() {
            return this.localSnapshotBasePath;
        }

        public Path getLocalSnapshotMetaPath() {
            return this.localSnapshotMetaPath;
        }

        public long getAccessNumber() {
            return this.accessNumber;
        }

        public SnapshotOperation getSnapshotOperation() {
            return this.snapshotOperation;
        }

        public SnapshotCompaction getSnapshotCompaction() {
            return this.snapshotCompaction;
        }

        public void setSnapshotCompaction(SnapshotCompaction snapshotCompaction) {
            this.snapshotCompaction = snapshotCompaction;
        }

        public void addGRegionSnapshotMeta(GRegionContext gRegionContext, PageIndex pageIndex) {
            this.regionSnapshotMetas.computeIfAbsent(gRegionContext.getTableName(), nothing -> new ConcurrentHashMap()).put(gRegionContext.getRegionId(), new GRegionSnapshotMeta(gRegionContext, pageIndex, gRegionContext.getLastSeqId(), gRegionContext.getRemoveAllSeqId()));
        }

        public Map<String, Map<GRegionID, GRegionSnapshotMeta>> getGRegionSnapshotMeta() {
            return this.regionSnapshotMetas;
        }

        public void setFileMapping(Map<Integer, Map<Integer, Tuple2<Integer, Long>>> fileMapping) {
            this.fileMapping = fileMapping;
        }

        public Map<Integer, Map<Integer, Tuple2<Integer, Long>>> getFileMapping() {
            return this.fileMapping;
        }

        public void setLocalFileMapping(Map<Integer, Map<Integer, Tuple2<Integer, Long>>> localFileMapping) {
            this.localFileMapping = localFileMapping;
        }

        public Map<Integer, Map<Integer, Tuple2<Integer, Long>>> getLocalFileMapping() {
            return this.localFileMapping;
        }

        public SnapshotStat getSnapshotStat() {
            return this.snapshotStat;
        }

        public PageBatchFlusher getDfsPageBatchFlusher() {
            return this.dfsPageBatchFlusher;
        }

        public void releaseResource() {
            this.regionSnapshotMetas.clear();
            if (this.fileMapping != null) {
                this.fileMapping.clear();
            }
            if (this.localFileMapping != null) {
                this.localFileMapping.clear();
            }
        }

        public boolean isCanceled() {
            return this.isCanceled;
        }

        @VisibleForTesting
        void setCanceled(boolean canceled) {
            this.isCanceled = canceled;
        }
    }
}

