/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.gemini.engine.snapshot;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.flink.api.common.typeutils.base.MapSerializer;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.core.fs.Path;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.core.memory.DataOutputViewStreamWrapper;
import org.apache.flink.runtime.state.gemini.engine.GRegionID;
import org.apache.flink.runtime.state.gemini.engine.dbms.GContext;
import org.apache.flink.runtime.state.gemini.engine.fs.FileManager;
import org.apache.flink.runtime.state.gemini.engine.fs.FileMeta;
import org.apache.flink.runtime.state.gemini.engine.snapshot.BackendSnapshotMeta;
import org.apache.flink.runtime.state.gemini.engine.snapshot.DBSnapshotResult;
import org.apache.flink.runtime.state.gemini.engine.snapshot.RegionSnapshot;
import org.apache.flink.runtime.state.gemini.engine.snapshot.SnapshotManager;
import org.apache.flink.runtime.state.gemini.engine.snapshot.SnapshotManagerImpl;
import org.apache.flink.runtime.state.gemini.engine.snapshot.SnapshotMetaFile;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.function.ThrowingConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SnapshotOperation {
    private static final Logger LOG = LoggerFactory.getLogger(SnapshotOperation.class);
    protected final GContext gContext;
    protected final SnapshotManager snapshotManager;
    private boolean forceFlushPage = false;

    SnapshotOperation(GContext gContext, SnapshotManager snapshotManager) {
        this.gContext = (GContext)Preconditions.checkNotNull((Object)gContext);
        this.snapshotManager = (SnapshotManager)Preconditions.checkNotNull((Object)snapshotManager);
    }

    public SnapshotManager getSnapshotManager() {
        return this.snapshotManager;
    }

    public abstract SnapshotManager.PendingSnapshot createPendingSnapshot(BackendSnapshotMeta var1, long var2);

    public abstract SnapshotManager.PendingSnapshot getPendingSnapshot();

    public abstract DBSnapshotResult getSnapshotResult() throws Exception;

    public void setForceFlushPage(boolean forceFlushPage) {
        this.forceFlushPage = forceFlushPage;
    }

    public boolean isForceFlushPage() {
        return this.forceFlushPage;
    }

    List<long[]> writeRegionMetaAndPageIndex(Map<String, Map<GRegionID, SnapshotManager.GRegionSnapshotMeta>> tableRegionMap, List<RegionSnapshot> regionSnapshots, List<Map<Integer, Map<Integer, Tuple2<Integer, Long>>>> fileMappings) throws IOException {
        Preconditions.checkState((regionSnapshots.size() == fileMappings.size() ? 1 : 0) != 0, (Object)String.format("Unexpected size of region snapshots: %s v.s file mapping size %s.", regionSnapshots.size(), fileMappings.size()));
        int startRegionId = this.gContext.getStartRegionId();
        int endRegionId = this.gContext.getEndRegionId();
        int regionSize = endRegionId - startRegionId + 1;
        ArrayList<long[]> regionOffsets = new ArrayList<long[]>(regionSnapshots.size());
        for (int i = 0; i < regionSnapshots.size(); ++i) {
            regionOffsets.add(new long[regionSize]);
        }
        HashSet<String> indexRegionTables = new HashSet<String>();
        for (Map.Entry<String, Map<GRegionID, SnapshotManager.GRegionSnapshotMeta>> entry : tableRegionMap.entrySet()) {
            boolean indexRegionExisted = entry.getValue().keySet().stream().anyMatch(gRegionId -> gRegionId.getIndexID() == 1);
            if (!indexRegionExisted) continue;
            indexRegionTables.add(entry.getKey());
        }
        List<SnapshotMetaFile.Writer> writers = regionSnapshots.stream().map(RegionSnapshot::getWriter).collect(Collectors.toList());
        SnapshotMetaFile.writerFunc(writers, (ThrowingConsumer<SnapshotMetaFile.Writer, IOException>)((ThrowingConsumer)w -> w.writeInt(tableRegionMap.size())));
        for (int regionId = startRegionId; regionId <= endRegionId; ++regionId) {
            for (int i = 0; i < regionOffsets.size(); ++i) {
                ((long[])regionOffsets.get((int)i))[regionId - startRegionId] = writers.get(i).getPos();
            }
            int currentRegionId = regionId;
            SnapshotMetaFile.writerFunc(writers, (ThrowingConsumer<SnapshotMetaFile.Writer, IOException>)((ThrowingConsumer)w -> w.writeInt(currentRegionId)));
            for (Map.Entry<String, Map<GRegionID, SnapshotManager.GRegionSnapshotMeta>> te : tableRegionMap.entrySet()) {
                String tableName = te.getKey();
                Map<GRegionID, SnapshotManager.GRegionSnapshotMeta> regionMetas = te.getValue();
                SnapshotMetaFile.writerFunc(writers, (ThrowingConsumer<SnapshotMetaFile.Writer, IOException>)((ThrowingConsumer)w -> w.writeUTF(tableName)));
                int expectedRegions = indexRegionTables.contains(tableName) ? 2 : 1;
                int actualRegions = 0;
                for (Map.Entry<GRegionID, SnapshotManager.GRegionSnapshotMeta> re : regionMetas.entrySet()) {
                    int groupId = re.getKey().getId();
                    if (groupId != regionId) continue;
                    if (actualRegions == 0) {
                        SnapshotMetaFile.writerFunc(writers, (ThrowingConsumer<SnapshotMetaFile.Writer, IOException>)((ThrowingConsumer)w -> w.writeInt(expectedRegions)));
                    }
                    SnapshotManager.GRegionSnapshotMeta meta = re.getValue();
                    SnapshotMetaFile.writerFunc(writers, (ThrowingConsumer<SnapshotMetaFile.Writer, IOException>)((ThrowingConsumer)w -> w.writeInt(((GRegionID)re.getKey()).getRegionCode())));
                    SnapshotMetaFile.writerFunc(writers, (ThrowingConsumer<SnapshotMetaFile.Writer, IOException>)((ThrowingConsumer)w -> w.writeLong(meta.getLastSeqID())));
                    SnapshotMetaFile.writerFunc(writers, (ThrowingConsumer<SnapshotMetaFile.Writer, IOException>)((ThrowingConsumer)w -> w.writeLong(meta.getRemoveAllSeqID())));
                    regionSnapshots.forEach(rs -> rs.reset(groupId));
                    meta.getPageIndex().snapshot(regionSnapshots);
                    for (int i = 0; i < fileMappings.size(); ++i) {
                        this.updateFileMapping(fileMappings.get(i), regionSnapshots.get(i), groupId);
                    }
                    if (++actualRegions != expectedRegions) continue;
                    break;
                }
                if (actualRegions != 0) continue;
                SnapshotMetaFile.writerFunc(writers, (ThrowingConsumer<SnapshotMetaFile.Writer, IOException>)((ThrowingConsumer)w -> w.writeInt(0)));
            }
        }
        return regionOffsets;
    }

    Tuple2<Long, Long> writeDfsAndLocalFileMapping(SnapshotManager.PendingSnapshot pendingSnapshot, SnapshotMetaFile.Writer writer, @Nullable FileManager localFileManager, FileManager dfsFileManager) throws IOException {
        long dfsMappingOffset = writer.getPos();
        this.writeFileMapping(writer, dfsFileManager, pendingSnapshot.getSnapshotBasePath(), pendingSnapshot.getFileMapping(), false);
        long localMappingOffset = writer.getPos();
        this.writeFileMapping(writer, localFileManager, pendingSnapshot.getLocalSnapshotBasePath(), pendingSnapshot.getLocalFileMapping(), true);
        writer.writeLong(dfsMappingOffset);
        writer.writeLong(localMappingOffset);
        return Tuple2.of((Object)dfsMappingOffset, (Object)localMappingOffset);
    }

    void closeAndDeleteWriterQuietly(SnapshotMetaFile.Writer writer) {
        if (writer != null) {
            Path path = writer.getFilePath();
            try {
                writer.close();
            }
            catch (IOException ioe) {
                LOG.warn("Failed to close meta writer, {}, {}.", (Object)path.toUri().toString(), (Object)ioe);
            }
            try {
                FileSystem fileSystem = path.getFileSystem();
                fileSystem.delete(path, false);
            }
            catch (IOException ioe) {
                LOG.warn("Failed to delete meta file, {}, {}.", (Object)path.toUri().toString(), (Object)ioe);
            }
        }
    }

    private void writeFileMapping(SnapshotMetaFile.Writer writer, @Nullable FileManager fileManager, Path snapshotBasePath, Map<Integer, Map<Integer, Tuple2<Integer, Long>>> fileMapping, boolean isLocal) throws IOException {
        if (fileManager == null) {
            writer.writeBoolean(false);
        } else {
            writer.writeBoolean(true);
            writer.writeInt(fileMapping.size());
            writer.writeUTF(snapshotBasePath.toUri().toString());
            if (fileMapping.size() > 0) {
                for (Integer fileId : fileMapping.keySet()) {
                    FileMeta fileMeta = fileManager.getFileMeta(fileId);
                    String path = fileMeta.getFilePath();
                    writer.writeUTF(isLocal ? new Path(path).getName() : path);
                    writer.writeInt(fileId);
                    writer.writeLong(fileMeta.getFileSize());
                }
                MapSerializer<Integer, Map<Integer, Tuple2<Integer, Long>>> fileMappingSerializer = ((SnapshotManagerImpl)this.snapshotManager).getFileMappingSerializer();
                DataOutputViewStreamWrapper dataOutputView = new DataOutputViewStreamWrapper((OutputStream)((Object)writer));
                fileMappingSerializer.serialize(fileMapping, (DataOutputView)dataOutputView);
            }
        }
    }

    private void updateFileMapping(Map<Integer, Map<Integer, Tuple2<Integer, Long>>> fileMapping, RegionSnapshot regionSnapshot, int groupId) {
        for (Map.Entry<Integer, Tuple2<Integer, Long>> entry : regionSnapshot.getRegionFileMeta().entrySet()) {
            Tuple2 tuple;
            int fileId = entry.getKey();
            Map groupStat = fileMapping.computeIfAbsent(fileId, nothing -> new HashMap());
            Tuple2 tuple2 = tuple = groupStat.computeIfAbsent(groupId, nothing -> Tuple2.of((Object)0, (Object)0L));
            Integer.valueOf((Integer)tuple2.f0 + (Integer)entry.getValue().f0);
            tuple2.f0 = tuple2.f0;
            tuple2 = tuple;
            Long.valueOf((Long)tuple2.f1 + (Long)entry.getValue().f1);
            tuple2.f1 = tuple2.f1;
        }
    }
}

