/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.gemini.engine.snapshot;

import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.flink.shaded.guava18.com.google.common.base.MoreObjects;

public class SnapshotStat {
    private AtomicInteger totalPages = new AtomicInteger();
    private AtomicLong totalSize = new AtomicLong();
    private AtomicInteger incrementalPages = new AtomicInteger();
    private AtomicLong incrementalSize = new AtomicLong();
    private AtomicInteger totalFiles = new AtomicInteger();
    private long metaFileSize;
    private AtomicInteger totalLocalPages = new AtomicInteger();
    private AtomicLong totalLocalSize = new AtomicLong();
    private AtomicInteger localIncrementalPages = new AtomicInteger();
    private AtomicLong localIncrementalSize = new AtomicLong();
    private AtomicInteger totalLocalFiles = new AtomicInteger();
    private long localMetaFileSize;
    private long syncStartTime;
    private long asyncStartTime;
    private long completeTime;
    private long totalFileSizeBeforeCompaction = 0L;
    private long incrementalSizeBeforeCompaction = 0L;
    private float amplificationRatioBeforeCompaction = 1.0f;
    private long compactionStartTime;
    private long compactionEndTime;
    private boolean needCompaction = false;
    private float actualAmplificationRatio = 1.0f;

    public int addAndGetTotalPages(int delta) {
        return this.totalPages.addAndGet(delta);
    }

    public long addAndGetTotalSize(long delta) {
        return this.totalSize.addAndGet(delta);
    }

    public int addAndGetIncrementalPages(int delta) {
        return this.incrementalPages.addAndGet(delta);
    }

    public long addAndGetIncrementalSize(long delta) {
        return this.incrementalSize.addAndGet(delta);
    }

    public int addAndGetTotalFiles(int delta) {
        return this.totalFiles.addAndGet(delta);
    }

    public void setMetaFileSize(long size) {
        this.metaFileSize = size;
    }

    public long getMetaFileSize() {
        return this.metaFileSize;
    }

    public int addAndGetTotalLocalPages(int delta) {
        return this.totalLocalPages.addAndGet(delta);
    }

    public long addAndGetTotalLocalSize(long delta) {
        return this.totalLocalSize.addAndGet(delta);
    }

    public int addAndGetLocalIncrementalPages(int delta) {
        return this.localIncrementalPages.addAndGet(delta);
    }

    public long addAndGetLocalIncrementalSize(long delta) {
        return this.localIncrementalSize.addAndGet(delta);
    }

    public int addAndGetTotalLoalFiles(int delta) {
        return this.totalLocalFiles.addAndGet(delta);
    }

    public void setLocalMetaFileSize(long size) {
        this.localMetaFileSize = size;
    }

    public long getLocalMetaFileSize() {
        return this.localMetaFileSize;
    }

    public void setSyncStartTime(long time) {
        this.syncStartTime = time;
    }

    public long getSyncStartTime() {
        return this.syncStartTime;
    }

    public void setAsyncStartTime(long time) {
        this.asyncStartTime = time;
    }

    public long getAsyncStartTime() {
        return this.asyncStartTime;
    }

    public void setCompleteTime(long time) {
        this.completeTime = time;
    }

    public long getCompleteTime() {
        return this.completeTime;
    }

    public long getTotalFileSizeBeforeCompaction() {
        return this.totalFileSizeBeforeCompaction;
    }

    public void setTotalFileSizeBeforeCompaction(long totalFileSizeBeforeCompaction) {
        this.totalFileSizeBeforeCompaction = totalFileSizeBeforeCompaction;
    }

    public long getIncrementalSizeBeforeCompaction() {
        return this.incrementalSizeBeforeCompaction;
    }

    public void setIncrementalSizeBeforeCompaction(long incrementalSizeBeforeCompaction) {
        this.incrementalSizeBeforeCompaction = incrementalSizeBeforeCompaction;
    }

    public float getAmplificationRatioBeforeCompaction() {
        return this.amplificationRatioBeforeCompaction;
    }

    public void setAmplificationRatioBeforeCompaction(float amplificationRatioBeforeCompaction) {
        this.amplificationRatioBeforeCompaction = amplificationRatioBeforeCompaction;
    }

    public long getCompactionStartTime() {
        return this.compactionStartTime;
    }

    public void setCompactionStartTime(long compactionStartTime) {
        this.compactionStartTime = compactionStartTime;
    }

    public long getCompactionEndTime() {
        return this.compactionEndTime;
    }

    public void setCompactionEndTime(long compactionEndTime) {
        this.compactionEndTime = compactionEndTime;
    }

    public boolean isNeedCompaction() {
        return this.needCompaction;
    }

    public void setNeedCompaction(boolean needCompaction) {
        this.needCompaction = needCompaction;
    }

    public float getActualAmplificationRatio() {
        return this.actualAmplificationRatio;
    }

    public void setActualAmplificationRatio(float actualAmplificationRatio) {
        this.actualAmplificationRatio = actualAmplificationRatio;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("totalPages", this.totalPages.get()).add("totalSize", this.totalSize.get()).add("incrementalPages", this.incrementalPages.get()).add("incrementalSize", this.incrementalSize.get()).add("totalFiles", this.totalFiles.get()).add("metaFileSize", this.metaFileSize).add("totalLocalPages", this.totalLocalPages.get()).add("totalLocalSize", this.totalLocalSize.get()).add("localIncrementalPages", this.localIncrementalPages.get()).add("localIncrementalSize", this.localIncrementalSize.get()).add("totalLocalFiles", this.totalLocalFiles.get()).add("localMetaFileSize", this.localMetaFileSize).add("syncStartTime", this.syncStartTime).add("asyncStartTime", this.asyncStartTime).add("completeTime", this.completeTime).add("totalSyncTime", (Object)(this.asyncStartTime - this.syncStartTime + "ms")).add("totalAsyncTime", (Object)(this.completeTime - this.asyncStartTime + "ms")).add("totalTime", (Object)(this.completeTime - this.syncStartTime + "ms")).add("totalFileSizeBeforeCompaction", this.totalFileSizeBeforeCompaction).add("incrementalSizeBeforeCompaction", this.incrementalSizeBeforeCompaction).add("amplificationRatioBeforeCompaction", this.amplificationRatioBeforeCompaction).add("compactionStartTime", this.compactionStartTime).add("compactionEndTime", this.compactionEndTime).add("needCompaction", this.needCompaction).add("actualAmplificationRatio", this.actualAmplificationRatio).toString();
    }
}

