/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.gemini.engine.utils;

import org.apache.flink.runtime.state.gemini.engine.exceptions.GeminiRuntimeException;

public class SeqIDUtils {
    public static final int BITS_FOR_TIMESTAMP = 48;
    public static final int BITS_FOR_COUNTER = 16;
    public static final long MAX_TIMESTAMP = 0x7FFFFFFFFFFFL;
    public static final long MAX_COUNTER = 32767L;
    public static final long INVALID_SEQID = 0L;
    public static final long COUNTER_MASK = 65535L;

    public static long timestamp(long seqID) {
        return seqID >>> 16;
    }

    public static long counter(long seqID) {
        return seqID & 0xFFFFL;
    }

    public static long nextSeqID(long lastSeqID, long ts) {
        long lastTime = SeqIDUtils.timestamp(lastSeqID);
        if (ts < lastTime || ts > 0x7FFFFFFFFFFFL) {
            throw new GeminiRuntimeException("Unexpected timestamp: lastTime " + lastTime + ", ts " + ts + ", please contact dev");
        }
        long c = SeqIDUtils.counter(lastSeqID);
        long nc = 0L;
        if (ts == lastTime) {
            if (c == 32767L) {
                throw new GeminiRuntimeException("counter overflowed, please contact dev");
            }
            nc = c + 1L;
        }
        return SeqIDUtils.generateSeqID(ts, nc);
    }

    public static long generateSeqID(long ts, long counter) {
        return ts << 16 | counter;
    }
}

