/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.gemini.engine.vm;

import java.io.IOException;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.runtime.state.gemini.engine.page.DataPage;
import org.apache.flink.runtime.state.gemini.engine.page.PageAddress;
import org.apache.flink.runtime.state.gemini.engine.page.bloomfilter.PageBloomFilter;
import org.apache.flink.runtime.state.gemini.engine.vm.BloomFilterManager;
import org.apache.flink.shaded.guava18.com.google.common.base.MoreObjects;
import org.apache.flink.shaded.guava18.com.google.common.cache.Cache;
import org.apache.flink.shaded.guava18.com.google.common.cache.CacheBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BloomFilterManagerImpl
implements BloomFilterManager {
    private static final Logger LOG = LoggerFactory.getLogger(BloomFilterManagerImpl.class);
    private static final long DEFAULT_MAX_WEIGHT = 0x6400000L;
    private static final int DEFAULT_CONCURRENT_LEVEL = 4;
    private final Cache<PageAddress, PageBloomFilter> bloomFilterCache;

    public BloomFilterManagerImpl() {
        this(0x6400000L, 4);
    }

    public BloomFilterManagerImpl(long maxWeight, int concurrentLevel) {
        this.bloomFilterCache = CacheBuilder.newBuilder().maximumWeight(maxWeight).weigher((pageAddress, pageBloomFilter) -> pageBloomFilter.byteSize()).concurrencyLevel(concurrentLevel).recordStats().build();
        LOG.info("BloomFilterManagerImpl start. maxWeight({}),concurrentLevel({})", (Object)maxWeight, (Object)concurrentLevel);
    }

    @Override
    public void close() throws IOException {
        this.bloomFilterCache.invalidateAll();
    }

    @Override
    public boolean mightContain(PageAddress pageAddress, int hashCode2) {
        PageBloomFilter pageBloomFilter = (PageBloomFilter)this.bloomFilterCache.getIfPresent((Object)pageAddress);
        return pageBloomFilter == null || pageBloomFilter.mightContain(hashCode2);
    }

    @Override
    public void addBloomFilter(PageAddress pageAddress, PageBloomFilter pageBloomFilter) {
        this.bloomFilterCache.put((Object)pageAddress, (Object)pageBloomFilter);
    }

    @Override
    public void addBloomFilter(PageAddress pageAddress, DataPage dataPage) {
        PageBloomFilter pageBloomFilter = PageBloomFilter.createByPage(dataPage);
        if (pageBloomFilter != null) {
            this.addBloomFilter(pageAddress, pageBloomFilter);
        }
    }

    @Override
    public void removeBloomFilter(PageAddress pageAddress) {
        this.bloomFilterCache.invalidate((Object)pageAddress);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("bloomSize", this.bloomFilterCache.size()).add("bloomCacheStats", (Object)this.bloomFilterCache.stats()).toString();
    }

    @VisibleForTesting
    Cache<PageAddress, PageBloomFilter> getBloomFilterCache() {
        return this.bloomFilterCache;
    }

    @Override
    public void cleanUp() {
        this.bloomFilterCache.cleanUp();
    }
}

