/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.gemini.engine.vm;

import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.flink.metrics.MetricGroup;
import org.apache.flink.runtime.state.gemini.engine.metrics.MetricsRegisterAble;
import org.apache.flink.shaded.guava18.com.google.common.base.MoreObjects;

public class CacheStats
implements MetricsRegisterAble {
    private final AtomicLong totalLogicPageSize = new AtomicLong(0L);
    private final AtomicLong totalPageUsedMemory = new AtomicLong(0L);
    private final AtomicLong totalIndexCapacity = new AtomicLong(0L);
    private final AtomicLong totalLogicPageCount = new AtomicLong(0L);
    private final AtomicLong totalWriteBufferHitCount = new AtomicLong(0L);
    private final AtomicLong totalWriteBufferMissCount = new AtomicLong(0L);
    private final AtomicLong totalPageCacheHitCount = new AtomicLong(0L);
    private final AtomicLong totalPageCacheMissCount = new AtomicLong(0L);
    private final AtomicLong totalSubPageCacheHitCount = new AtomicLong(0L);
    private final AtomicLong totalSubPageCacheMissCount = new AtomicLong(0L);
    private final AtomicLong totalPageCacheLRUHitCount = new AtomicLong(0L);
    private final AtomicLong totalPageCacheEvictSize = new AtomicLong(0L);
    private final AtomicLong totalPageCacheForceEvictSize = new AtomicLong(0L);
    private final AtomicLong totalPageFlushToLocalSize = new AtomicLong(0L);
    private final AtomicLong totalPageFlushToDFSSize = new AtomicLong(0L);
    private final AtomicLong totalPageCachePrefetchSize = new AtomicLong(0L);
    private final AtomicLong totalPageForceFetchByCompactionCount = new AtomicLong(0L);
    private final AtomicLong totalPageFetchInSnapshotSize = new AtomicLong(0L);
    private final AtomicLong totalLogicPageChainLen = new AtomicLong(0L);
    private final AtomicLong totalLogicSubPageCount = new AtomicLong(0L);
    private final AtomicLong totalLogicSubPageSize = new AtomicLong(0L);
    private final AtomicInteger totalRunningMinorCompaction = new AtomicInteger(0);
    private final AtomicInteger totalRunningMajorCompaction = new AtomicInteger(0);
    private final AtomicInteger totalRunningMinorCompactionByRead = new AtomicInteger(0);
    private final AtomicLong totalMinorCompactions = new AtomicLong(0L);
    private final AtomicLong totalMinorCompactedPages = new AtomicLong(0L);
    private final AtomicLong totalMajorCompactions = new AtomicLong(0L);
    private final AtomicLong totalMajorCompactedPages = new AtomicLong(0L);
    private final AtomicLong totalEvictBlockCount = new AtomicLong(0L);
    private final AtomicLong totalBloomFilterHitCount = new AtomicLong(0L);
    private final AtomicLong totalHugePageSize = new AtomicLong(0L);
    private final AtomicInteger totalHugePageCount = new AtomicInteger(0);
    private final AtomicLong totalFillPoolCount = new AtomicLong(0L);
    private final AtomicLong totalFillPoolTime = new AtomicLong(0L);
    private final AtomicLong runningCompactingPageSize = new AtomicLong(0L);
    private final AtomicLong totalLruPageIntoMainCache = new AtomicLong(0L);
    private final AtomicLong totalLruPagePreIntoMainCache = new AtomicLong(0L);

    public void addLRUPageIntoMainCache() {
        this.totalLruPageIntoMainCache.incrementAndGet();
    }

    public void addLRUPagePreIntoMainCache() {
        this.totalLruPagePreIntoMainCache.incrementAndGet();
    }

    public long getLRUPageIntoMainCache() {
        return this.totalLruPageIntoMainCache.get();
    }

    public long getLRUPagePreIntoMainCache() {
        return this.totalLruPagePreIntoMainCache.get();
    }

    public void addTotalLogicPageSize(int pageSize) {
        this.totalLogicPageSize.addAndGet(pageSize);
    }

    public void addPageUsedMemory(int pageSize) {
        this.totalPageUsedMemory.addAndGet(pageSize);
    }

    public void addIndexCapacity(int indexCapacity) {
        this.totalIndexCapacity.addAndGet(indexCapacity);
    }

    public long getTotalLogicPageSize() {
        return this.totalLogicPageSize.get();
    }

    public long getTotalPageUsedMemory() {
        return this.totalPageUsedMemory.get();
    }

    public long getTotalIndexCapacity() {
        return this.totalIndexCapacity.get();
    }

    public void addWriteBufferHitCount() {
        this.totalWriteBufferHitCount.incrementAndGet();
    }

    public void addWriteBufferMissCount() {
        this.totalWriteBufferMissCount.incrementAndGet();
    }

    public void addPageCacheHitCount() {
        this.totalPageCacheHitCount.incrementAndGet();
    }

    public void addPageCacheMissCount() {
        this.totalPageCacheMissCount.incrementAndGet();
    }

    public void addSubPageCacheHitCount() {
        this.totalSubPageCacheHitCount.incrementAndGet();
    }

    public void addSubPageCacheMissCount() {
        this.totalSubPageCacheMissCount.incrementAndGet();
    }

    public long getSubPageCacheRequestCount() {
        return this.totalSubPageCacheHitCount.get() + this.totalSubPageCacheMissCount.get();
    }

    public long getSubPageCacheHitCount() {
        return this.totalSubPageCacheHitCount.get();
    }

    public long getPageCacheRequestCount() {
        return this.totalPageCacheHitCount.get() + this.totalPageCacheMissCount.get();
    }

    public long getPageCacheHitCount() {
        return this.totalPageCacheHitCount.get() + this.totalPageCacheLRUHitCount.get();
    }

    public void addPageForceFetchByCompactionCount() {
        this.totalPageForceFetchByCompactionCount.incrementAndGet();
    }

    public void addPageCacheEvictSize(int size) {
        this.totalPageCacheEvictSize.addAndGet(size);
    }

    public void addPageCacheForceEvictSize(int size) {
        this.totalPageCacheForceEvictSize.addAndGet(size);
    }

    public void addPageCacheFlushSize(int size, boolean isLocal) {
        if (isLocal) {
            this.totalPageFlushToLocalSize.addAndGet(size);
        } else {
            this.totalPageFlushToDFSSize.addAndGet(size);
        }
    }

    public void addTotalPageFetchInSnapshotSize(int size) {
        this.totalPageFetchInSnapshotSize.addAndGet(size);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("totalPageUsedMemory", (Object)this.totalPageUsedMemory).add("totalLogicPageSize", (Object)this.totalLogicPageSize).add("totalIndexCapacity", (Object)this.totalIndexCapacity).add("totalLogicPageCount", (Object)this.totalLogicPageCount).add("totalLogicPageChainLen", this.totalLogicPageChainLen.get()).add("totalLogicSubPageCount", this.totalLogicSubPageCount.get()).add("totalLogicSubPageSize", this.totalLogicSubPageSize.get()).add("totalWriteBufferHitCount", (Object)this.totalWriteBufferHitCount).add("totalWriteBufferMissCount", (Object)this.totalWriteBufferMissCount).add("totalPageCacheHitCount", (Object)this.totalPageCacheHitCount).add("totalPageCacheLRUHitCount", (Object)this.totalPageCacheLRUHitCount).add("totalPageCacheMissCount", (Object)this.totalPageCacheMissCount).add("totalPageCacheEvictSize", (Object)this.totalPageCacheEvictSize).add("totalPageCacheForceEvictSize", (Object)this.totalPageCacheForceEvictSize).add("totalPageFlushToLocalSize", (Object)this.totalPageFlushToLocalSize).add("totalPageFlushToDFSSize", (Object)this.totalPageFlushToDFSSize).add("totalPageFetchInSnapshotSize", (Object)this.totalPageFetchInSnapshotSize).add("totalPageCachePrefetchSize", (Object)this.totalPageCachePrefetchSize).add("totalPageForceFetchByCompactionCount", (Object)this.totalPageForceFetchByCompactionCount).add("totalRunningMajorCompaction", this.totalRunningMajorCompaction.get()).add("totalRunningMinorCompaction", this.totalRunningMinorCompaction.get()).add("totalRunningMinorCompactionByRead", this.totalRunningMinorCompactionByRead.get()).add("totalEvictBlockCount", this.totalEvictBlockCount.get()).add("totalHugePageCount", this.totalHugePageCount.get()).add("totalHugePageSize", this.totalHugePageSize.get()).add("totalLRUPageIntoMainCache", this.totalLruPageIntoMainCache.get()).add("totalLRUPreIntoMainCache", this.totalLruPagePreIntoMainCache.get()).add("totalBloomFilterHitCount", this.totalBloomFilterHitCount.get()).add("totalRunningCompactingPageSize", this.runningCompactingPageSize.get()).toString();
    }

    public void addTotalLogicPageCount(int logicPageCount) {
        this.totalLogicPageCount.addAndGet(logicPageCount);
    }

    public void addTotalLogicPageChainLen(int logicPageChainLen) {
        this.totalLogicPageChainLen.addAndGet(logicPageChainLen);
    }

    public void addTotalLogicSubPageCount(int subPageCount) {
        this.totalLogicSubPageCount.addAndGet(subPageCount);
    }

    public void addTotalLogicSubPageSize(int subPageSize) {
        this.totalLogicSubPageSize.addAndGet(subPageSize);
    }

    public void addTotalRunningMajorCompactedPages(int i) {
        this.totalRunningMajorCompaction.addAndGet(i);
    }

    public void addTotalRunningMinorCompactedPages(int i) {
        this.totalRunningMinorCompaction.addAndGet(i);
    }

    public int getRunningMajorCompactedPages() {
        return this.totalRunningMajorCompaction.get();
    }

    public int getRunningMinorCompactedPages() {
        return this.totalRunningMinorCompaction.get();
    }

    public void addRunningMinorCompactionByRead(int i) {
        this.totalRunningMinorCompactionByRead.addAndGet(i);
    }

    public int getRunningMinorCompactionByRead() {
        return this.totalRunningMinorCompactionByRead.get();
    }

    public void addPageCacheLRUHitCount() {
        this.totalPageCacheLRUHitCount.incrementAndGet();
    }

    public void addMinorCompactedPages(int n) {
        this.totalMinorCompactions.addAndGet(1L);
        this.totalMinorCompactedPages.addAndGet(n);
    }

    public void addMajorCompactedPages(int n) {
        this.totalMajorCompactions.addAndGet(1L);
        this.totalMajorCompactedPages.addAndGet(n);
    }

    private double getAveragePageChainLen() {
        long curLogicPageCount = this.totalLogicPageCount.get();
        return curLogicPageCount == 0L ? 0.0 : (double)this.totalLogicPageChainLen.get() / (double)curLogicPageCount;
    }

    private double getAveragePageSize() {
        long curLogicPageChainLen = this.totalLogicPageChainLen.get();
        return curLogicPageChainLen == 0L ? 0.0 : (double)this.totalLogicPageSize.get() / (double)curLogicPageChainLen;
    }

    private double getAverageMinorCompactionPageNum() {
        long curMinorCompactions = this.totalMinorCompactions.get();
        return curMinorCompactions == 0L ? 0.0 : (double)this.totalMinorCompactedPages.get() / (double)curMinorCompactions;
    }

    private double getAverageMajorCompactionPageNum() {
        long curMajorCompactions = this.totalMajorCompactions.get();
        return curMajorCompactions == 0L ? 0.0 : (double)this.totalMajorCompactedPages.get() / (double)curMajorCompactions;
    }

    public void addEvictBlock(int n) {
        this.totalEvictBlockCount.addAndGet(n);
    }

    public void addTotalHugePageSize(int size) {
        this.totalHugePageSize.addAndGet(size);
    }

    public void addTotalHugePageCount(int count) {
        this.totalHugePageCount.addAndGet(count);
    }

    @Override
    public void registerMetrics(MetricGroup metricGroup) {
        metricGroup.gauge("totalPageUsedMemory", () -> this.totalPageUsedMemory.get());
        metricGroup.gauge("totalLogicPageSize", () -> this.totalLogicPageSize.get());
        metricGroup.gauge("totalIndexCapacity", () -> this.totalIndexCapacity.get());
        metricGroup.gauge("totalLogicPageCount", () -> this.totalLogicPageCount.get());
        metricGroup.gauge("averagePageChainLen", () -> this.getAveragePageChainLen());
        metricGroup.gauge("averagePageSize", () -> this.getAveragePageSize());
        metricGroup.gauge("averageMinorCompactionPageNum", () -> this.getAverageMinorCompactionPageNum());
        metricGroup.gauge("averageMajorCompactionPageNum", () -> this.getAverageMajorCompactionPageNum());
        metricGroup.gauge("totalWriteBufferHitCount", () -> this.totalWriteBufferHitCount.get());
        metricGroup.gauge("totalWriteBufferMissCount", () -> this.totalWriteBufferMissCount.get());
        metricGroup.gauge("totalPageCacheHitCount", () -> this.totalPageCacheHitCount.get());
        metricGroup.gauge("totalPageCacheMissCount", () -> this.totalPageCacheMissCount.get());
        metricGroup.gauge("totalPageCacheLRUHitCount", () -> this.totalPageCacheLRUHitCount.get());
        metricGroup.gauge("totalPageCacheEvictSize", () -> this.totalPageCacheEvictSize.get());
        metricGroup.gauge("totalRunningMajorCompaction", () -> this.totalRunningMajorCompaction.get());
        metricGroup.gauge("totalRunningMinorCompaction", () -> this.totalRunningMinorCompaction.get() + this.totalRunningMinorCompactionByRead.get());
        metricGroup.gauge("totalEvictBlockCount", () -> this.totalEvictBlockCount.get());
        metricGroup.gauge("totalLRUPageIntoMainCache", () -> this.totalLruPageIntoMainCache.get());
        metricGroup.gauge("totalLRUPagePreIntoMainCache", () -> this.totalLruPagePreIntoMainCache.get());
    }

    public void addFillPoolTime(long runTime) {
        this.totalFillPoolCount.incrementAndGet();
        this.totalFillPoolTime.addAndGet(runTime);
    }

    public long getTotalFillPoolTime() {
        return this.totalFillPoolTime.get();
    }

    public long getTotalFillPoolCount() {
        return this.totalFillPoolCount.get();
    }

    public void addBloomFilterHitCount() {
        this.totalBloomFilterHitCount.incrementAndGet();
    }

    public void addRunningCompactingPageSize(int i) {
        this.runningCompactingPageSize.addAndGet(i);
    }
}

