/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.gemini.engine.vm;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.annotation.Nullable;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.runtime.state.gemini.engine.GRegionID;
import org.apache.flink.runtime.state.gemini.engine.page.PageContext;
import org.apache.flink.runtime.state.gemini.engine.page.PageIndex;
import org.apache.flink.runtime.state.gemini.engine.vm.FutureDataPage;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataPageLRU<K, V> {
    private static final Logger LOG = LoggerFactory.getLogger(DataPageLRU.class);
    private final int lruSize;
    private final DataPageLRUFuction<V> function;
    private volatile long totalSize = 0L;
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private final Map<K, ListNode> entries;
    private final List<ListNode> headers;
    private final List<ListNode> tailers;
    private final List<Integer> countsPerSlot;
    private final int startRegion;
    private final int slots;
    private int longestSlot;
    private final boolean evenEvict;
    private final boolean accessOrder;

    public DataPageLRU(int startRegionId, int endRegionId, int lruSize, DataPageLRUFuction<V> function) {
        this(startRegionId, endRegionId, lruSize, function, true, true);
    }

    public DataPageLRU(int startRegionId, int endRegionId, int lruSize, DataPageLRUFuction<V> function, boolean accessOrder, boolean evenEvict) {
        int i;
        this.lruSize = lruSize;
        this.function = function;
        this.accessOrder = accessOrder;
        this.startRegion = startRegionId;
        this.evenEvict = evenEvict;
        this.slots = endRegionId - startRegionId + 1;
        this.longestSlot = 0;
        this.entries = new HashMap<K, ListNode>(lruSize);
        this.headers = new ArrayList<ListNode>(this.slots);
        this.tailers = new ArrayList<ListNode>(this.slots);
        for (i = 0; i < this.slots; ++i) {
            this.headers.add(i, new ListNode(null, null));
            this.tailers.add(i, new ListNode(null, null));
            this.headers.get(i).setNext(this.tailers.get(i));
            this.headers.get(i).setPrev(this.tailers.get(i));
            this.tailers.get(i).setNext(this.headers.get(i));
            this.tailers.get(i).setPrev(this.headers.get(i));
        }
        this.countsPerSlot = new ArrayList<Integer>(this.slots);
        for (i = 0; i < this.slots; ++i) {
            this.countsPerSlot.add(i, 0);
        }
        LOG.info("LRU Cache with size {}, accessMode {}, evenEvict {}, region {} -> {}", new Object[]{lruSize, accessOrder, evenEvict, startRegionId, endRegionId});
    }

    public long getTotalSize() {
        return this.totalSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(K key, V value) {
        this.lock.writeLock().lock();
        ListNode prev = this.entries.get(key);
        try {
            if (prev != null) {
                int prevSlot;
                int targetSlot = this.function.getSlotIndex(value, this.startRegion);
                if (targetSlot != (prevSlot = this.function.getSlotIndex(prev.value, this.startRegion))) {
                    this.deleteFromList(prev);
                    this.insertIntoHead(targetSlot, prev);
                    if (this.longestSlot == prevSlot && this.countsPerSlot.get(targetSlot) > this.countsPerSlot.get(prevSlot)) {
                        this.longestSlot = targetSlot;
                    }
                }
                prev.setValue(value);
                return;
            }
            if (this.entries.size() >= this.lruSize) {
                ListNode deleteNode = this.tailers.get(this.longestSlot).prev;
                this.deleteFromList(deleteNode);
                this.entries.remove(deleteNode.key);
                this.function.removed(deleteNode.value);
                deleteNode.value = null;
                deleteNode = null;
            }
            prev = new ListNode(key, value);
            this.entries.put(key, prev);
            int targetSlot = this.function.getSlotIndex(prev.value, this.startRegion);
            this.insertIntoHead(targetSlot, prev);
            if (this.countsPerSlot.get(targetSlot) > this.countsPerSlot.get(this.longestSlot)) {
                this.longestSlot = targetSlot;
            }
            if (this.evenEvict && this.countsPerSlot.get(this.longestSlot) == 1 && this.entries.size() > 2) {
                this.longestSlot = ThreadLocalRandom.current().nextInt(this.slots);
                while (this.countsPerSlot.get(this.longestSlot) == 0) {
                    this.longestSlot = ThreadLocalRandom.current().nextInt(this.slots);
                }
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public int size() {
        return this.entries.size();
    }

    private void insertIntoHead(int index, ListNode node) {
        ListNode currentHeader = this.headers.get(index);
        node.setPrev(currentHeader);
        node.setNext(currentHeader.next);
        currentHeader.next.setPrev(node);
        currentHeader.setNext(node);
        this.totalSize += (long)this.function.size(node.value);
        this.countsPerSlot.set(index, this.countsPerSlot.get(index) + 1);
    }

    private void deleteFromList(ListNode node) {
        node.prev.setNext(node.next);
        node.next.setPrev(node.prev);
        this.totalSize -= (long)this.function.size(node.value);
        int slot = this.function.getSlotIndex(node.value, this.startRegion);
        this.countsPerSlot.set(slot, this.countsPerSlot.get(slot) - 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V get(K key) {
        Lock curretLock = this.accessOrder ? this.lock.writeLock() : this.lock.readLock();
        curretLock.lock();
        try {
            ListNode listNode = this.entries.get(key);
            if (listNode != null) {
                if (this.accessOrder) {
                    this.deleteFromList(listNode);
                    this.insertIntoHead(this.function.getSlotIndex(listNode.value, this.startRegion), listNode);
                }
                Object object = listNode.value;
                return (V)object;
            }
            V v = null;
            return v;
        }
        finally {
            curretLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(K key) {
        this.lock.writeLock().lock();
        try {
            ListNode prev = this.entries.remove(key);
            if (prev == null) {
                boolean bl = false;
                return bl;
            }
            this.deleteFromList(prev);
            this.function.removed(prev.value);
            prev = null;
            boolean bl = true;
            return bl;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Tuple2<K, V> getHottestPage(GRegionID regionID, PageIndex currentPageIndex) {
        int slotId = regionID.getId() - this.startRegion;
        this.lock.readLock().lock();
        try {
            ListNode currentNode = this.headers.get(slotId).next;
            ListNode tailNode = this.tailers.get(slotId);
            while (!currentNode.equals(tailNode)) {
                if (!this.function.canAddIntoMainCache(currentNode.value, currentPageIndex, regionID)) {
                    currentNode = currentNode.next;
                    continue;
                }
                Tuple2 tuple2 = Tuple2.of((Object)currentNode.key, (Object)currentNode.value);
                return tuple2;
            }
            Tuple2<K, V> tuple2 = null;
            return tuple2;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @VisibleForTesting
    public Map<K, ListNode> getEntries() {
        return Collections.unmodifiableMap(this.entries);
    }

    @VisibleForTesting
    public int getItemNumInSlot(int slot) {
        Preconditions.checkArgument((slot >= 0 && slot < this.slots ? 1 : 0) != 0);
        int count = 0;
        ListNode currentTailNode = this.tailers.get(slot).prev;
        while (!this.headers.get(slot).equals(currentTailNode)) {
            ++count;
            currentTailNode = currentTailNode.prev;
        }
        return count;
    }

    public void clear() {
        this.lock.writeLock().lock();
        try {
            for (ListNode value : this.entries.values()) {
                this.totalSize -= (long)this.function.size(value.value);
                this.function.removed(value.value);
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    private class ListNode {
        private ListNode prev;
        private ListNode next;
        private final K key;
        private V value;

        public ListNode(K key, V value) {
            this.key = key;
            this.value = value;
            this.prev = null;
            this.next = null;
        }

        public void setPrev(ListNode newPrev) {
            this.prev = newPrev;
        }

        public void setNext(ListNode newNext) {
            this.next = newNext;
        }

        private void setValue(V newValue) {
            this.value = newValue;
        }

        public int hashCode() {
            return this.key.hashCode() * 31 + this.value.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            ListNode other = (ListNode)obj;
            return Objects.equals(this.key, other.key) && Objects.equals(this.value, other.value);
        }
    }

    public static class PageWithContext {
        @Nullable
        private final PageContext pageContext;
        private final FutureDataPage futureDataPage;

        public PageWithContext(@Nullable PageContext pageContext, FutureDataPage futureDataPage) {
            this.pageContext = pageContext;
            this.futureDataPage = (FutureDataPage)Preconditions.checkNotNull((Object)futureDataPage);
        }

        public FutureDataPage getFutureDataPage() {
            return this.futureDataPage;
        }

        @Nullable
        public PageContext getPageContext() {
            return this.pageContext;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            PageWithContext other = (PageWithContext)obj;
            return Objects.equals(this.pageContext, other.pageContext) && Objects.equals(this.futureDataPage, other.futureDataPage);
        }

        public int hashCode() {
            int hashCode2 = this.pageContext == null ? 0 : this.pageContext.hashCode();
            hashCode2 = hashCode2 * 31 + this.futureDataPage.hashCode();
            return hashCode2;
        }
    }

    public static interface DataPageLRUFuction<T> {
        public int size(T var1);

        public void removed(T var1);

        public int getSlotIndex(T var1, int var2);

        public boolean canAddIntoMainCache(T var1, PageIndex var2, GRegionID var3);
    }
}

