/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.gemini.engine.vm;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.runtime.state.gemini.engine.GRegion;
import org.apache.flink.runtime.state.gemini.engine.GTable;
import org.apache.flink.runtime.state.gemini.engine.dbms.GContext;
import org.apache.flink.runtime.state.gemini.engine.exceptions.GeminiShutDownException;
import org.apache.flink.runtime.state.gemini.engine.page.LogicalPageChain;
import org.apache.flink.runtime.state.gemini.engine.page.PageAddress;
import org.apache.flink.runtime.state.gemini.engine.vm.CacheManager;
import org.apache.flink.runtime.state.gemini.engine.vm.EvictHandlerSepImpl;
import org.apache.flink.runtime.state.gemini.engine.vm.EvictPolicy;
import org.apache.flink.shaded.netty4.io.netty.util.concurrent.EventExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EvictPolicySepImpl
implements EvictPolicy {
    private static final Logger LOG = LoggerFactory.getLogger(EvictPolicySepImpl.class);
    private final CacheManager cacheManager;
    private final GContext gContext;
    private final Map<EventExecutor, EvictHandlerSepImpl> evictHandlerMap = new HashMap<EventExecutor, EvictHandlerSepImpl>();
    private final Object printObject = new Object();
    private final long loopInterval = 1000L;
    private final int printTick;
    private final boolean printAuditInfo;
    private final int maxChainLen;
    private final DeltaAndTotalAverage cacheHitRatio = new DeltaAndTotalAverage();
    private final DeltaAndTotalAverage subPageCacheHitRatio = new DeltaAndTotalAverage();
    private final DeltaAndTotalAverage fillPoolLatency = new DeltaAndTotalAverage();

    public EvictPolicySepImpl(GContext gContext, CacheManager cacheManager) {
        this.gContext = gContext;
        this.cacheManager = cacheManager;
        this.maxChainLen = gContext.getGConfiguration().getMaxCompactionThreshold();
        this.printTick = gContext.getGConfiguration().geVmPrintTick();
        this.printAuditInfo = gContext.getGConfiguration().geVmPrintAuditInfo();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        int tick = 0;
        while (this.gContext.isDBNormal()) {
            try {
                if (tick++ >= this.printTick) {
                    this.cacheHitRatio.calc(this.cacheManager.getCacheStats().getPageCacheHitCount(), this.cacheManager.getCacheStats().getPageCacheRequestCount());
                    this.subPageCacheHitRatio.calc(this.cacheManager.getCacheStats().getSubPageCacheHitCount(), this.cacheManager.getCacheStats().getSubPageCacheRequestCount());
                    this.fillPoolLatency.calc(this.cacheManager.getCacheStats().getTotalFillPoolTime(), this.cacheManager.getCacheStats().getTotalFillPoolCount());
                    this.evictHandlerMap.values().forEach(handler -> LOG.info("Thread Mem WM {}", handler));
                    LOG.info("Mem WM:{}, Index WM:{}  {}  {} CacheHitRatio=[{}/{},{}/{}] fillPool[{} {}/{}] ReadPageLRUSize={}/{} fileSize={}/{} Allocator1={} Allocator2={} {} {} {}", new Object[]{this.cacheManager.getMemWaterMark(0), this.cacheManager.getIndexCapacityWaterMark(), this.cacheManager.getCacheStats(), this.gContext.getSupervisor().getWriteBufferManager(), String.format("%.2f", Float.valueOf(this.cacheHitRatio.deltaRatio)), String.format("%.2f", Float.valueOf(this.cacheHitRatio.totalRatio)), String.format("%.2f", Float.valueOf(this.subPageCacheHitRatio.deltaRatio)), String.format("%.2f", Float.valueOf(this.subPageCacheHitRatio.totalRatio)), this.cacheManager.getCacheStats().getTotalFillPoolCount(), String.format("%.2f", Float.valueOf(this.fillPoolLatency.deltaRatio)), String.format("%.2f", Float.valueOf(this.fillPoolLatency.totalRatio)), this.gContext.getSupervisor().getFetchPolicy().getDataPageLRU().getTotalSize(), this.gContext.getSupervisor().getFetchPolicy().getDataPageLRU().size(), this.gContext.getSupervisor().getFileCache().getFileCacheStat().totalLocalWriteSize, this.gContext.getSupervisor().getFileCache().getFileCacheStat().totalLocalOriDataSize, this.gContext.getSupervisor().getAllocator(), this.gContext.getSupervisor().getForReadAllocator(), this.gContext.getSupervisor().getPersistencyStrategy().toString(), this.gContext.getSupervisor().getBloomFilterManager(), this.debugInfo()});
                    LOG.info("NoCriticalEvent count {}, lastTimestamp {}.", new Object[]{this.gContext.getNoCriticalEvent().getCount(), this.gContext.getNoCriticalEvent().getLastTimestamp(), this.gContext.getNoCriticalEvent().getLastException()});
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("ExecutorGroup region {}  compaction {} flush {} lru {} snapshot {}", new Object[]{this.gContext.getSupervisor().getRegionExecutorGroup().toString(), this.gContext.getSupervisor().getCompactionExecutorGroup().toString(), this.gContext.getSupervisor().getFlushExecutorGroup().toString(), this.gContext.getSupervisor().getLruIntoMainCacheExecutorGroup().toString(), this.gContext.getSupervisor().getSnapshotExecutorGroup().toString()});
                    }
                    tick = 0;
                }
                Object object = this.printObject;
                synchronized (object) {
                    this.printObject.wait(1000L);
                }
            }
            catch (GeminiShutDownException ie) {
                LOG.debug("DB is in abnormal status " + this.gContext.getDBStatus().name());
            }
            catch (Exception e) {
                LOG.error("EvictPolicy has Exception={}", (Object)e.getMessage(), (Object)e);
            }
        }
    }

    private String debugInfo() {
        if (!this.printAuditInfo) {
            return "";
        }
        long totalPageSize = 0L;
        long totalPageInMemSize = 0L;
        long totalBiggerThanMaxChainLenMemSize = 0L;
        int longestChainLen = 0;
        for (GTable gTable : this.gContext.getSupervisor().getAllTables().values()) {
            Iterator<GRegion> regionIterator = gTable.regionIterator();
            while (regionIterator.hasNext()) {
                LogicalPageChain[] logicalPageChains;
                GRegion gRegion = regionIterator.next();
                for (LogicalPageChain logicalPageChain : logicalPageChains = gRegion.getPageStore().getPageIndex().getPageIndex()) {
                    if (logicalPageChain == null) continue;
                    if (longestChainLen < logicalPageChain.getCurrentPageChainIndex() + 1) {
                        longestChainLen = logicalPageChain.getCurrentPageChainIndex() + 1;
                    }
                    for (int i = 0; i <= logicalPageChain.getCurrentPageChainIndex(); ++i) {
                        Iterator<PageAddress> pageAddressIterator = logicalPageChain.getPageAddress(i).pageIterator();
                        while (pageAddressIterator.hasNext()) {
                            PageAddress pageAddress = pageAddressIterator.next();
                            totalPageSize += (long)pageAddress.getDataLen();
                            totalPageInMemSize += (long)pageAddress.getMemorySize();
                            if (i < this.maxChainLen) continue;
                            totalBiggerThanMaxChainLenMemSize += (long)pageAddress.getMemorySize();
                        }
                    }
                }
            }
        }
        return String.format("debug:totalPageSize=%s/totalPageInMemSize=%s/totalBiggerThanMaxChainLenMemSize=%s/longestChainLen=%s", totalPageSize, totalPageInMemSize, totalBiggerThanMaxChainLenMemSize, longestChainLen);
    }

    @Override
    public EvictHandlerSepImpl getEvictHandlerSepImpl(GRegion gRegion) {
        return this.evictHandlerMap.get(gRegion.getExecutor());
    }

    @Override
    public void addPage(GRegion gRegion, PageAddress pageAddress) {
        this.evictHandlerMap.get(gRegion.getExecutor()).addPage(pageAddress, gRegion);
    }

    @Override
    public int removeInvalidPage(GRegion gRegion, PageAddress pageAddress) {
        return this.evictHandlerMap.get(gRegion.getExecutor()).removeInvalidPage(pageAddress);
    }

    @Override
    public void addPageUsedMemory(GRegion gRegion, EventExecutor regionEventExecutor, int logicPageSize, boolean needEvict) {
        this.evictHandlerMap.get(regionEventExecutor).addPageUsedMemory(logicPageSize, needEvict);
    }

    @Override
    public void tryPrepareFlush(GRegion gRegion, int minSize) {
        this.evictHandlerMap.get(gRegion.getExecutor()).tryPrepareFlush(minSize);
    }

    @Override
    public EvictPolicy.MemoryUsedWaterMark getMemoryUsedWaterMark(GRegion gRegion, int addSize) {
        return this.evictHandlerMap.get(gRegion.getExecutor()).getMemoryUsedWaterMark(addSize);
    }

    @Override
    public void addRegion(GRegion gRegion) {
        this.evictHandlerMap.computeIfAbsent(gRegion.getExecutor(), nothing -> new EvictHandlerSepImpl(gRegion.getExecutor().toString(), this.gContext));
        this.evictHandlerMap.get(gRegion.getExecutor()).addRegion(gRegion);
    }

    @VisibleForTesting
    public void addRegionEventExecutor(EventExecutor regionEventExecutor, EvictHandlerSepImpl evictHandlerSep) {
        this.evictHandlerMap.putIfAbsent(regionEventExecutor, evictHandlerSep);
    }

    @Override
    public void shutdown() {
        this.evictHandlerMap.values().forEach(EvictHandlerSepImpl::shutdown);
    }

    private static class DeltaAndTotalAverage {
        long lastValue = 0L;
        long lastTotal = 0L;
        float deltaRatio;
        float totalRatio;

        private DeltaAndTotalAverage() {
        }

        void calc(long curValue, long curTotal) {
            long deltaValue = curValue - this.lastValue;
            long delaTotal = curTotal - this.lastTotal;
            this.deltaRatio = delaTotal == 0L ? -1.0f : (float)deltaValue / (float)delaTotal;
            this.totalRatio = curTotal == 0L ? -1.0f : (float)curValue / (float)curTotal;
            this.lastValue = curValue;
            this.lastTotal = curTotal;
        }
    }
}

