/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.gemini.engine.vm;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.apache.flink.runtime.state.gemini.engine.exceptions.GeminiRuntimeException;
import org.apache.flink.runtime.state.gemini.engine.rm.GByteBuffer;

public class FutureDataPage {
    private final int size;
    private final CompletableFuture<GByteBuffer> dataPageCompletedFuture;
    private volatile boolean removed = false;

    public FutureDataPage(int size) {
        this.size = size;
        this.dataPageCompletedFuture = new CompletableFuture();
    }

    FutureDataPage(GByteBuffer gByteBuffer) {
        this.size = gByteBuffer.capacity();
        this.dataPageCompletedFuture = CompletableFuture.completedFuture(gByteBuffer);
        gByteBuffer.retain();
    }

    public int getSize() {
        return this.size;
    }

    public boolean complete(GByteBuffer gByteBuffer) {
        boolean result = this.dataPageCompletedFuture.complete(gByteBuffer);
        if (result && !this.removed) {
            gByteBuffer.retain();
        }
        return result;
    }

    public void completeExceptionally(Throwable throwable) {
        this.dataPageCompletedFuture.completeExceptionally(throwable);
    }

    public GByteBuffer get() {
        try {
            return this.dataPageCompletedFuture.get();
        }
        catch (Exception e) {
            throw new GeminiRuntimeException("FutureDataPage error:" + e.getMessage(), e);
        }
    }

    public GByteBuffer get(int timeout) {
        try {
            return this.dataPageCompletedFuture.get(timeout, TimeUnit.MILLISECONDS);
        }
        catch (Exception e) {
            throw new GeminiRuntimeException("FutureDataPage error, Msg=" + e.getMessage() + " ,cause=" + e.getClass().getSimpleName(), e);
        }
    }

    public boolean isFail() {
        return this.dataPageCompletedFuture.isCompletedExceptionally();
    }

    public boolean isDone() {
        return this.dataPageCompletedFuture.isDone();
    }

    public void removed() {
        if (this.removed) {
            return;
        }
        this.removed = true;
        if (this.isDone() && !this.isFail()) {
            try {
                GByteBuffer gByteBuffer = this.dataPageCompletedFuture.get();
                gByteBuffer.release();
            }
            catch (Exception e) {
                throw new GeminiRuntimeException(e);
            }
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        FutureDataPage other = (FutureDataPage)obj;
        return this.size == other.size && this.dataPageCompletedFuture.equals(other.dataPageCompletedFuture) && this.removed == other.removed;
    }

    public int hashCode() {
        int hashCode2 = this.size;
        hashCode2 = hashCode2 * 31 + this.dataPageCompletedFuture.hashCode();
        hashCode2 = hashCode2 * 31 + (this.removed ? 1 : 0);
        return hashCode2;
    }
}

