/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.gemini.engine.vm;

import java.util.Arrays;
import org.apache.flink.annotation.VisibleForTesting;

public class HitRecord {
    private long currentAgeTimeTick;
    private int[] ages = new int[4];
    private byte currentAgeCusor;

    public HitRecord() {
        for (int i = 0; i < this.ages.length; ++i) {
            this.ages[i] = -1;
        }
        this.currentAgeCusor = (byte)3;
        this.currentAgeTimeTick = -1L;
    }

    public float score(long curAgeTimeTick, int size, int chainIndex) {
        if (this.currentAgeTimeTick < curAgeTimeTick) {
            this.addRequestCount(curAgeTimeTick, 0);
        }
        byte ageCusor = this.prevCusor(this.currentAgeCusor);
        int a3 = this.ages[ageCusor];
        ageCusor = this.prevCusor(ageCusor);
        int a2 = this.ages[ageCusor];
        int a1 = this.ages[ageCusor = this.prevCusor(ageCusor)];
        if (a1 == -1 && a2 == -1 && a3 == -1) {
            return Float.MAX_VALUE / (float)size * (float)(1 + chainIndex);
        }
        if (a1 == -1 && a2 == -1) {
            return (float)a3 * 100.0f / (float)size * (float)(1 + chainIndex);
        }
        if (a1 == -1) {
            return (float)(a3 * 60 + a2 * 40) / (float)size * (float)(1 + chainIndex);
        }
        return (float)(a3 * 50 + a2 * 30 + a1 * 20) / (float)size * (float)(1 + chainIndex);
    }

    public void addRequestCount(long curAgeTimeTick, int requestCount) {
        if (this.currentAgeTimeTick == -1L) {
            this.currentAgeTimeTick = curAgeTimeTick;
            this.ages[this.currentAgeCusor] = requestCount;
        } else if (this.currentAgeTimeTick == curAgeTimeTick) {
            byte by = this.currentAgeCusor;
            this.ages[by] = this.ages[by] + requestCount;
        } else if (curAgeTimeTick <= this.currentAgeTimeTick + (long)(this.ages.length - 1)) {
            while (this.currentAgeTimeTick < curAgeTimeTick - 1L) {
                this.currentAgeCusor = this.nextCusor(this.currentAgeCusor);
                this.ages[this.currentAgeCusor] = 0;
                ++this.currentAgeTimeTick;
            }
            this.currentAgeTimeTick = curAgeTimeTick;
            this.currentAgeCusor = this.nextCusor(this.currentAgeCusor);
            this.ages[this.currentAgeCusor] = requestCount;
        } else {
            for (int i = 0; i < this.ages.length - 1; ++i) {
                this.ages[i] = 0;
            }
            this.currentAgeTimeTick = curAgeTimeTick;
            this.currentAgeCusor = (byte)(this.ages.length - 1);
            this.ages[this.currentAgeCusor] = requestCount;
        }
    }

    @VisibleForTesting
    public byte nextCusor(byte currentAgeCusor) {
        return currentAgeCusor + 1 == this.ages.length ? (byte)0 : (byte)(currentAgeCusor + 1);
    }

    @VisibleForTesting
    public byte prevCusor(byte currentAgeCusor) {
        return currentAgeCusor == 0 ? (byte)(this.ages.length - 1) : (byte)(currentAgeCusor - 1);
    }

    public long getRequestCount(long curAgeTimeTick) {
        if (this.currentAgeTimeTick < curAgeTimeTick) {
            this.addRequestCount(curAgeTimeTick, 0);
        }
        return Arrays.stream(this.ages).filter(value -> value != -1).sum();
    }

    @VisibleForTesting
    public long getCurrentAgeTimeTick() {
        return this.currentAgeTimeTick;
    }

    @VisibleForTesting
    public byte getCurrentAgeCusor() {
        return this.currentAgeCusor;
    }

    @VisibleForTesting
    public int[] getAges() {
        return this.ages;
    }
}

