/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.gemini.internal;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Objects;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.core.fs.FSDataInputStream;
import org.apache.flink.core.fs.Path;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataInputViewStreamWrapper;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.core.memory.DataOutputViewStreamWrapper;
import org.apache.flink.runtime.state.KeyGroupRange;
import org.apache.flink.runtime.state.KeyedStateHandle;
import org.apache.flink.runtime.state.SharedStateRegistry;
import org.apache.flink.runtime.state.SharedStateRegistryKey;
import org.apache.flink.runtime.state.StreamStateHandle;
import org.apache.flink.runtime.state.gemini.engine.snapshot.DBSnapshotMeta;
import org.apache.flink.runtime.state.gemini.engine.snapshot.DBSnapshotMetaSerializer;
import org.apache.flink.runtime.state.gemini.internal.AbstractGeminiKeyedStateHandle;
import org.apache.flink.runtime.state.gemini.internal.DirectoryStreamStateHandle;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeminiKeyedStateHandle
extends AbstractGeminiKeyedStateHandle
implements StreamStateHandle {
    private static final Logger LOG = LoggerFactory.getLogger(GeminiKeyedStateHandle.class);
    private static final long serialVersionUID = 1L;
    private transient SharedStateRegistry sharedStateRegistry;

    public GeminiKeyedStateHandle(long checkpointId, KeyGroupRange keyGroupRange, StreamStateHandle metaStateHandle, DirectoryStreamStateHandle dbSnapshotDirectoryHandle, DBSnapshotMeta dbSnapshotMeta) {
        super(checkpointId, keyGroupRange, metaStateHandle, dbSnapshotDirectoryHandle, dbSnapshotMeta);
    }

    @Override
    public KeyedStateHandle getIntersection(KeyGroupRange otherKeyGroupRange) {
        return KeyGroupRange.EMPTY_KEY_GROUP_RANGE.equals(this.keyGroupRange.getIntersection(otherKeyGroupRange)) ? null : this;
    }

    @Override
    public void registerSharedStates(SharedStateRegistry stateRegistry) {
        Preconditions.checkState((this.sharedStateRegistry != stateRegistry ? 1 : 0) != 0, (Object)"The state handle has already registered its shared states to the given registry.");
        this.sharedStateRegistry = (SharedStateRegistry)Preconditions.checkNotNull((Object)stateRegistry);
        LOG.trace("Registering GeminiKeyedStateHandle for checkpoint {} from backend.", (Object)this.checkpointId);
        stateRegistry.registerReference(GeminiKeyedStateHandle.createStateRegistryKey(this.dbSnapshotDirectoryHandle), this.dbSnapshotDirectoryHandle);
    }

    @Override
    public void discardState() throws Exception {
        SharedStateRegistry registry = this.sharedStateRegistry;
        boolean isRegistered = registry != null;
        LOG.trace("Discarding GeminiKeyedStateHandle (registered = {}) for checkpoint {} from backend.", (Object)isRegistered, (Object)this.checkpointId);
        try {
            this.metaStateHandle.discardState();
        }
        catch (Exception e) {
            LOG.warn("Could not properly discard meta data.", (Throwable)e);
        }
        if (isRegistered) {
            registry.unregisterReference(new SharedStateRegistryKey(this.dbSnapshotDirectoryHandle.getDirectory().toUri().toString()));
        }
    }

    @Override
    public FSDataInputStream openInputStream() throws IOException {
        Preconditions.checkNotNull((Object)this.metaStateHandle, (String)"metaStateHandle is null");
        return this.metaStateHandle.openInputStream();
    }

    @VisibleForTesting
    public static SharedStateRegistryKey createStateRegistryKey(DirectoryStreamStateHandle dbSnapshotDirectoryHandle) {
        return new SharedStateRegistryKey(dbSnapshotDirectoryHandle.getDirectory().toUri().toString());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GeminiKeyedStateHandle that = (GeminiKeyedStateHandle)o;
        return this.checkpointId == that.checkpointId && Objects.equals(this.keyGroupRange, that.keyGroupRange) && Objects.equals(this.metaStateHandle, that.metaStateHandle) && Objects.equals(this.dbSnapshotDirectoryHandle, that.dbSnapshotDirectoryHandle) && Objects.equals(this.dbSnapshotMeta, that.dbSnapshotMeta);
    }

    public int hashCode() {
        int result = Objects.hashCode(this.keyGroupRange);
        result = 31 * result + (int)(this.getCheckpointId() ^ this.getCheckpointId() >>> 32);
        result = 31 * result + Objects.hashCode(this.metaStateHandle);
        result = 31 * result + Objects.hashCode(this.dbSnapshotDirectoryHandle);
        result = 31 * result + Objects.hashCode(this.dbSnapshotMeta);
        return result;
    }

    public String toString() {
        return "GeminiKeyedStateHandle {checkpointId=" + this.checkpointId + ", keyGroupRange=" + this.keyGroupRange + ", metaStateHandle=" + this.metaStateHandle + ", dbSnapshotDirectoryHandle=" + this.dbSnapshotDirectoryHandle + ", dbSnapshotMeta=" + this.dbSnapshotMeta + "}";
    }

    public static void serializeDBPart(GeminiKeyedStateHandle stateHandle, DataOutputStream dos) throws IOException {
        String dbSnapshotDirectory = stateHandle.getDBSnapshotDirectoryHandle().getDirectory().toUri().toString();
        dos.writeUTF(dbSnapshotDirectory);
        DBSnapshotMeta dbSnapshotMeta = stateHandle.getDBSnapshotMeta();
        DBSnapshotMetaSerializer.INSTANCE.serialize(dbSnapshotMeta, (DataOutputView)new DataOutputViewStreamWrapper((OutputStream)dos));
    }

    public static GeminiKeyedStateHandle deserializeDBPartAndCreateStateHandle(long checkpointId, KeyGroupRange keyGroupRange, StreamStateHandle metaStateHandle, DataInputStream dis) throws IOException {
        String dbSnapshotDirectory = dis.readUTF();
        DBSnapshotMeta dbSnapshotMeta = DBSnapshotMetaSerializer.INSTANCE.deserialize((DataInputView)new DataInputViewStreamWrapper((InputStream)dis));
        return new GeminiKeyedStateHandle(checkpointId, keyGroupRange, metaStateHandle, new DirectoryStreamStateHandle(new Path(dbSnapshotDirectory)), dbSnapshotMeta);
    }
}

