/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.gemini.internal;

import java.util.Objects;
import org.apache.flink.runtime.state.KeyGroupRange;
import org.apache.flink.runtime.state.KeyedStateHandle;
import org.apache.flink.runtime.state.SharedStateRegistry;
import org.apache.flink.runtime.state.StreamStateHandle;
import org.apache.flink.runtime.state.gemini.engine.snapshot.DBSnapshotMeta;
import org.apache.flink.runtime.state.gemini.internal.AbstractGeminiKeyedStateHandle;
import org.apache.flink.runtime.state.gemini.internal.DirectoryStreamStateHandle;
import org.apache.flink.util.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeminiLocalKeyedStateHandle
extends AbstractGeminiKeyedStateHandle {
    private static final Logger LOG = LoggerFactory.getLogger(GeminiLocalKeyedStateHandle.class);
    private static final long serialVersionUID = 1L;

    public GeminiLocalKeyedStateHandle(long checkpointId, KeyGroupRange keyGroupRange, StreamStateHandle metaStateHandle, DirectoryStreamStateHandle dbSnapshotDirectoryHandle, DBSnapshotMeta dbSnapshotMeta) {
        super(checkpointId, keyGroupRange, metaStateHandle, dbSnapshotDirectoryHandle, dbSnapshotMeta);
    }

    @Override
    public KeyedStateHandle getIntersection(KeyGroupRange otherKeyGroupRange) {
        return this.keyGroupRange.getIntersection(otherKeyGroupRange).getNumberOfKeyGroups() > 0 ? this : null;
    }

    @Override
    public void registerSharedStates(SharedStateRegistry stateRegistry) {
    }

    @Override
    public void discardState() throws Exception {
        Exception collectedEx = null;
        try {
            this.metaStateHandle.discardState();
        }
        catch (Exception e) {
            collectedEx = e;
        }
        try {
            this.dbSnapshotDirectoryHandle.discardState();
        }
        catch (Exception e) {
            collectedEx = (Exception)ExceptionUtils.firstOrSuppressed((Throwable)e, (Throwable)collectedEx);
        }
        if (collectedEx != null) {
            throw collectedEx;
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GeminiLocalKeyedStateHandle that = (GeminiLocalKeyedStateHandle)o;
        return this.checkpointId == that.checkpointId && Objects.equals(this.keyGroupRange, that.keyGroupRange) && Objects.equals(this.metaStateHandle, that.metaStateHandle) && Objects.equals(this.dbSnapshotDirectoryHandle, that.dbSnapshotDirectoryHandle) && Objects.equals(this.dbSnapshotMeta, that.dbSnapshotMeta);
    }

    public int hashCode() {
        int result = Objects.hashCode(this.keyGroupRange);
        result = 31 * result + (int)(this.getCheckpointId() ^ this.getCheckpointId() >>> 32);
        result = 31 * result + Objects.hashCode(this.metaStateHandle);
        result = 31 * result + Objects.hashCode(this.dbSnapshotDirectoryHandle);
        result = 31 * result + Objects.hashCode(this.dbSnapshotMeta);
        return result;
    }

    public String toString() {
        return "GeminiLocalKeyedStateHandle {checkpointId=" + this.checkpointId + ", keyGroupRange=" + this.keyGroupRange + ", metaStateHandle=" + this.metaStateHandle + ", dbSnapshotDirectoryHandle=" + this.dbSnapshotDirectoryHandle + ", dbSnapshotMeta=" + this.dbSnapshotMeta + "}";
    }
}

