/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.gemini.keyed;

import java.util.Iterator;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.runtime.state.gemini.engine.hashtable.AbstractGTableKeyedMapImpl;
import org.apache.flink.runtime.state.gemini.engine.hashtable.GRegionKSortedMapImpl;
import org.apache.flink.runtime.state.gemini.keyed.AbstractGeminiKeyedMapStateImpl;
import org.apache.flink.runtime.state.keyed.KeyedSortedMapState;
import org.apache.flink.runtime.state.keyed.KeyedSortedMapStateDescriptor;
import org.apache.flink.runtime.state.keyed.KeyedStateDescriptor;
import org.apache.flink.util.Preconditions;

public final class GeminiKeyedSortedMapStateImpl<K, MK, MV>
extends AbstractGeminiKeyedMapStateImpl<K, MK, MV, SortedMap<MK, MV>>
implements KeyedSortedMapState<K, MK, MV> {
    private KeyedSortedMapStateDescriptor<K, MK, MV> stateDescriptor;

    public GeminiKeyedSortedMapStateImpl(KeyedSortedMapStateDescriptor<K, MK, MV> descriptor, AbstractGTableKeyedMapImpl<K, MK, MV> table) {
        super(table);
        this.stateDescriptor = (KeyedSortedMapStateDescriptor)Preconditions.checkNotNull(descriptor);
    }

    @Override
    SortedMap<MK, MV> createMap() {
        return new TreeMap();
    }

    @Override
    public KeyedStateDescriptor getDescriptor() {
        return this.stateDescriptor;
    }

    @Override
    public byte[] getSerializedValue(byte[] serializedKeyAndNamespace, TypeSerializer<K> safeKeySerializer, TypeSerializer<SortedMap<MK, MV>> safeValueSerializer) throws Exception {
        return new byte[0];
    }

    @Override
    public Map.Entry<MK, MV> firstEntry(K key) {
        if (key == null) {
            return null;
        }
        GRegionKSortedMapImpl region = (GRegionKSortedMapImpl)this.getRegion(key);
        return region.firstEntry(key);
    }

    @Override
    public Map.Entry<MK, MV> lastEntry(K key) {
        if (key == null) {
            return null;
        }
        GRegionKSortedMapImpl region = (GRegionKSortedMapImpl)this.getRegion(key);
        return region.lastEntry(key);
    }

    @Override
    public Iterator<Map.Entry<MK, MV>> headIterator(K key, MK endMapKey) {
        if (key == null || endMapKey == null) {
            return null;
        }
        GRegionKSortedMapImpl region = (GRegionKSortedMapImpl)this.getRegion(key);
        return new AbstractGeminiKeyedMapStateImpl.IteratorWrapper(this, key, region.headIterator(key, endMapKey));
    }

    @Override
    public Iterator<Map.Entry<MK, MV>> tailIterator(K key, MK startMapKey) {
        if (key == null || startMapKey == null) {
            return null;
        }
        GRegionKSortedMapImpl region = (GRegionKSortedMapImpl)this.getRegion(key);
        return new AbstractGeminiKeyedMapStateImpl.IteratorWrapper(this, key, region.tailIterator(key, startMapKey));
    }

    @Override
    public Iterator<Map.Entry<MK, MV>> subIterator(K key, MK startMapKey, MK endMapKey) {
        if (key == null || startMapKey == null || endMapKey == null) {
            return null;
        }
        GRegionKSortedMapImpl region = (GRegionKSortedMapImpl)this.getRegion(key);
        return new AbstractGeminiKeyedMapStateImpl.IteratorWrapper(this, key, region.subIterator(key, startMapKey, endMapKey));
    }
}

