/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.heap;

import java.util.Collection;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.flink.runtime.state.InternalPriorityQueue;
import org.apache.flink.runtime.state.heap.HeapPriorityQueueElement;
import org.apache.flink.util.CloseableIterator;
import org.apache.flink.util.FlinkRuntimeException;

public class CachingInternalPriorityQueueSet<E>
implements InternalPriorityQueue<E>,
HeapPriorityQueueElement {
    @Nonnull
    private final OrderedSetCache<E> orderedCache;
    @Nonnull
    private final OrderedSetStore<E> orderedStore;
    private boolean storeOnlyElements;
    private int pqManagedIndex;

    public CachingInternalPriorityQueueSet(@Nonnull OrderedSetCache<E> orderedCache, @Nonnull OrderedSetStore<E> orderedStore) {
        this.orderedCache = orderedCache;
        this.orderedStore = orderedStore;
        this.storeOnlyElements = true;
        this.pqManagedIndex = Integer.MIN_VALUE;
    }

    @Override
    @Nullable
    public E peek() {
        this.checkRefillCacheFromStore();
        return this.orderedCache.peekFirst();
    }

    @Override
    public void bulkPoll(@Nonnull Predicate<E> canConsume, @Nonnull Consumer<E> consumer) {
        E element;
        while ((element = this.peek()) != null && canConsume.test(element)) {
            this.poll();
            consumer.accept(element);
        }
    }

    @Override
    @Nullable
    public E poll() {
        this.checkRefillCacheFromStore();
        E first = this.orderedCache.removeFirst();
        if (first != null) {
            this.orderedStore.remove(first);
        }
        return first;
    }

    @Override
    public boolean add(@Nonnull E toAdd) {
        this.checkRefillCacheFromStore();
        this.orderedStore.add(toAdd);
        boolean cacheFull = this.orderedCache.isFull();
        if (!cacheFull && !this.storeOnlyElements || this.orderedCache.isInLowerBound(toAdd)) {
            if (cacheFull) {
                this.orderedCache.removeLast();
                this.storeOnlyElements = true;
            }
            this.orderedCache.add(toAdd);
            return toAdd.equals(this.orderedCache.peekFirst());
        }
        this.storeOnlyElements = true;
        return false;
    }

    @Override
    public boolean remove(@Nonnull E toRemove) {
        this.checkRefillCacheFromStore();
        boolean newHead = toRemove.equals(this.orderedCache.peekFirst());
        this.orderedStore.remove(toRemove);
        this.orderedCache.remove(toRemove);
        return newHead;
    }

    @Override
    public void addAll(@Nullable Collection<? extends E> toAdd) {
        if (toAdd == null) {
            return;
        }
        for (E element : toAdd) {
            this.add(element);
        }
    }

    @Override
    public int size() {
        return this.orderedStore.size();
    }

    @Override
    public int heapSize() {
        return 0;
    }

    @Override
    public boolean isEmpty() {
        this.checkRefillCacheFromStore();
        return this.orderedCache.isEmpty();
    }

    @Override
    @Nonnull
    public CloseableIterator<E> iterator() {
        if (this.storeOnlyElements) {
            return this.orderedStore.orderedIterator();
        }
        return this.orderedCache.orderedIterator();
    }

    @Override
    public int getInternalIndex() {
        return this.pqManagedIndex;
    }

    @Override
    public void setInternalIndex(int updateIndex) {
        this.pqManagedIndex = updateIndex;
    }

    private void checkRefillCacheFromStore() {
        if (this.storeOnlyElements && this.orderedCache.isEmpty()) {
            try (CloseableIterator<E> iterator = this.orderedStore.orderedIterator();){
                while (iterator.hasNext() && !this.orderedCache.isFull()) {
                    this.orderedCache.add(iterator.next());
                }
                this.storeOnlyElements = iterator.hasNext();
            }
            catch (Exception e) {
                throw new FlinkRuntimeException("Exception while refilling store from iterator.", (Throwable)e);
            }
        }
    }

    public static interface OrderedSetStore<E> {
        public void add(@Nonnull E var1);

        public void remove(@Nonnull E var1);

        @Nonnegative
        public int size();

        @Nonnull
        public CloseableIterator<E> orderedIterator();
    }

    public static interface OrderedSetCache<E> {
        public void add(@Nonnull E var1);

        public void remove(@Nonnull E var1);

        public boolean isFull();

        public boolean isEmpty();

        public boolean isInLowerBound(@Nonnull E var1);

        @Nullable
        public E removeFirst();

        @Nullable
        public E removeLast();

        @Nullable
        public E peekFirst();

        @Nullable
        public E peekLast();

        @Nonnull
        public CloseableIterator<E> orderedIterator();
    }
}

