/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.heap;

import java.util.Arrays;
import java.util.Collection;
import java.util.NoSuchElementException;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.flink.runtime.state.InternalPriorityQueue;
import org.apache.flink.runtime.state.PriorityComparator;
import org.apache.flink.runtime.state.heap.HeapPriorityQueueElement;
import org.apache.flink.util.CloseableIterator;

public class HeapPriorityQueue<T extends HeapPriorityQueueElement>
implements InternalPriorityQueue<T> {
    private static final int QUEUE_HEAD_INDEX = 1;
    private final PriorityComparator<T> elementPriorityComparator;
    private T[] queue;
    private int size;

    public HeapPriorityQueue(@Nonnull PriorityComparator<T> elementPriorityComparator, @Nonnegative int minimumCapacity) {
        this.elementPriorityComparator = elementPriorityComparator;
        this.queue = new HeapPriorityQueueElement[1 + minimumCapacity];
    }

    @Override
    public void bulkPoll(@Nonnull Predicate<T> canConsume, @Nonnull Consumer<T> consumer) {
        Object element;
        while ((element = this.peek()) != null && canConsume.test(element)) {
            this.poll();
            consumer.accept(element);
        }
    }

    @Override
    @Nullable
    public T poll() {
        return this.size() > 0 ? (T)this.removeElementAtIndex(1) : null;
    }

    @Override
    @Nullable
    public T peek() {
        return this.size() > 0 ? (T)this.queue[1] : null;
    }

    @Override
    public boolean add(@Nonnull T toAdd) {
        return this.addInternal(toAdd);
    }

    @Override
    public boolean remove(@Nonnull T toRemove) {
        return this.removeInternal(toRemove);
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    @Nonnegative
    public int size() {
        return this.size;
    }

    @Override
    @Nonnegative
    public int heapSize() {
        return this.size;
    }

    public void clear() {
        this.size = 0;
        Arrays.fill(this.queue, null);
    }

    @Nonnull
    public <O> O[] toArray(O[] out) {
        if (out.length < this.size) {
            return Arrays.copyOfRange(this.queue, 1, 1 + this.size, out.getClass());
        }
        System.arraycopy(this.queue, 1, out, 0, this.size);
        if (out.length > this.size) {
            out[this.size] = null;
        }
        return out;
    }

    @Override
    @Nonnull
    public CloseableIterator<T> iterator() {
        return new HeapIterator();
    }

    @Override
    public void addAll(@Nullable Collection<? extends T> restoredElements) {
        if (restoredElements == null) {
            return;
        }
        this.resizeForBulkLoad(restoredElements.size());
        for (HeapPriorityQueueElement element : restoredElements) {
            this.add((T)element);
        }
    }

    private boolean addInternal(@Nonnull T element) {
        int newSize = this.increaseSizeByOne();
        this.moveElementToIdx(element, newSize);
        this.siftUp(newSize);
        return element.getInternalIndex() == 1;
    }

    private boolean removeInternal(@Nonnull T elementToRemove) {
        int elementIndex = elementToRemove.getInternalIndex();
        this.removeElementAtIndex(elementIndex);
        return elementIndex == 1;
    }

    private T removeElementAtIndex(int removeIdx) {
        T[] heap = this.queue;
        T removedValue = heap[removeIdx];
        assert (removedValue.getInternalIndex() == removeIdx);
        int oldSize = this.size;
        if (removeIdx != oldSize) {
            T element = heap[oldSize];
            this.moveElementToIdx(element, removeIdx);
            this.adjustElementAtIndex(element, removeIdx);
        }
        heap[oldSize] = null;
        --this.size;
        return removedValue;
    }

    public void adjustModifiedElement(@Nonnull T element) {
        int elementIndex = element.getInternalIndex();
        if (element == this.queue[elementIndex]) {
            this.adjustElementAtIndex(element, elementIndex);
        }
    }

    private void adjustElementAtIndex(T element, int index) {
        this.siftDown(index);
        if (this.queue[index] == element) {
            this.siftUp(index);
        }
    }

    private void siftUp(int idx) {
        T[] heap = this.queue;
        T currentElement = heap[idx];
        for (int parentIdx = idx >>> 1; parentIdx > 0 && this.isElementPriorityLessThen(currentElement, heap[parentIdx]); parentIdx >>>= 1) {
            this.moveElementToIdx(heap[parentIdx], idx);
            idx = parentIdx;
        }
        this.moveElementToIdx(currentElement, idx);
    }

    private void siftDown(int idx) {
        T[] heap = this.queue;
        int heapSize = this.size;
        T currentElement = heap[idx];
        int firstChildIdx = idx << 1;
        int secondChildIdx = firstChildIdx + 1;
        if (this.isElementIndexValid(secondChildIdx, heapSize) && this.isElementPriorityLessThen(heap[secondChildIdx], heap[firstChildIdx])) {
            firstChildIdx = secondChildIdx;
        }
        while (this.isElementIndexValid(firstChildIdx, heapSize) && this.isElementPriorityLessThen(heap[firstChildIdx], currentElement)) {
            this.moveElementToIdx(heap[firstChildIdx], idx);
            idx = firstChildIdx;
            secondChildIdx = (firstChildIdx = idx << 1) + 1;
            if (!this.isElementIndexValid(secondChildIdx, heapSize) || !this.isElementPriorityLessThen(heap[secondChildIdx], heap[firstChildIdx])) continue;
            firstChildIdx = secondChildIdx;
        }
        this.moveElementToIdx(currentElement, idx);
    }

    private boolean isElementIndexValid(int elementIndex, int heapSize) {
        return elementIndex <= heapSize;
    }

    private boolean isElementPriorityLessThen(T a, T b) {
        return this.elementPriorityComparator.comparePriority(a, b) < 0;
    }

    private void moveElementToIdx(T element, int idx) {
        this.queue[idx] = element;
        element.setInternalIndex(idx);
    }

    private int increaseSizeByOne() {
        int minRequiredNewSize;
        int oldArraySize = this.queue.length;
        if ((minRequiredNewSize = ++this.size) >= oldArraySize) {
            int grow = oldArraySize < 64 ? oldArraySize + 2 : oldArraySize >> 1;
            this.resizeQueueArray(oldArraySize + grow, minRequiredNewSize);
        }
        return minRequiredNewSize;
    }

    private void resizeForBulkLoad(int totalSize) {
        if (totalSize > this.queue.length) {
            int desiredSize = totalSize + (totalSize >>> 3);
            this.resizeQueueArray(desiredSize, totalSize);
        }
    }

    private void resizeQueueArray(int desiredSize, int minRequiredSize) {
        if (HeapPriorityQueue.isValidArraySize(desiredSize)) {
            this.queue = (HeapPriorityQueueElement[])Arrays.copyOf(this.queue, desiredSize);
        } else if (HeapPriorityQueue.isValidArraySize(minRequiredSize)) {
            this.queue = (HeapPriorityQueueElement[])Arrays.copyOf(this.queue, 0x7FFFFFF7);
        } else {
            throw new OutOfMemoryError("Required minimum heap size " + minRequiredSize + " exceeds maximum size of " + 0x7FFFFFF7 + ".");
        }
    }

    private static boolean isValidArraySize(int size) {
        return size >= 0 && size <= 0x7FFFFFF7;
    }

    private class HeapIterator
    implements CloseableIterator<T> {
        private int iterationIdx = 0;

        HeapIterator() {
        }

        public boolean hasNext() {
            return this.iterationIdx < HeapPriorityQueue.this.size;
        }

        public T next() {
            if (this.iterationIdx >= HeapPriorityQueue.this.size) {
                throw new NoSuchElementException("Iterator has no next element.");
            }
            return HeapPriorityQueue.this.queue[++this.iterationIdx];
        }

        public void close() {
        }
    }
}

