/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.heap;

import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.runtime.state.KeyGroupRange;
import org.apache.flink.runtime.state.KeyGroupRangeAssignment;
import org.apache.flink.runtime.state.heap.InternalKeyContext;

public class KeyContextImpl<K>
implements InternalKeyContext {
    private final TypeSerializer<K> keySerializer;
    private final int numberOfKeyGroups;
    private final KeyGroupRange keyGroupRange;
    private K currentKey;

    public KeyContextImpl(TypeSerializer<K> keySerializer, int numberOfKeyGroups, KeyGroupRange keyGroupRange) {
        this.keySerializer = keySerializer;
        this.numberOfKeyGroups = numberOfKeyGroups;
        this.keyGroupRange = keyGroupRange;
    }

    public void setCurrentKey(K newKey) {
        this.currentKey = newKey;
    }

    @Override
    public K getCurrentKey() {
        return this.currentKey;
    }

    @Override
    public int getCurrentKeyGroupIndex() {
        return KeyGroupRangeAssignment.assignToKeyGroup(this.currentKey, this.numberOfKeyGroups);
    }

    @Override
    public int getNumberOfKeyGroups() {
        return this.numberOfKeyGroups;
    }

    @Override
    public KeyGroupRange getKeyGroupRange() {
        return this.keyGroupRange;
    }

    @Override
    public TypeSerializer<K> getKeySerializer() {
        return this.keySerializer;
    }
}

