/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.heap;

import it.unimi.dsi.fastutil.objects.ObjectAVLTreeSet;
import java.util.Comparator;
import java.util.Iterator;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.flink.runtime.state.heap.CachingInternalPriorityQueueSet;
import org.apache.flink.util.CloseableIterator;
import org.apache.flink.util.Preconditions;

public class TreeOrderedSetCache<E>
implements CachingInternalPriorityQueueSet.OrderedSetCache<E> {
    @Nonnull
    private final ObjectAVLTreeSet<E> avlTree;
    @Nonnull
    private final Comparator<E> elementComparator;
    @Nonnegative
    private final int capacity;

    public TreeOrderedSetCache(@Nonnull Comparator<E> elementComparator, @Nonnegative int capacity) {
        Preconditions.checkArgument((capacity > 0 ? 1 : 0) != 0, (Object)"Cache capacity must be greater than 0.");
        this.avlTree = new ObjectAVLTreeSet(elementComparator);
        this.elementComparator = elementComparator;
        this.capacity = capacity;
    }

    @Override
    public void add(@Nonnull E element) {
        assert (!this.isFull());
        this.avlTree.add(element);
    }

    @Override
    public void remove(@Nonnull E element) {
        this.avlTree.remove(element);
    }

    @Override
    public boolean isFull() {
        return this.avlTree.size() == this.capacity;
    }

    @Override
    public boolean isEmpty() {
        return this.avlTree.isEmpty();
    }

    @Override
    public boolean isInLowerBound(@Nonnull E toCheck) {
        return this.avlTree.isEmpty() || this.elementComparator.compare(this.peekLast(), toCheck) > 0;
    }

    @Override
    @Nullable
    public E removeFirst() {
        if (this.avlTree.isEmpty()) {
            return null;
        }
        Object first = this.avlTree.first();
        this.avlTree.remove(first);
        return (E)first;
    }

    @Override
    @Nullable
    public E removeLast() {
        if (this.avlTree.isEmpty()) {
            return null;
        }
        Object last = this.avlTree.last();
        this.avlTree.remove(last);
        return (E)last;
    }

    @Override
    @Nullable
    public E peekFirst() {
        return (E)(!this.avlTree.isEmpty() ? this.avlTree.first() : null);
    }

    @Override
    @Nullable
    public E peekLast() {
        return (E)(!this.avlTree.isEmpty() ? this.avlTree.last() : null);
    }

    @Override
    @Nonnull
    public CloseableIterator<E> orderedIterator() {
        return CloseableIterator.adapterForIterator((Iterator)this.avlTree.iterator());
    }
}

