/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.heap.internal;

import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.runtime.state.KeyGroupPartitioner;
import org.apache.flink.runtime.state.KeyGroupRange;
import org.apache.flink.runtime.state.KeyGroupRangeAssignment;
import org.apache.flink.runtime.state.StateSnapshot;
import org.apache.flink.runtime.state.heap.internal.AbstractStateTableSnapshot;
import org.apache.flink.runtime.state.heap.internal.CopyOnWriteStateTable;

@Internal
public class CopyOnWriteStateTableSnapshot<K, N, S>
extends AbstractStateTableSnapshot<K, N, S, CopyOnWriteStateTable<K, N, S>> {
    private final int snapshotVersion;
    @Nonnull
    private final CopyOnWriteStateTable.StateTableEntry<K, N, S>[] snapshotData;
    @Nonnegative
    private final int numberOfEntriesInSnapshotData;
    @Nonnull
    private final TypeSerializer<K> localKeySerializer;
    @Nonnull
    private final TypeSerializer<N> localNamespaceSerializer;
    @Nonnull
    private final TypeSerializer<S> localStateSerializer;
    @Nullable
    private StateSnapshot.KeyGroupPartitionedSnapshot partitionedStateTableSnapshot;

    CopyOnWriteStateTableSnapshot(CopyOnWriteStateTable<K, N, S> owningStateTable) {
        super(owningStateTable);
        this.snapshotData = owningStateTable.snapshotTableArrays();
        this.snapshotVersion = owningStateTable.getStateTableVersion();
        this.numberOfEntriesInSnapshotData = owningStateTable.size();
        this.localKeySerializer = owningStateTable.getKeySerializer().duplicate();
        this.localNamespaceSerializer = owningStateTable.getNamespaceSerializer().duplicate();
        this.localStateSerializer = owningStateTable.getStateSerializer().duplicate();
        this.partitionedStateTableSnapshot = null;
    }

    int getSnapshotVersion() {
        return this.snapshotVersion;
    }

    @Override
    @Nonnull
    public StateSnapshot.KeyGroupPartitionedSnapshot partitionByKeyGroup() {
        if (this.partitionedStateTableSnapshot == null) {
            KeyGroupRange keyGroupRange = ((CopyOnWriteStateTable)this.owningStateTable).getStateBackend().getKeyGroupRange();
            int numberOfKeyGroups = ((CopyOnWriteStateTable)this.owningStateTable).getStateBackend().getNumGroups();
            boolean usingNamespace = ((CopyOnWriteStateTable)this.owningStateTable).isUsingNamespace();
            StateTableKeyGroupPartitioner<K, N, S> keyGroupPartitioner = new StateTableKeyGroupPartitioner<K, N, S>(this.snapshotData, this.numberOfEntriesInSnapshotData, keyGroupRange, numberOfKeyGroups, (element, dov) -> {
                this.localKeySerializer.serialize(element.key, dov);
                if (usingNamespace) {
                    this.localNamespaceSerializer.serialize(element.namespace, dov);
                }
                this.localStateSerializer.serialize(element.state, dov);
            });
            this.partitionedStateTableSnapshot = keyGroupPartitioner.partitionByKeyGroup();
        }
        return this.partitionedStateTableSnapshot;
    }

    @Override
    public void release() {
        ((CopyOnWriteStateTable)this.owningStateTable).releaseSnapshot(this);
    }

    boolean isOwner(CopyOnWriteStateTable<K, N, S> stateTable) {
        return stateTable == this.owningStateTable;
    }

    @VisibleForTesting
    protected static final class StateTableKeyGroupPartitioner<K, N, S>
    extends KeyGroupPartitioner<CopyOnWriteStateTable.StateTableEntry<K, N, S>> {
        StateTableKeyGroupPartitioner(@Nonnull CopyOnWriteStateTable.StateTableEntry<K, N, S>[] snapshotData, @Nonnegative int stateTableSize, @Nonnull KeyGroupRange keyGroupRange, @Nonnegative int totalKeyGroups, @Nonnull KeyGroupPartitioner.ElementWriterFunction<CopyOnWriteStateTable.StateTableEntry<K, N, S>> elementWriterFunction) {
            super(new CopyOnWriteStateTable.StateTableEntry[stateTableSize], stateTableSize, snapshotData, keyGroupRange, totalKeyGroups, CopyOnWriteStateTable.StateTableEntry::getKey, elementWriterFunction);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        protected void reportAllElementKeyGroups() {
            int flattenIndex = 0;
            for (CopyOnWriteStateTable.StateTableEntry stateTableEntry : (CopyOnWriteStateTable.StateTableEntry[])this.partitioningDestination) {
                void var5_5;
                while (null != var5_5) {
                    int keyGroup = KeyGroupRangeAssignment.assignToKeyGroup(var5_5.key, this.totalKeyGroups);
                    this.reportKeyGroupOfElementAtIndex(flattenIndex, keyGroup);
                    ((CopyOnWriteStateTable.StateTableEntry[])this.partitioningSource)[flattenIndex++] = var5_5;
                    CopyOnWriteStateTable.StateTableEntry stateTableEntry2 = var5_5.next;
                }
            }
        }
    }
}

