/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.heap.internal;

import java.util.Iterator;
import java.util.Map;
import java.util.stream.Stream;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.runtime.state.AbstractInternalStateBackend;
import org.apache.flink.runtime.state.RegisteredStateMetaInfo;
import org.apache.flink.runtime.state.StateSnapshot;
import org.apache.flink.runtime.state.StateTransformationFunction;
import org.apache.flink.util.Preconditions;

public abstract class StateTable<K, N, S> {
    AbstractInternalStateBackend internalStateBackend;
    protected final boolean usingNamespace;
    protected RegisteredStateMetaInfo stateMetaInfo;

    public StateTable(AbstractInternalStateBackend internalStateBackend, RegisteredStateMetaInfo stateMetaInfo, boolean usingNamespace) {
        this.internalStateBackend = (AbstractInternalStateBackend)Preconditions.checkNotNull((Object)internalStateBackend);
        this.stateMetaInfo = stateMetaInfo;
        this.usingNamespace = usingNamespace;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public abstract int size();

    public abstract S get(K var1, N var2);

    public abstract Stream<K> getKeys(N var1);

    public abstract void put(K var1, N var2, S var3);

    public abstract S putAndGetOld(K var1, N var2, S var3);

    public abstract boolean containsKey(K var1, N var2);

    public abstract boolean remove(K var1, N var2);

    public abstract S removeAndGetOld(K var1, N var2);

    public abstract Map<N, S> getAll(K var1);

    public abstract void removeAll(K var1);

    public abstract void removeAll();

    public abstract Iterator<Map.Entry<K, S>> entryIterator();

    public abstract Iterator<N> namespaceIterator(K var1);

    public abstract <T> void transform(K var1, N var2, T var3, StateTransformationFunction<S, T> var4) throws Exception;

    public AbstractInternalStateBackend getStateBackend() {
        return this.internalStateBackend;
    }

    public TypeSerializer<K> getKeySerializer() {
        return this.stateMetaInfo.getKeySerializer();
    }

    public TypeSerializer<N> getNamespaceSerializer() {
        return this.stateMetaInfo.getNamespaceSerializer();
    }

    public TypeSerializer<S> getStateSerializer() {
        return this.stateMetaInfo.getValueSerializer();
    }

    public void setStateMetaInfo(RegisteredStateMetaInfo stateMetaInfo) {
        this.stateMetaInfo = stateMetaInfo;
    }

    public boolean isUsingNamespace() {
        return this.usingNamespace;
    }

    public abstract StateSnapshot createSnapshot();

    public abstract void put(K var1, int var2, N var3, S var4);

    @VisibleForTesting
    public abstract int sizeOfNamespace(Object var1);
}

