/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.keyed;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.flink.api.common.functions.Comparator;
import org.apache.flink.api.common.typeutils.SerializationException;
import org.apache.flink.api.common.typeutils.base.StringSerializer;
import org.apache.flink.core.memory.ByteArrayOutputStreamWithPos;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.core.memory.DataOutputViewStreamWrapper;
import org.apache.flink.runtime.state.AbstractInternalStateBackend;
import org.apache.flink.runtime.state.StateAccessException;
import org.apache.flink.runtime.state.StateSerializerUtil;
import org.apache.flink.runtime.state.StateStorage;
import org.apache.flink.runtime.state.StorageIterator;
import org.apache.flink.runtime.state.keyed.AbstractKeyedMapStateImpl;
import org.apache.flink.runtime.state.keyed.KeyedSortedMapState;
import org.apache.flink.runtime.state.keyed.KeyedSortedMapStateDescriptor;
import org.apache.flink.types.Pair;
import org.apache.flink.util.Preconditions;

public final class KeyedSortedMapStateImpl<K, MK, MV>
extends AbstractKeyedMapStateImpl<K, MK, MV, SortedMap<MK, MV>>
implements KeyedSortedMapState<K, MK, MV> {
    private KeyedSortedMapStateDescriptor<K, MK, MV> stateDescriptor;

    public KeyedSortedMapStateImpl(AbstractInternalStateBackend internalStateBackend, KeyedSortedMapStateDescriptor<K, MK, MV> descriptor, StateStorage stateStorage) {
        super(internalStateBackend, stateStorage);
        this.stateDescriptor = (KeyedSortedMapStateDescriptor)Preconditions.checkNotNull(descriptor);
        this.keySerializer = descriptor.getKeySerializer();
        this.mapKeySerializer = descriptor.getMapKeySerializer();
        this.mapValueSerializer = descriptor.getMapValueSerializer();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            StringSerializer.INSTANCE.serialize(descriptor.getName(), (DataOutputView)new DataOutputViewStreamWrapper((OutputStream)out));
            this.stateNameByte = out.toByteArray();
        }
        catch (IOException e) {
            throw new SerializationException((Throwable)e);
        }
        this.stateNameForSerialize = stateStorage.supportMultiColumnFamilies() ? null : this.stateNameByte;
        this.serializedStateNameLength = this.stateNameForSerialize == null ? 0 : this.stateNameForSerialize.length;
    }

    @Override
    public KeyedSortedMapStateDescriptor getDescriptor() {
        return this.stateDescriptor;
    }

    @Override
    SortedMap<MK, MV> createMap() {
        Comparator<MK> comparator = this.stateDescriptor.getMapKeyComparator();
        return new TreeMap(comparator);
    }

    @Override
    public Map.Entry<MK, MV> firstEntry(K key) {
        if (key == null) {
            return null;
        }
        if (this.stateStorage.lazySerde()) {
            TreeMap map = (TreeMap)this.get((Object)key);
            return map == null ? null : map.firstEntry();
        }
        try {
            this.outputStream.reset();
            byte[] prefixKey = StateSerializerUtil.getSerializedPrefixKeyForKeyedMapState(this.outputStream, this.outputView, key, this.keySerializer, this.getKeyGroup(key), this.stateNameForSerialize);
            final Pair firstEntry = this.stateStorage.firstEntry(prefixKey);
            if (firstEntry == null || !this.isEntryWithPrefix(prefixKey, prefixKey.length, (byte[])firstEntry.getKey())) {
                return null;
            }
            return new Map.Entry<MK, MV>(){

                @Override
                public MK getKey() {
                    try {
                        return StateSerializerUtil.getDeserializedMapKeyForKeyedMapState((byte[])firstEntry.getKey(), KeyedSortedMapStateImpl.this.keySerializer, KeyedSortedMapStateImpl.this.mapKeySerializer, KeyedSortedMapStateImpl.this.serializedStateNameLength);
                    }
                    catch (Exception e) {
                        throw new StateAccessException(e);
                    }
                }

                @Override
                public MV getValue() {
                    try {
                        return StateSerializerUtil.getDeserializeSingleValue((byte[])firstEntry.getValue(), KeyedSortedMapStateImpl.this.mapValueSerializer);
                    }
                    catch (Exception e) {
                        throw new StateAccessException(e);
                    }
                }

                @Override
                public MV setValue(MV value) {
                    return null;
                }
            };
        }
        catch (Exception e) {
            throw new StateAccessException(e);
        }
    }

    @Override
    public Map.Entry<MK, MV> lastEntry(K key) {
        if (key == null) {
            return null;
        }
        if (this.stateStorage.lazySerde()) {
            TreeMap map = (TreeMap)this.get((Object)key);
            return map == null ? null : map.lastEntry();
        }
        try {
            this.outputStream.reset();
            byte[] prefixKey = StateSerializerUtil.getSerializedPrefixKeyEndForKeyedMapState(this.outputStream, this.outputView, key, this.keySerializer, null, this.mapKeySerializer, this.getKeyGroup(key), this.stateNameForSerialize);
            final Pair lastEntry = this.stateStorage.lastEntry(prefixKey);
            if (lastEntry == null || !this.isEntryWithPrefix(prefixKey, prefixKey.length - 1, (byte[])lastEntry.getKey())) {
                return null;
            }
            return new Map.Entry<MK, MV>(){

                @Override
                public MK getKey() {
                    try {
                        return StateSerializerUtil.getDeserializedMapKeyForKeyedMapState((byte[])lastEntry.getKey(), KeyedSortedMapStateImpl.this.keySerializer, KeyedSortedMapStateImpl.this.mapKeySerializer, KeyedSortedMapStateImpl.this.serializedStateNameLength);
                    }
                    catch (Exception e) {
                        throw new StateAccessException(e);
                    }
                }

                @Override
                public MV getValue() {
                    try {
                        return StateSerializerUtil.getDeserializeSingleValue((byte[])lastEntry.getValue(), KeyedSortedMapStateImpl.this.mapValueSerializer);
                    }
                    catch (Exception e) {
                        throw new StateAccessException(e);
                    }
                }

                @Override
                public MV setValue(MV value) {
                    try {
                        ByteArrayOutputStreamWithPos valueOutputStream = new ByteArrayOutputStreamWithPos();
                        DataOutputViewStreamWrapper valueOutputView = new DataOutputViewStreamWrapper((OutputStream)valueOutputStream);
                        KeyedSortedMapStateImpl.this.mapValueSerializer.serialize(value, (DataOutputView)valueOutputView);
                        byte[] oldValue = (byte[])lastEntry.setValue((Object)valueOutputStream.toByteArray());
                        if (oldValue == null) {
                            return null;
                        }
                        return StateSerializerUtil.getDeserializeSingleValue(oldValue, KeyedSortedMapStateImpl.this.mapValueSerializer);
                    }
                    catch (Exception e) {
                        throw new StateAccessException(e);
                    }
                }
            };
        }
        catch (Exception e) {
            throw new StateAccessException(e);
        }
    }

    @Override
    public Iterator<Map.Entry<MK, MV>> headIterator(K key, MK endMapKey) {
        if (key == null || endMapKey == null) {
            return Collections.emptyIterator();
        }
        if (this.stateStorage.lazySerde()) {
            SortedMap map = (SortedMap)this.get((Object)key);
            return map == null ? Collections.emptyIterator() : map.headMap(endMapKey).entrySet().iterator();
        }
        try {
            this.outputStream.reset();
            byte[] prefixKey = StateSerializerUtil.getSerializedPrefixKeyForKeyedMapState(this.outputStream, this.outputView, key, this.keySerializer, this.getKeyGroup(key), this.stateNameForSerialize);
            StateSerializerUtil.serializeItemWithKeyPrefix(this.outputView, endMapKey, this.mapKeySerializer);
            byte[] prefixKeyEnd = this.outputStream.toByteArray();
            return this.subIterator(prefixKey, prefixKeyEnd);
        }
        catch (Exception e) {
            throw new StateAccessException(e);
        }
    }

    @Override
    public Iterator<Map.Entry<MK, MV>> tailIterator(K key, MK startMapKey) {
        if (key == null || startMapKey == null) {
            return Collections.emptyIterator();
        }
        if (this.stateStorage.lazySerde()) {
            SortedMap map = (SortedMap)this.get((Object)key);
            return map == null ? Collections.emptyIterator() : map.tailMap(startMapKey).entrySet().iterator();
        }
        try {
            this.outputStream.reset();
            StateSerializerUtil.getSerializedPrefixKeyForKeyedMapState(this.outputStream, this.outputView, key, this.keySerializer, this.getKeyGroup(key), this.stateNameForSerialize);
            int keyPosition = this.outputStream.getPosition();
            StateSerializerUtil.serializeItemWithKeyPrefix(this.outputView, startMapKey, this.mapKeySerializer);
            byte[] prefixKey = this.outputStream.toByteArray();
            this.outputStream.setPosition(keyPosition);
            this.outputStream.write(127);
            byte[] prefixKeyEnd = this.outputStream.toByteArray();
            return this.subIterator(prefixKey, prefixKeyEnd);
        }
        catch (Exception e) {
            throw new StateAccessException(e);
        }
    }

    @Override
    public Iterator<Map.Entry<MK, MV>> subIterator(K key, MK startMapKey, MK endMapKey) {
        if (key == null || startMapKey == null || endMapKey == null) {
            return Collections.emptyIterator();
        }
        if (this.stateStorage.lazySerde()) {
            SortedMap map = (SortedMap)this.get((Object)key);
            return map == null ? Collections.emptyIterator() : map.subMap(startMapKey, endMapKey).entrySet().iterator();
        }
        try {
            this.outputStream.reset();
            StateSerializerUtil.getSerializedPrefixKeyForKeyedMapState(this.outputStream, this.outputView, key, this.keySerializer, this.getKeyGroup(key), this.stateNameForSerialize);
            int keyPosition = this.outputStream.getPosition();
            StateSerializerUtil.serializeItemWithKeyPrefix(this.outputView, startMapKey, this.mapKeySerializer);
            byte[] prefixKey = this.outputStream.toByteArray();
            this.outputStream.setPosition(keyPosition);
            StateSerializerUtil.serializeItemWithKeyPrefix(this.outputView, endMapKey, this.mapKeySerializer);
            byte[] prefixKeyEnd = this.outputStream.toByteArray();
            return this.subIterator(prefixKey, prefixKeyEnd);
        }
        catch (Exception e) {
            throw new StateAccessException(e);
        }
    }

    private boolean isEntryWithPrefix(byte[] prefixKey, int length, byte[] actualKey) {
        if (actualKey.length < length) {
            return false;
        }
        int commonLength = Math.min(length, actualKey.length);
        for (int i = 0; i < commonLength; ++i) {
            int leftByte = prefixKey[i] & 0xFF;
            int rightByte = actualKey[i] & 0xFF;
            if (leftByte >= rightByte) continue;
            return false;
        }
        return true;
    }

    private Iterator<Map.Entry<MK, MV>> subIterator(byte[] prefixKeyStart, byte[] prefixKeyEnd) {
        if (this.stateStorage.lazySerde()) {
            return null;
        }
        try {
            final StorageIterator subIterator = this.stateStorage.subIterator(prefixKeyStart, prefixKeyEnd);
            return new Iterator<Map.Entry<MK, MV>>(){

                @Override
                public boolean hasNext() {
                    return subIterator.hasNext();
                }

                @Override
                public Map.Entry<MK, MV> next() {
                    final Pair nextByteEntry = (Pair)subIterator.next();
                    return new Map.Entry<MK, MV>(){

                        @Override
                        public MK getKey() {
                            try {
                                if (nextByteEntry == null || nextByteEntry.getKey() == null) {
                                    return null;
                                }
                                return StateSerializerUtil.getDeserializedMapKeyForKeyedMapState((byte[])nextByteEntry.getKey(), KeyedSortedMapStateImpl.this.keySerializer, KeyedSortedMapStateImpl.this.mapKeySerializer, KeyedSortedMapStateImpl.this.serializedStateNameLength);
                            }
                            catch (Exception e) {
                                throw new StateAccessException(e);
                            }
                        }

                        @Override
                        public MV getValue() {
                            try {
                                if (nextByteEntry == null || nextByteEntry.getValue() == null) {
                                    return null;
                                }
                                return StateSerializerUtil.getDeserializeSingleValue((byte[])nextByteEntry.getValue(), KeyedSortedMapStateImpl.this.mapValueSerializer);
                            }
                            catch (Exception e) {
                                throw new StateAccessException(e);
                            }
                        }

                        @Override
                        public MV setValue(MV value) {
                            try {
                                ByteArrayOutputStreamWithPos valueOutputStream = new ByteArrayOutputStreamWithPos();
                                DataOutputViewStreamWrapper valueOutputView = new DataOutputViewStreamWrapper((OutputStream)valueOutputStream);
                                KeyedSortedMapStateImpl.this.mapValueSerializer.serialize(value, (DataOutputView)valueOutputView);
                                byte[] oldValue = (byte[])nextByteEntry.setValue((Object)valueOutputStream.toByteArray());
                                if (oldValue == null) {
                                    return null;
                                }
                                return StateSerializerUtil.getDeserializeSingleValue(oldValue, KeyedSortedMapStateImpl.this.mapValueSerializer);
                            }
                            catch (Exception e) {
                                throw new StateAccessException(e);
                            }
                        }
                    };
                }

                @Override
                public void remove() {
                    subIterator.remove();
                }
            };
        }
        catch (Exception e) {
            throw new StateAccessException(e);
        }
    }
}

