/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.keyed;

import java.io.Serializable;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.runtime.state.InternalStateType;
import org.apache.flink.runtime.state.keyed.KeyedState;
import org.apache.flink.runtime.state.keyed.KeyedStateBinder;
import org.apache.flink.util.Preconditions;

public abstract class KeyedStateDescriptor<K, V, S extends KeyedState<K, V>>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String name;
    private TypeSerializer<K> keySerializer;
    private TypeSerializer<V> valueSerializer;
    private final InternalStateType stateType;
    @Nullable
    private String queryableStateName;

    KeyedStateDescriptor(String name, InternalStateType stateType, TypeSerializer<K> keySerializer, TypeSerializer<V> valueSerializer) {
        Preconditions.checkNotNull((Object)name);
        Preconditions.checkNotNull((Object)((Object)stateType));
        Preconditions.checkNotNull(keySerializer);
        Preconditions.checkNotNull(valueSerializer);
        this.name = name;
        this.stateType = stateType;
        this.keySerializer = keySerializer;
        this.valueSerializer = valueSerializer;
    }

    public abstract S bind(KeyedStateBinder var1) throws Exception;

    public String getName() {
        return this.name;
    }

    public InternalStateType getStateType() {
        return this.stateType;
    }

    public TypeSerializer<K> getKeySerializer() {
        return this.keySerializer;
    }

    public TypeSerializer<V> getValueSerializer() {
        return this.valueSerializer;
    }

    public void setKeySerializer(TypeSerializer<K> keySerializer) {
        this.keySerializer = keySerializer;
    }

    public void setValueSerializer(TypeSerializer<V> valueSerializer) {
        this.valueSerializer = valueSerializer;
    }

    public boolean isQueryable() {
        return this.queryableStateName != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KeyedStateDescriptor that = (KeyedStateDescriptor)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.keySerializer, that.keySerializer) && Objects.equals(this.valueSerializer, that.valueSerializer);
    }

    public int hashCode() {
        int result = Objects.hashCode(this.name);
        result = 31 * result + Objects.hashCode(this.keySerializer);
        result = 31 * result + Objects.hashCode(this.valueSerializer);
        return result;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{name=" + this.name + ", keySerializer=" + this.keySerializer + ", valueSerializer=" + this.valueSerializer + "}";
    }
}

