/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.keyed;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.flink.api.common.functions.HashPartitioner;
import org.apache.flink.api.common.typeutils.SerializationException;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.base.StringSerializer;
import org.apache.flink.core.memory.ByteArrayOutputStreamWithPos;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.core.memory.DataOutputViewStreamWrapper;
import org.apache.flink.queryablestate.client.state.serialization.KvStateSerializer;
import org.apache.flink.runtime.state.AbstractInternalStateBackend;
import org.apache.flink.runtime.state.BatchPutWrapper;
import org.apache.flink.runtime.state.GroupIterator;
import org.apache.flink.runtime.state.StateAccessException;
import org.apache.flink.runtime.state.StateIteratorUtil;
import org.apache.flink.runtime.state.StateSerializerUtil;
import org.apache.flink.runtime.state.StateStorage;
import org.apache.flink.runtime.state.StateTransformationFunction;
import org.apache.flink.runtime.state.StorageInstance;
import org.apache.flink.runtime.state.StorageIterator;
import org.apache.flink.runtime.state.VoidNamespaceSerializer;
import org.apache.flink.runtime.state.heap.HeapStateStorage;
import org.apache.flink.runtime.state.keyed.KeyedValueState;
import org.apache.flink.runtime.state.keyed.KeyedValueStateDescriptor;
import org.apache.flink.types.Pair;
import org.apache.flink.util.Preconditions;

public final class KeyedValueStateImpl<K, V>
implements KeyedValueState<K, V> {
    private final KeyedValueStateDescriptor<K, V> descriptor;
    private final StateStorage stateStorage;
    private TypeSerializer<K> keySerializer;
    private TypeSerializer<V> valueSerializer;
    private final byte[] stateNameByte;
    private final byte[] stateNameForSerializer;
    private AbstractInternalStateBackend internalStateBackend;
    private static final HashPartitioner partitioner = HashPartitioner.INSTANCE;
    private ByteArrayOutputStreamWithPos outputStream = new ByteArrayOutputStreamWithPos();
    private DataOutputView outputView = new DataOutputViewStreamWrapper((OutputStream)this.outputStream);

    public KeyedValueStateImpl(AbstractInternalStateBackend internalStateBackend, KeyedValueStateDescriptor<K, V> descriptor, StateStorage stateStorage) {
        this.descriptor = (KeyedValueStateDescriptor)Preconditions.checkNotNull(descriptor);
        this.stateStorage = (StateStorage)Preconditions.checkNotNull((Object)stateStorage);
        this.internalStateBackend = (AbstractInternalStateBackend)Preconditions.checkNotNull((Object)internalStateBackend);
        this.keySerializer = descriptor.getKeySerializer();
        this.valueSerializer = descriptor.getValueSerializer();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            StringSerializer.INSTANCE.serialize(descriptor.getName(), (DataOutputView)new DataOutputViewStreamWrapper((OutputStream)out));
            this.stateNameByte = out.toByteArray();
        }
        catch (IOException e) {
            throw new SerializationException((Throwable)e);
        }
        this.stateNameForSerializer = stateStorage.supportMultiColumnFamilies() ? null : this.stateNameByte;
    }

    @Override
    public KeyedValueStateDescriptor getDescriptor() {
        return this.descriptor;
    }

    @Override
    public boolean contains(K key) {
        if (key == null) {
            return false;
        }
        try {
            if (this.stateStorage.lazySerde()) {
                return this.stateStorage.get(key) != null;
            }
            this.outputStream.reset();
            byte[] serializedKey = StateSerializerUtil.getSerializedKeyForKeyedValueState(this.outputStream, this.outputView, key, this.keySerializer, this.getKeyGroup(key), this.stateNameForSerializer);
            return this.stateStorage.get(serializedKey) != null;
        }
        catch (Exception e) {
            throw new StateAccessException(e);
        }
    }

    @Override
    public V get(K key) {
        return this.getOrDefault(key, null);
    }

    @Override
    public V getOrDefault(K key, V defaultValue) {
        if (key == null) {
            return defaultValue;
        }
        try {
            if (this.stateStorage.lazySerde()) {
                Object value = this.stateStorage.get(key);
                return value == null ? defaultValue : value;
            }
            byte[] serializedValue = this.getSerializedValue(key, this.outputStream, this.outputView, this.keySerializer);
            if (serializedValue == null) {
                return defaultValue;
            }
            return StateSerializerUtil.getDeserializeSingleValue(serializedValue, this.valueSerializer);
        }
        catch (Exception e) {
            throw new StateAccessException(e);
        }
    }

    @Override
    public Map<K, V> getAll(Collection<? extends K> keys) {
        if (keys == null || keys.isEmpty()) {
            return Collections.emptyMap();
        }
        try {
            HashMap<K, V> results = new HashMap<K, V>();
            if (this.stateStorage.lazySerde()) {
                for (K key : keys) {
                    Object value;
                    if (key == null || (value = this.stateStorage.get(key)) == null) continue;
                    results.put(key, value);
                }
            } else {
                for (K key : keys) {
                    if (key == null) continue;
                    this.outputStream.reset();
                    byte[] serializedKey = StateSerializerUtil.getSerializedKeyForKeyedValueState(this.outputStream, this.outputView, key, this.keySerializer, this.getKeyGroup(key), this.stateNameForSerializer);
                    byte[] serializedValue = (byte[])this.stateStorage.get(serializedKey);
                    if (serializedValue == null) continue;
                    results.put(key, StateSerializerUtil.getDeserializeSingleValue(serializedValue, this.valueSerializer));
                }
            }
            return results;
        }
        catch (Exception e) {
            throw new StateAccessException(e);
        }
    }

    @Override
    public void remove(K key) {
        if (key == null) {
            return;
        }
        try {
            if (this.stateStorage.lazySerde()) {
                this.stateStorage.remove(key);
            } else {
                this.outputStream.reset();
                byte[] serializedKey = StateSerializerUtil.getSerializedKeyForKeyedValueState(this.outputStream, this.outputView, key, this.keySerializer, this.getKeyGroup(key), this.stateNameForSerializer);
                this.stateStorage.remove(serializedKey);
            }
        }
        catch (Exception e) {
            throw new StateAccessException(e);
        }
    }

    @Override
    public void removeAll(Collection<? extends K> keys) {
        if (keys == null || keys.isEmpty()) {
            return;
        }
        for (K key : keys) {
            this.remove(key);
        }
    }

    @Override
    public void put(K key, V value) {
        Preconditions.checkNotNull(key);
        try {
            if (this.stateStorage.lazySerde()) {
                this.stateStorage.put(key, value);
            } else {
                this.outputStream.reset();
                byte[] serializedKey = StateSerializerUtil.getSerializedKeyForKeyedValueState(this.outputStream, this.outputView, key, this.keySerializer, this.getKeyGroup(key), this.stateNameForSerializer);
                this.outputStream.reset();
                byte[] serializedValue = StateSerializerUtil.getSerializeSingleValue(this.outputStream, this.outputView, value, this.valueSerializer);
                this.stateStorage.put(serializedKey, serializedValue);
            }
        }
        catch (Exception e) {
            throw new StateAccessException(e);
        }
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> pairs) {
        block18: {
            if (pairs == null || pairs.isEmpty()) {
                return;
            }
            try {
                if (this.stateStorage.lazySerde()) {
                    for (Map.Entry<K, V> entry : pairs.entrySet()) {
                        this.stateStorage.put(entry.getKey(), entry.getValue());
                    }
                    break block18;
                }
                StorageInstance instance = this.stateStorage.getStorageInstance();
                try (BatchPutWrapper batchPutWrapper = instance.getBatchPutWrapper();){
                    for (Map.Entry<K, V> entry : pairs.entrySet()) {
                        K key = entry.getKey();
                        this.outputStream.reset();
                        byte[] byteKey = StateSerializerUtil.getSerializedKeyForKeyedValueState(this.outputStream, this.outputView, key, this.keySerializer, this.getKeyGroup(key), this.stateNameForSerializer);
                        this.outputStream.reset();
                        byte[] byteValue = StateSerializerUtil.getSerializeSingleValue(this.outputStream, this.outputView, entry.getValue(), this.valueSerializer);
                        batchPutWrapper.put(byteKey, byteValue);
                    }
                }
            }
            catch (Exception e) {
                throw new StateAccessException(e);
            }
        }
    }

    @Override
    public Map<K, V> getAll() {
        try {
            HashMap<Object, Object> results = new HashMap<Object, Object>();
            if (this.stateStorage.lazySerde()) {
                StorageIterator iterator = this.stateStorage.iterator();
                while (iterator.hasNext()) {
                    Pair pair = (Pair)iterator.next();
                    results.put(pair.getKey(), pair.getValue());
                }
            } else if (!this.stateStorage.supportMultiColumnFamilies() && this.internalStateBackend.getStateStorages().size() > 1) {
                for (Integer group : this.internalStateBackend.getKeyGroupRange()) {
                    this.outputStream.reset();
                    StateSerializerUtil.serializeGroupPrefix(this.outputStream, group, this.stateNameByte);
                    byte[] groupPrefix = this.outputStream.toByteArray();
                    this.outputStream.write(127);
                    byte[] groupPrefixEnd = this.outputStream.toByteArray();
                    StorageIterator iterator = this.stateStorage.subIterator(groupPrefix, groupPrefixEnd);
                    while (iterator.hasNext()) {
                        Pair bytePair = (Pair)iterator.next();
                        K key = StateSerializerUtil.getDeserializedKeyForKeyedValueState((byte[])bytePair.getKey(), this.keySerializer, this.stateNameByte.length);
                        V value = StateSerializerUtil.getDeserializeSingleValue((byte[])bytePair.getValue(), this.valueSerializer);
                        results.put(key, value);
                    }
                }
            } else {
                StorageIterator iterator = this.stateStorage.iterator();
                while (iterator.hasNext()) {
                    Pair bytePair = (Pair)iterator.next();
                    K key = StateSerializerUtil.getDeserializedKeyForKeyedValueState((byte[])bytePair.getKey(), this.keySerializer, this.stateStorage.supportMultiColumnFamilies() ? 0 : this.stateNameByte.length);
                    V value = StateSerializerUtil.getDeserializeSingleValue((byte[])bytePair.getValue(), this.valueSerializer);
                    results.put(key, value);
                }
            }
            return results;
        }
        catch (Exception e) {
            throw new StateAccessException(e);
        }
    }

    @Override
    public void removeAll() {
        if (this.stateStorage.lazySerde()) {
            ((HeapStateStorage)this.stateStorage).removeAll();
        } else {
            try {
                if (!this.stateStorage.supportMultiColumnFamilies() && this.internalStateBackend.getStateStorages().size() > 1) {
                    for (Integer group : this.internalStateBackend.getKeyGroupRange()) {
                        this.outputStream.reset();
                        StateSerializerUtil.serializeGroupPrefix(this.outputStream, group, this.stateNameByte);
                        byte[] groupPrefix = this.outputStream.toByteArray();
                        this.outputStream.write(127);
                        byte[] groupPrefixEnd = this.outputStream.toByteArray();
                        StorageIterator iterator = this.stateStorage.subIterator(groupPrefix, groupPrefixEnd);
                        while (iterator.hasNext()) {
                            iterator.next();
                            iterator.remove();
                        }
                    }
                } else {
                    StorageIterator iterator = this.stateStorage.iterator();
                    while (iterator.hasNext()) {
                        iterator.next();
                        iterator.remove();
                    }
                }
            }
            catch (Exception e) {
                throw new StateAccessException(e);
            }
        }
    }

    @Override
    public Iterable<K> keys() {
        return new Iterable<K>(){

            @Override
            public Iterator<K> iterator() {
                try {
                    if (KeyedValueStateImpl.this.stateStorage.lazySerde()) {
                        final StorageIterator iterator = KeyedValueStateImpl.this.stateStorage.iterator();
                        return new Iterator<K>(){

                            @Override
                            public boolean hasNext() {
                                return iterator.hasNext();
                            }

                            @Override
                            public K next() {
                                return ((Pair)iterator.next()).getKey();
                            }

                            @Override
                            public void remove() {
                                iterator.remove();
                            }
                        };
                    }
                    if (!KeyedValueStateImpl.this.stateStorage.supportMultiColumnFamilies() && KeyedValueStateImpl.this.internalStateBackend.getStateStorages().size() > 1) {
                        ArrayList<Iterator<Pair<byte[], byte[]>>> groupIterators = new ArrayList<Iterator<Pair<byte[], byte[]>>>();
                        for (Integer group : KeyedValueStateImpl.this.internalStateBackend.getKeyGroupRange()) {
                            KeyedValueStateImpl.this.outputStream.reset();
                            StateSerializerUtil.serializeGroupPrefix(KeyedValueStateImpl.this.outputStream, group, KeyedValueStateImpl.this.stateNameByte);
                            byte[] groupPrefix = KeyedValueStateImpl.this.outputStream.toByteArray();
                            KeyedValueStateImpl.this.outputStream.write(127);
                            byte[] groupPrefixEnd = KeyedValueStateImpl.this.outputStream.toByteArray();
                            StorageIterator iterator = KeyedValueStateImpl.this.stateStorage.subIterator(groupPrefix, groupPrefixEnd);
                            groupIterators.add(iterator);
                        }
                        GroupIterator groupIterator = new GroupIterator(groupIterators);
                        return StateIteratorUtil.createKeyIterator(groupIterator, KeyedValueStateImpl.this.keySerializer, KeyedValueStateImpl.this.stateNameByte.length);
                    }
                    StorageIterator<byte[], byte[]> iterator = KeyedValueStateImpl.this.stateStorage.iterator();
                    return StateIteratorUtil.createKeyIterator(iterator, KeyedValueStateImpl.this.keySerializer, KeyedValueStateImpl.this.stateStorage.supportMultiColumnFamilies() ? 0 : KeyedValueStateImpl.this.stateNameByte.length);
                }
                catch (Exception e) {
                    throw new StateAccessException(e);
                }
            }
        };
    }

    @Override
    public <T> void transform(K key, T value, StateTransformationFunction<V, T> transformation) {
        try {
            if (this.stateStorage.lazySerde()) {
                ((HeapStateStorage)this.stateStorage).transform(key, value, transformation);
            } else {
                this.outputStream.reset();
                byte[] serializedKey = StateSerializerUtil.getSerializedKeyForKeyedValueState(this.outputStream, this.outputView, key, this.keySerializer, this.getKeyGroup(key), this.stateNameForSerializer);
                byte[] serializedValue = (byte[])this.stateStorage.get(serializedKey);
                Object oldValue = serializedValue == null ? null : (Object)StateSerializerUtil.getDeserializeSingleValue(serializedValue, this.valueSerializer);
                Object newValue = transformation.apply(oldValue, value);
                this.outputStream.reset();
                this.valueSerializer.serialize(newValue, this.outputView);
                this.stateStorage.put(serializedKey, this.outputStream.toByteArray());
            }
        }
        catch (Exception e) {
            throw new StateAccessException(e);
        }
    }

    @Override
    public byte[] getSerializedValue(byte[] serializedKeyAndNamespace, TypeSerializer<K> safeKeySerializer, TypeSerializer<V> safeValueSerializer) throws Exception {
        Object key = KvStateSerializer.deserializeKeyAndNamespace((byte[])serializedKeyAndNamespace, safeKeySerializer, (TypeSerializer)VoidNamespaceSerializer.INSTANCE).f0;
        if (this.stateStorage.lazySerde()) {
            V value = this.get(key);
            if (value == null) {
                return null;
            }
            return KvStateSerializer.serializeValue(value, safeValueSerializer);
        }
        ByteArrayOutputStreamWithPos baos = new ByteArrayOutputStreamWithPos();
        DataOutputViewStreamWrapper view = new DataOutputViewStreamWrapper((OutputStream)baos);
        return this.getSerializedValue(key, baos, (DataOutputView)view, safeKeySerializer);
    }

    @Override
    public StateStorage<K, V> getStateStorage() {
        return this.stateStorage;
    }

    private <K> int getKeyGroup(K key) {
        return partitioner.partition(key, this.internalStateBackend.getNumGroups());
    }

    private byte[] getSerializedValue(K key, ByteArrayOutputStreamWithPos outputStream, DataOutputView outputView, TypeSerializer<K> keySerializer) throws Exception {
        outputStream.reset();
        byte[] serializedKey = StateSerializerUtil.getSerializedKeyForKeyedValueState(outputStream, outputView, key, keySerializer, this.getKeyGroup(key), this.stateNameForSerializer);
        return (byte[])this.stateStorage.get(serializedKey);
    }
}

