/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.subkeyed;

import java.io.OutputStream;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.flink.api.common.functions.Comparator;
import org.apache.flink.api.common.typeutils.SerializationException;
import org.apache.flink.api.common.typeutils.base.StringSerializer;
import org.apache.flink.core.memory.ByteArrayOutputStreamWithPos;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.core.memory.DataOutputViewStreamWrapper;
import org.apache.flink.runtime.state.AbstractInternalStateBackend;
import org.apache.flink.runtime.state.StateAccessException;
import org.apache.flink.runtime.state.StateSerializerUtil;
import org.apache.flink.runtime.state.StateStorage;
import org.apache.flink.runtime.state.StorageIterator;
import org.apache.flink.runtime.state.heap.HeapStateStorage;
import org.apache.flink.runtime.state.subkeyed.AbstractSubKeyedMapStateImpl;
import org.apache.flink.runtime.state.subkeyed.SubKeyedSortedMapState;
import org.apache.flink.runtime.state.subkeyed.SubKeyedSortedMapStateDescriptor;
import org.apache.flink.types.Pair;
import org.apache.flink.util.Preconditions;

public final class SubKeyedSortedMapStateImpl<K, N, MK, MV>
extends AbstractSubKeyedMapStateImpl<K, N, MK, MV, SortedMap<MK, MV>>
implements SubKeyedSortedMapState<K, N, MK, MV> {
    private SubKeyedSortedMapStateDescriptor stateDescriptor;

    public SubKeyedSortedMapStateImpl(AbstractInternalStateBackend backend, SubKeyedSortedMapStateDescriptor<K, N, MK, MV> descriptor, StateStorage stateStorage) {
        super(backend, stateStorage);
        this.stateDescriptor = (SubKeyedSortedMapStateDescriptor)Preconditions.checkNotNull(descriptor);
        this.keySerializer = descriptor.getKeySerializer();
        this.namespaceSerializer = descriptor.getNamespaceSerializer();
        this.mapKeySerializer = descriptor.getMapKeySerializer();
        this.mapValueSerializer = descriptor.getMapValueSerializer();
        try {
            this.outputStream.reset();
            StringSerializer.INSTANCE.serialize(descriptor.getName(), this.outputView);
            this.stateNameByte = this.outputStream.toByteArray();
        }
        catch (Exception e) {
            throw new SerializationException((Throwable)e);
        }
        this.stateNameForSerialize = stateStorage.supportMultiColumnFamilies() ? null : this.stateNameByte;
        this.serializedStateNameLength = this.stateNameForSerialize == null ? 0 : this.stateNameForSerialize.length;
    }

    @Override
    public SubKeyedSortedMapStateDescriptor getDescriptor() {
        return this.stateDescriptor;
    }

    @Override
    SortedMap<MK, MV> createMap() {
        Comparator comparator = this.stateDescriptor.getComparator();
        return new TreeMap(comparator);
    }

    @Override
    public Map.Entry<MK, MV> firstEntry(K key, N namespace) {
        if (key == null || namespace == null) {
            return null;
        }
        try {
            if (this.stateStorage.lazySerde()) {
                ((HeapStateStorage)this.stateStorage).setCurrentNamespace(namespace);
                TreeMap map = (TreeMap)this.stateStorage.get(key);
                return map == null ? null : map.firstEntry();
            }
            this.outputStream.reset();
            byte[] prefixKey = StateSerializerUtil.getSerializedPrefixKeyForSubKeyedState(this.outputStream, this.outputView, key, this.keySerializer, namespace, this.namespaceSerializer, this.getKeyGroup(key), this.stateNameForSerialize);
            final Pair firstEntry = this.stateStorage.firstEntry(prefixKey);
            return new Map.Entry<MK, MV>(){

                @Override
                public MK getKey() {
                    try {
                        if (firstEntry == null || firstEntry.getKey() == null) {
                            return null;
                        }
                        return StateSerializerUtil.getDeserializedMapKeyForSubKeyedMapState((byte[])firstEntry.getKey(), SubKeyedSortedMapStateImpl.this.keySerializer, SubKeyedSortedMapStateImpl.this.namespaceSerializer, SubKeyedSortedMapStateImpl.this.mapKeySerializer, SubKeyedSortedMapStateImpl.this.serializedStateNameLength);
                    }
                    catch (Exception e) {
                        throw new StateAccessException(e);
                    }
                }

                @Override
                public MV getValue() {
                    try {
                        if (firstEntry == null || firstEntry.getValue() == null) {
                            return null;
                        }
                        return StateSerializerUtil.getDeserializeSingleValue((byte[])firstEntry.getValue(), SubKeyedSortedMapStateImpl.this.mapValueSerializer);
                    }
                    catch (Exception e) {
                        throw new StateAccessException(e);
                    }
                }

                @Override
                public MV setValue(MV value) {
                    return null;
                }
            };
        }
        catch (Exception e) {
            throw new StateAccessException(e);
        }
    }

    @Override
    public Map.Entry<MK, MV> lastEntry(K key, N namespace) {
        if (key == null || namespace == null) {
            return null;
        }
        try {
            if (this.stateStorage.lazySerde()) {
                ((HeapStateStorage)this.stateStorage).setCurrentNamespace(namespace);
                TreeMap map = (TreeMap)this.stateStorage.get(key);
                return map == null ? null : map.lastEntry();
            }
            this.outputStream.reset();
            byte[] prefixKey = StateSerializerUtil.getSerializedPrefixKeyEndForSubKeyedMapState(this.outputStream, this.outputView, key, this.keySerializer, namespace, this.namespaceSerializer, null, this.mapKeySerializer, this.getKeyGroup(key), this.stateNameForSerialize);
            final Pair firstEntry = this.stateStorage.lastEntry(prefixKey);
            return new Map.Entry<MK, MV>(){

                @Override
                public MK getKey() {
                    try {
                        if (firstEntry == null || firstEntry.getKey() == null) {
                            return null;
                        }
                        return StateSerializerUtil.getDeserializedMapKeyForSubKeyedMapState((byte[])firstEntry.getKey(), SubKeyedSortedMapStateImpl.this.keySerializer, SubKeyedSortedMapStateImpl.this.namespaceSerializer, SubKeyedSortedMapStateImpl.this.mapKeySerializer, SubKeyedSortedMapStateImpl.this.serializedStateNameLength);
                    }
                    catch (Exception e) {
                        throw new StateAccessException(e);
                    }
                }

                @Override
                public MV getValue() {
                    try {
                        if (firstEntry == null || firstEntry.getValue() == null) {
                            return null;
                        }
                        return StateSerializerUtil.getDeserializeSingleValue((byte[])firstEntry.getValue(), SubKeyedSortedMapStateImpl.this.mapValueSerializer);
                    }
                    catch (Exception e) {
                        throw new StateAccessException(e);
                    }
                }

                @Override
                public MV setValue(MV value) {
                    return null;
                }
            };
        }
        catch (Exception e) {
            throw new StateAccessException(e);
        }
    }

    @Override
    public Iterator<Map.Entry<MK, MV>> headIterator(K key, N namespace, MK endMapKey) {
        if (key == null || namespace == null || endMapKey == null) {
            return Collections.emptyIterator();
        }
        try {
            if (this.stateStorage.lazySerde()) {
                ((HeapStateStorage)this.stateStorage).setCurrentNamespace(namespace);
                TreeMap map = (TreeMap)this.stateStorage.get(key);
                return map == null ? null : map.headMap(endMapKey).entrySet().iterator();
            }
            this.outputStream.reset();
            byte[] prefixKey = StateSerializerUtil.getSerializedPrefixKeyForSubKeyedState(this.outputStream, this.outputView, key, this.keySerializer, namespace, this.namespaceSerializer, this.getKeyGroup(key), this.stateNameForSerialize);
            StateSerializerUtil.serializeItemWithKeyPrefix(this.outputView, endMapKey, this.mapKeySerializer);
            byte[] prefixKeyEnd = this.outputStream.toByteArray();
            return this.subIterator(prefixKey, prefixKeyEnd);
        }
        catch (Exception e) {
            throw new StateAccessException(e);
        }
    }

    @Override
    public Iterator<Map.Entry<MK, MV>> tailIterator(K key, N namespace, MK startMapKey) {
        if (key == null || namespace == null || startMapKey == null) {
            return Collections.emptyIterator();
        }
        try {
            if (this.stateStorage.lazySerde()) {
                ((HeapStateStorage)this.stateStorage).setCurrentNamespace(namespace);
                TreeMap map = (TreeMap)this.stateStorage.get(key);
                return map == null ? null : map.tailMap(startMapKey).entrySet().iterator();
            }
            this.outputStream.reset();
            StateSerializerUtil.getSerializedPrefixKeyForSubKeyedState(this.outputStream, this.outputView, key, this.keySerializer, namespace, this.namespaceSerializer, this.getKeyGroup(key), this.stateNameForSerialize);
            int namespacePosition = this.outputStream.getPosition();
            StateSerializerUtil.serializeItemWithKeyPrefix(this.outputView, startMapKey, this.mapKeySerializer);
            byte[] prefixKey = this.outputStream.toByteArray();
            this.outputStream.setPosition(namespacePosition);
            this.outputStream.write(127);
            byte[] prefixKeyEnd = this.outputStream.toByteArray();
            return this.subIterator(prefixKey, prefixKeyEnd);
        }
        catch (Exception e) {
            throw new StateAccessException(e);
        }
    }

    @Override
    public Iterator<Map.Entry<MK, MV>> subIterator(K key, N namespace, MK startMapKey, MK endMapKey) {
        if (key == null || namespace == null || startMapKey == null || endMapKey == null) {
            return Collections.emptyIterator();
        }
        try {
            if (this.stateStorage.lazySerde()) {
                ((HeapStateStorage)this.stateStorage).setCurrentNamespace(namespace);
                TreeMap map = (TreeMap)this.stateStorage.get(key);
                return map == null ? null : map.subMap(startMapKey, endMapKey).entrySet().iterator();
            }
            this.outputStream.reset();
            StateSerializerUtil.getSerializedPrefixKeyForSubKeyedState(this.outputStream, this.outputView, key, this.keySerializer, namespace, this.namespaceSerializer, this.getKeyGroup(key), this.stateNameForSerialize);
            int namespacePosition = this.outputStream.getPosition();
            StateSerializerUtil.serializeItemWithKeyPrefix(this.outputView, startMapKey, this.mapKeySerializer);
            byte[] prefixKey = this.outputStream.toByteArray();
            this.outputStream.setPosition(namespacePosition);
            StateSerializerUtil.serializeItemWithKeyPrefix(this.outputView, endMapKey, this.mapKeySerializer);
            byte[] prefixKeyEnd = this.outputStream.toByteArray();
            return this.subIterator(prefixKey, prefixKeyEnd);
        }
        catch (Exception e) {
            throw new StateAccessException(e);
        }
    }

    private Iterator<Map.Entry<MK, MV>> subIterator(byte[] prefixKeyStart, byte[] prefixKeyEnd) {
        if (this.stateStorage.lazySerde()) {
            return null;
        }
        try {
            final StorageIterator subIterator = this.stateStorage.subIterator(prefixKeyStart, prefixKeyEnd);
            return new Iterator<Map.Entry<MK, MV>>(){

                @Override
                public boolean hasNext() {
                    return subIterator.hasNext();
                }

                @Override
                public Map.Entry<MK, MV> next() {
                    final Pair nextByteEntry = (Pair)subIterator.next();
                    return new Map.Entry<MK, MV>(){

                        @Override
                        public MK getKey() {
                            try {
                                return StateSerializerUtil.getDeserializedMapKeyForSubKeyedMapState((byte[])nextByteEntry.getKey(), SubKeyedSortedMapStateImpl.this.keySerializer, SubKeyedSortedMapStateImpl.this.namespaceSerializer, SubKeyedSortedMapStateImpl.this.mapKeySerializer, SubKeyedSortedMapStateImpl.this.serializedStateNameLength);
                            }
                            catch (Exception e) {
                                throw new StateAccessException(e);
                            }
                        }

                        @Override
                        public MV getValue() {
                            try {
                                if (nextByteEntry == null || nextByteEntry.getValue() == null) {
                                    return null;
                                }
                                return StateSerializerUtil.getDeserializeSingleValue((byte[])nextByteEntry.getValue(), SubKeyedSortedMapStateImpl.this.mapValueSerializer);
                            }
                            catch (Exception e) {
                                throw new StateAccessException(e);
                            }
                        }

                        @Override
                        public MV setValue(MV value) {
                            Preconditions.checkNotNull(value);
                            try {
                                ByteArrayOutputStreamWithPos valueOutputStream = new ByteArrayOutputStreamWithPos();
                                DataOutputViewStreamWrapper valueOutputView = new DataOutputViewStreamWrapper((OutputStream)valueOutputStream);
                                SubKeyedSortedMapStateImpl.this.mapValueSerializer.serialize(value, (DataOutputView)valueOutputView);
                                byte[] oldValue = (byte[])nextByteEntry.setValue((Object)valueOutputStream.toByteArray());
                                if (oldValue == null) {
                                    return null;
                                }
                                return StateSerializerUtil.getDeserializeSingleValue(oldValue, SubKeyedSortedMapStateImpl.this.mapValueSerializer);
                            }
                            catch (Exception e) {
                                throw new StateAccessException(e);
                            }
                        }
                    };
                }

                @Override
                public void remove() {
                    subIterator.remove();
                }
            };
        }
        catch (Exception e) {
            throw new StateAccessException(e);
        }
    }
}

