/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.taskexecutor;

import java.io.Serializable;
import java.util.Objects;
import org.apache.flink.api.common.JobID;
import org.apache.flink.runtime.io.network.partition.ResultPartitionID;
import org.apache.flink.util.Preconditions;

public class ResultPartitionStatus
implements Serializable {
    private static final long serialVersionUID = 2283091321692010110L;
    private final JobID jobId;
    private final ResultPartitionID partitionId;

    public ResultPartitionStatus(JobID jobId, ResultPartitionID partitionId) {
        this.jobId = (JobID)Preconditions.checkNotNull((Object)jobId);
        this.partitionId = (ResultPartitionID)Preconditions.checkNotNull((Object)partitionId);
    }

    public JobID getJobId() {
        return this.jobId;
    }

    public ResultPartitionID getPartitionId() {
        return this.partitionId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResultPartitionStatus that = (ResultPartitionStatus)o;
        return Objects.equals(this.jobId, that.jobId) && Objects.equals(this.partitionId, that.partitionId);
    }

    public int hashCode() {
        return Objects.hash(this.jobId, this.partitionId);
    }

    public String toString() {
        return "ResultPartitionStatus{jobId=" + this.jobId + ", partitionId=" + this.partitionId + '}';
    }
}

